/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.credentials;

import com.ibm.ws.bluemix.utility.credentials.TargetInfo;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class ConfigJson {
    private static File getCfConfigFile() {
        String cfHome = System.getenv("CF_HOME");
        if (cfHome == null) {
            cfHome = System.getProperty("user.home");
        }
        return new File(cfHome, ".cf" + File.separator + "config.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetInfo load() throws IOException {
        JsonObject tokenInfo;
        File configFile = ConfigJson.getCfConfigFile();
        if (!FileUtils.fileExists((File)configFile)) {
            return null;
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(FileUtils.getInputStream((File)configFile), "UTF-8");
            JsonReader jsonReader = Json.createReader((Reader)reader);
            tokenInfo = jsonReader.readObject();
        }
        catch (Throwable throwable) {
            FileUtils.tryToClose(reader);
            throw throwable;
        }
        FileUtils.tryToClose((Closeable)reader);
        TargetInfo targetInfo = new TargetInfo();
        targetInfo.setAPI(tokenInfo.getString("Target"));
        targetInfo.setAuthorizationEndpoint(tokenInfo.getString("AuthorizationEndpoint"));
        targetInfo.setRefreshToken(tokenInfo.getString("RefreshToken"));
        targetInfo.setAccessToken(tokenInfo.getString("AccessToken"));
        JsonObject orgInfo = tokenInfo.getJsonObject("OrganizationFields");
        targetInfo.setOrganizationName(orgInfo.getString("Name"));
        targetInfo.setOrganizationGuid(orgInfo.getString("Guid"));
        JsonObject spaceInfo = tokenInfo.getJsonObject("SpaceFields");
        targetInfo.setSpaceName(spaceInfo.getString("Name"));
        targetInfo.setSpaceGuid(spaceInfo.getString("Guid"));
        return targetInfo;
    }
}

