/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.repository.client.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collective.member.Endpoint;
import com.ibm.ws.collective.repository.client.internal.CollectiveMarkerFile;
import com.ibm.ws.collective.repository.client.internal.RemoteConnectionHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.client.rest.ClientProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class RemoteConnectionHelperImpl
implements RemoteConnectionHelper,
NotificationListener {
    private static final TraceComponent tc = Tr.register(RemoteConnectionHelperImpl.class);
    private final JSSEHelper jsseHelper;
    private final List<Endpoint> endpoints;
    private final int readTimeoutMillis;
    private final String sslConfig;
    private final ObjectName objectName;
    private JMXConnector connector = null;
    private SSLSocketFactory sslSF = null;
    private MBeanServerConnection mbsc = null;
    private boolean connected = false;
    private boolean enableFailover = false;
    private final WsLocationAdmin locationAdmin;
    private volatile boolean beforeFirstInvoke = true;
    private CollectiveMarkerFile markerFile;
    private final Object memberLock = new Object(){
        static final long serialVersionUID = -1070852058583386881L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    static final long serialVersionUID = 6662950977063614813L;

    /*
     * WARNING - void declaration
     */
    public RemoteConnectionHelperImpl(JSSEHelper jsseHelper, WsLocationAdmin locationAdmin, List<Endpoint> endpoints, int readTimeoutMillis, String sslConfig) {
        this.jsseHelper = jsseHelper;
        this.locationAdmin = locationAdmin;
        this.endpoints = endpoints;
        this.readTimeoutMillis = readTimeoutMillis;
        this.sslConfig = sslConfig;
        try {
            this.objectName = new ObjectName("WebSphere:feature=collectiveController,type=CollectiveRepository,name=CollectiveRepository");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            void e;
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.collective.repository.client.internal.RemoteConnectionHelperImpl", (String)"88", (Object)this, (Object[])new Object[]{jsseHelper, locationAdmin, endpoints, readTimeoutMillis, sslConfig});
            throw new IllegalStateException("Unable to create object name", (Throwable)e);
        }
        catch (NullPointerException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteConnectionHelperImpl", (String)"90", (Object)this, (Object[])new Object[]{jsseHelper, locationAdmin, endpoints, readTimeoutMillis, sslConfig});
            throw new IllegalStateException("Unable to create object name due to a null pointer", e);
        }
        if (endpoints == null || endpoints.size() < 1) {
            throw new IllegalArgumentException("No collective controller endpoints were provided");
        }
    }

    private JMXConnector createConnector(List<Endpoint> endpoints) throws IOException, MalformedURLException, SSLConfigurationNotAvailableException {
        this.sslSF = this.getSSLSocketFactory();
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("com.ibm.ws.jmx.connector.client.CUSTOM_SSLSOCKETFACTORY", this.sslSF);
        environment.put("jmx.remote.protocol.provider.pkgs", "com.ibm.ws.jmx.connector.client");
        environment.put("jmx.remote.credentials", "com.ibm.ws.jmx.connector.client.CLIENT_CERT_AUTH");
        environment.put("com.ibm.ws.jmx.connector.client.rest.readTimeout", this.readTimeoutMillis);
        environment.put("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", Boolean.TRUE);
        environment.put("com.ibm.ws.jmx.connector.client.rest.notificationFetchInterval", 10000);
        environment.put("com.ibm.ws.jmx.connector.client.wlm.endpoints", Endpoint.getStringList(endpoints));
        if (endpoints.size() > 1) {
            environment.put("com.ibm.ws.jmx.connector.client.rest.maxServerWaitTime", 5000);
        }
        JMXServiceURL serviceURL = new JMXServiceURL("REST", endpoints.get(0).getHost(), endpoints.get(0).getPort(), "/IBMJMXConnectorREST");
        return new ClientProvider().newJMXConnector(serviceURL, environment);
    }

    @FFDCIgnore(value={SSLConfigurationNotAvailableException.class})
    private SSLSocketFactory getSSLSocketFactory() throws IOException, SSLConfigurationNotAvailableException {
        SSLContext context = null;
        String failureMessage = "Could not get an SSL context for the specified SSL configuration: " + this.sslConfig + ". Check that the specified SSL configuration is correct.";
        try {
            context = this.jsseHelper.getSSLContext(this.sslConfig, null, null, false);
        }
        catch (SSLConfigurationNotAvailableException e) {
            throw e;
        }
        catch (SSLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteConnectionHelperImpl", (String)"143", (Object)this, (Object[])new Object[0]);
            throw new IOException(failureMessage, e);
        }
        if (context == null) {
            throw new IllegalStateException(failureMessage);
        }
        SSLSocketFactory factory = context.getSocketFactory();
        if (factory == null) {
            throw new IllegalStateException("Factory from context was null");
        }
        return factory;
    }

    private IOException asExplainedIOException(Exception e, String msg) throws IOException {
        String message = null;
        message = msg != null && msg.length() > 0 ? msg : "A network, communication or security error has occured while trying to invoke the MBean " + this.objectName + " on the target collective controller. Cause: " + e.getMessage();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[]{e});
        }
        return new IOException(message, e);
    }

    @Trivial
    @FFDCIgnore(value={IOException.class, SSLConfigurationNotAvailableException.class})
    private synchronized void connect() throws IOException {
        if (!this.connected) {
            try {
                this.setupConnection(this.endpoints);
                this.connected = true;
                Tr.info((TraceComponent)tc, (String)"REMOTE_REPOSITORY_CONNECTION_ESTABLISHED", (Object[])new Object[0]);
            }
            catch (SSLConfigurationNotAvailableException e) {
                String msg = "Unable to connect to the collective controller endpoints.  The SSL configuration is not ready yet.  Connection will be retried.";
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)msg, (Object[])new Object[]{e});
                }
                throw this.asExplainedIOException((Exception)((Object)e), msg);
            }
            catch (IOException e) {
                Tr.info((TraceComponent)tc, (String)"REMOTE_REPOSITORY_CONNECTION_UNAVAILABLE", (Object[])new Object[]{this.endpoints});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unable to connect to any of the collective controller endpoints.  Attempted to connect to: " + this.endpoints), (Object[])new Object[]{e});
                }
                throw this.asExplainedIOException(e, null);
            }
        }
    }

    private void setupConnection(List<Endpoint> endpoints) throws IOException, SSLConfigurationNotAvailableException {
        this.disconnectRemoteConnection();
        this.connector = this.createConnector(endpoints);
        this.connector.connect();
        this.connector.addConnectionNotificationListener(this, null, null);
        this.mbsc = this.connector.getMBeanServerConnection();
        this.connected = true;
    }

    @Override
    public Object invoke(String operationName, @Sensitive Object[] params, String[] signature) throws IOException {
        if (this.isMember()) {
            this.connect();
            return this.doInvoke(this.mbsc, this.objectName, operationName, params, signature);
        }
        ConnectException ce = new ConnectException("Connection failed.  Client is not a member joined to this collective.");
        ce.fillInStackTrace();
        throw ce;
    }

    @Trivial
    private synchronized CollectiveMarkerFile getMarkerFile() {
        if (this.markerFile == null) {
            this.markerFile = new CollectiveMarkerFile(this.locationAdmin);
        }
        return this.markerFile;
    }

    synchronized void setMarkerFile(CollectiveMarkerFile f) {
        this.markerFile = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMember() {
        boolean isMember = true;
        Object object = this.memberLock;
        synchronized (object) {
            if (this.beforeFirstInvoke) {
                this.getMarkerFile().create();
                this.beforeFirstInvoke = false;
            } else {
                isMember = this.getMarkerFile().exists();
            }
        }
        return isMember;
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public void disconnectRemoteConnection() {
        block3: {
            try {
                if (this.connector != null) {
                    this.connector.close();
                }
            }
            catch (IOException e) {
                if (!tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)"Unable to successfully close the JMXConnection. This may result in some unexpected behaviours in listening threads.", (Object[])new Object[]{e});
            }
        }
    }

    @Trivial
    String buildInvokeDebugString(ObjectName objectName, String operationName, Object[] params, String[] signature) {
        StringBuffer invokeString = new StringBuffer("invoke(");
        invokeString.append(objectName.toString());
        invokeString.append(", ");
        invokeString.append(operationName);
        invokeString.append(", ");
        this.addListToInvokeDebugString(invokeString, params);
        invokeString.append(", ");
        this.addListToInvokeDebugString(invokeString, signature);
        invokeString.append(")");
        return invokeString.toString();
    }

    @Trivial
    private void addListToInvokeDebugString(StringBuffer stringBuffer, Object[] params) {
        if (stringBuffer != null) {
            stringBuffer.append("{ ");
            if (params == null) {
                stringBuffer.append("null");
            } else {
                for (Object param : params) {
                    if (param == null) {
                        stringBuffer.append("null, ");
                        continue;
                    }
                    stringBuffer.append(param.toString());
                    stringBuffer.append(", ");
                }
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            }
            stringBuffer.append(" }");
        }
    }

    private void markDisconnected() {
        this.connected = false;
        Tr.info((TraceComponent)tc, (String)"REMOTE_REPOSITORY_CONNECTION_LOST", (Object[])new Object[0]);
    }

    @FFDCIgnore(value={ConnectException.class, IOException.class, RuntimeMBeanException.class, MBeanException.class, InstanceNotFoundException.class})
    Object doInvoke(MBeanServerConnection mbsc, ObjectName objectName, String operationName, @Sensitive Object[] params, String[] signature) throws IOException {
        if (mbsc == null) {
            throw new IllegalStateException("MBeanServerConnection is null, bootstrap() did not succeed.");
        }
        try {
            return mbsc.invoke(objectName, operationName, params, signature);
        }
        catch (ConnectException e) {
            this.markDisconnected();
            throw this.asExplainedIOException(e, null);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketException) {
                throw this.asExplainedIOException(e, null);
            }
            if (cause instanceof SocketTimeoutException) {
                this.markDisconnected();
            }
            if (cause instanceof ConnectException || e.getMessage().contains("CWWKX0206E") || e.getMessage().contains("CWWKX9071E")) {
                this.markDisconnected();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught IOException message: " + e.getMessage()), (Object[])new Object[0]);
            }
            throw this.asExplainedIOException(e, null);
        }
        catch (InstanceNotFoundException e) {
            String message = "Could not find " + objectName + " on the target collective controller.";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught InstanceNotFoundException", (Object[])new Object[]{message, e});
            }
            throw new IllegalStateException(message, e);
        }
        catch (ReflectionException e) {
            Object[] objectArray = new Object[5];
            objectArray[0] = mbsc;
            objectArray[1] = objectName;
            objectArray[2] = operationName;
            objectArray[3] = "<sensitive java.lang.Object[]>";
            objectArray[4] = signature;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.repository.client.internal.RemoteConnectionHelperImpl", (String)"427", (Object)this, (Object[])objectArray);
            String invokeString = this.buildInvokeDebugString(objectName, operationName, params, signature);
            String message = "An error occurred while invoking " + invokeString + " on the target MBean " + objectName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught ReflectionException", (Object[])new Object[]{message, e});
            }
            throw new IllegalStateException(message, e);
        }
        catch (RuntimeMBeanException e) {
            Throwable cause = e.getCause();
            String invokeString = this.buildInvokeDebugString(objectName, operationName, params, signature);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught RuntimeMBeanException (will re-throw cause) while executing " + invokeString + ". Caught " + cause.toString()), (Object[])new Object[]{e, cause});
            }
            if (e.getMessage().contains("CWWKX9002E")) {
                this.markDisconnected();
            }
            throw (RuntimeException)e.getCause();
        }
        catch (MBeanException e) {
            Throwable cause = e.getCause();
            String invokeString = this.buildInvokeDebugString(objectName, operationName, params, signature);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught MBeanException (will re-throw cause) while executing " + invokeString + ". Caught " + cause.toString()), (Object[])new Object[]{e, cause});
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            String message = "Caught an unexpected exception during " + invokeString + ". Caught " + cause.toString();
            throw new IllegalStateException(message, cause);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if (type.contains("jmx.remote.connection.failed") || type.contains("com.ibm.ws.jmx.connector.client.rest.connectionTemporarilyLost")) {
            this.enableFailover = true;
        }
    }

    @Override
    public boolean isFailoverEnabled() {
        return this.enableFailover;
    }

    @Override
    public void resetFailover() {
        this.enableFailover = false;
    }
}

