/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.asset.InstallAsset;
import com.ibm.ws.repository.resources.IfixResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class FixAsset
extends InstallAsset {
    private JarFile jar = null;
    private Attributes mainAttributes = null;
    private String jarPath = null;
    private IfixResource ifixResource = null;

    public FixAsset(String id, File assetFile, boolean isTemporary) throws ZipException, IOException {
        super(id, assetFile, isTemporary);
        this.jar = new JarFile(assetFile);
        this.mainAttributes = this.jar.getManifest().getMainAttributes();
        this.jarPath = assetFile.getAbsolutePath();
    }

    public FixAsset(String id, IfixResource ifixResource) {
        super(id, null);
        this.ifixResource = ifixResource;
    }

    @Override
    public boolean isFix() {
        return true;
    }

    public JarFile getJar() {
        return this.jar;
    }

    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    @Override
    public void delete() {
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.delete();
    }

    @Override
    public String installedLogMsg() {
        return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALLED_FIX", this.toString());
    }

    public String getJarPath() {
        return this.jarPath;
    }

    @Override
    public RepositoryResource getRepositoryResource() {
        return this.ifixResource;
    }

    @Override
    public void download(File installTempDir) throws InstallException {
        if (this.ifixResource == null) {
            return;
        }
        this.asset = this.download(installTempDir, (RepositoryResource)this.ifixResource);
        if (this.asset != null) {
            try {
                this.jar = new JarFile(this.asset);
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNABLE_READ_FILE", this.getAsset().getAbsoluteFile(), e.getMessage()), e, 21);
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.ifixResource == null) {
            return;
        }
        super.delete();
        this.jar = null;
        this.asset = null;
    }
}

