/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.adaptor;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.asset.FixAsset;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.extension.IFixUtils;
import com.ibm.ws.product.utility.extension.ifix.xml.BundleFile;
import com.ibm.ws.product.utility.extension.ifix.xml.Bundles;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.LibertyProfileMetadataFile;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FixAdaptor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.install");

    public static int install(Product product, FixAsset fixAsset) throws IOException, InstallException {
        File java = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        String[] runtimeCmd = new String[]{java.getAbsolutePath(), "-jar", fixAsset.getJarPath(), product.getInstallDir().getAbsolutePath()};
        logger.log(Level.FINEST, java.getAbsolutePath() + " -jar " + fixAsset.getJarPath() + " " + product.getInstallDir().getAbsolutePath());
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(runtimeCmd, null, product.getInstallDir());
        StringBuffer stdout = new StringBuffer();
        Thread stderrCopier = new Thread(new InstallUtils.OutputStreamCopier(process.getErrorStream(), stdout));
        stderrCopier.start();
        new InstallUtils.OutputStreamCopier(process.getInputStream(), stdout).run();
        try {
            stderrCopier.join();
            process.waitFor();
            if (process.exitValue() != 0) {
                // empty if block
            }
        }
        catch (InterruptedException e) {
            throw new InstallException(e.getMessage(), e.getCause(), 21);
        }
        finally {
            logger.log(Level.FINEST, "stdout/stderr: " + stdout.toString());
            logger.log(Level.FINEST, "exit code: " + process.exitValue());
        }
        return process.exitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstallFix(IFixInfo fixInfo, File baseDir, List<File> filesRestored) throws ParserConfigurationException, IOException, SAXException {
        Closeable fis = null;
        boolean success = false;
        try {
            Set updatedFiles = fixInfo.getUpdates().getFiles();
            for (UpdatedFile file : updatedFiles) {
                File filePath = new File(baseDir, file.getId());
                InstallUtils.delete(filePath);
            }
            File backupFile = new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".zip");
            if (backupFile.exists() && backupFile.length() > 0L) {
                ZipFile backupZip = new ZipFile(backupFile);
                Enumeration<? extends ZipEntry> entries = backupZip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    long timeStamp = ze.getTime();
                    File restoreFile = new File(baseDir, ze.getName());
                    FixAdaptor.extract(restoreFile, backupZip.getInputStream(ze));
                    if (restoreFile.exists()) {
                        logger.log(Level.FINEST, "uninstall " + fixInfo.getId() + " restored " + restoreFile.getAbsolutePath());
                        filesRestored.add(restoreFile);
                        InstallUtils.setLastModifiedTime(new File(baseDir, ze.getName()), timeStamp);
                        continue;
                    }
                    logger.log(Level.FINEST, "uninstall " + fixInfo.getId() + " failed to restore " + restoreFile.getAbsolutePath());
                }
                backupZip.close();
            }
            success = true;
        }
        finally {
            InstallUtils.close(fis);
            if (success) {
                InstallUtils.delete(new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".xml"));
                InstallUtils.delete(new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".zip"));
                InstallUtils.delete(new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".lpmf"));
            }
        }
    }

    public static Set<LibertyProfileMetadataFile> getInstalledLibertyProfileMetadataFiles(File baseDir) {
        return IFixUtils.getInstalledLibertyProfileMetadataFiles((File)baseDir, (CommandConsole)new InstallUtils.InstallCommandConsole());
    }

    public static Set<IFixInfo> getInstalledIFixes(File baseDir) {
        return IFixUtils.getInstalledIFixes((File)baseDir, (CommandConsole)new InstallUtils.InstallCommandConsole());
    }

    public static void removeFilesFromBackup(File baseDir, Collection<File> fileSet) throws ZipException, IOException {
        Set<IFixInfo> ifixInfoSet = FixAdaptor.getInstalledIFixes(baseDir);
        HashSet<String> fileEntrySet = new HashSet<String>();
        for (File f : fileSet) {
            if (f == null) continue;
            fileEntrySet.add(InstallUtils.getRelativePath(baseDir, f));
        }
        for (IFixInfo iFixInfo : ifixInfoSet) {
            File backupFile = new File(baseDir, "/lib/fixes/" + iFixInfo.getId() + "_" + iFixInfo.getVersion() + ".zip");
            if (!backupFile.exists()) continue;
            InstallUtils.deleteZipEntry(backupFile, fileEntrySet);
        }
    }

    public static Set<IFixInfo> getUninstallFixInfo(File baseDir, Collection<File> fileSet) {
        HashSet<IFixInfo> fixInfo = new HashSet<IFixInfo>();
        Set<IFixInfo> ifixInfoSet = FixAdaptor.getInstalledIFixes(baseDir);
        for (IFixInfo iFixInfo : ifixInfoSet) {
            Set updateFiles = iFixInfo.getUpdates().getFiles();
            HashSet<String> updateFileSet = new HashSet<String>();
            HashSet<String> toBeRemovedFileSet = new HashSet<String>();
            block1: for (UpdatedFile updatedFile : updateFiles) {
                updateFileSet.add(updatedFile.getId());
                for (File file : fileSet) {
                    if (file == null || !updatedFile.getId().equals(InstallUtils.getRelativePath(baseDir, file))) continue;
                    toBeRemovedFileSet.add(updatedFile.getId());
                    continue block1;
                }
            }
            if (toBeRemovedFileSet.size() <= 0) continue;
            updateFileSet.removeAll(toBeRemovedFileSet);
            boolean uninstallFix = true;
            if (updateFileSet.size() > 0) {
                for (String updateFile : updateFileSet) {
                    if (!new File(baseDir, updateFile).exists()) continue;
                    uninstallFix = false;
                    break;
                }
            }
            if (!uninstallFix) continue;
            fixInfo.add(iFixInfo);
        }
        return fixInfo;
    }

    public static HashMap<String, File> getBundleFiles(File baseDir, Set<String> symbolicNames) {
        HashMap<String, File> bundleFileList = new HashMap<String, File>();
        Set<LibertyProfileMetadataFile> lpmf = FixAdaptor.getInstalledLibertyProfileMetadataFiles(baseDir);
        for (LibertyProfileMetadataFile chklpmf : lpmf) {
            List bundleEntries;
            Bundles bundles = chklpmf.getBundles();
            if (bundles == null || (bundleEntries = bundles.getBundleFiles()) == null) continue;
            for (BundleFile bundleFile : bundleEntries) {
                for (String symbolicName : symbolicNames) {
                    if (!symbolicName.equals(bundleFile.getSymbolicName())) continue;
                    bundleFileList.put(symbolicName, new File(baseDir, bundleFile.getId()));
                }
            }
        }
        return bundleFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(File targetFile, InputStream zis) throws IOException {
        byte[] buf = new byte[4096];
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile, false));
        try {
            int read;
            while ((read = zis.read(buf)) != -1) {
                ((OutputStream)os).write(buf, 0, read);
            }
        }
        finally {
            InstallUtils.close(os);
        }
    }

    private static void isFileLocked(String fix, File f) throws InstallException {
        InstallUtils.isFileLocked("ERROR_UNINSTALL_FIX_FILE_LOCKED", fix, f);
    }

    public static void preCheck(IFixInfo fixInfo, File baseDir) throws InstallException {
        Set updatedFiles = fixInfo.getUpdates().getFiles();
        for (UpdatedFile file : updatedFiles) {
            File filePath = new File(baseDir, file.getId());
            FixAdaptor.isFileLocked(fixInfo.getId(), filePath);
        }
        File backupFile = new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".zip");
        if (backupFile.exists() && backupFile.length() > 0L) {
            ZipFile backupZip = null;
            try {
                backupZip = new ZipFile(backupFile);
                Enumeration<? extends ZipEntry> entries = backupZip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    FixAdaptor.isFileLocked(fixInfo.getId(), new File(baseDir, ze.getName()));
                }
            }
            catch (ZipException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_FIX_INVALID_META_DATA", fixInfo.getId()));
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_UNINSTALL_FIX_INVALID_META_DATA", fixInfo.getId()));
            }
            finally {
                if (backupZip != null) {
                    try {
                        backupZip.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        FixAdaptor.isFileLocked(fixInfo.getId(), new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".xml"));
        FixAdaptor.isFileLocked(fixInfo.getId(), new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".zip"));
        FixAdaptor.isFileLocked(fixInfo.getId(), new File(baseDir, "/lib/fixes/" + fixInfo.getId() + "_" + fixInfo.getVersion() + ".lpmf"));
    }
}

