/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.asset.ESAAsset;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class Product {
    private static final String PRODUCT_ID = "com.ibm.websphere.productId";
    private static final String PRODUCT_VERSION = "com.ibm.websphere.productVersion";
    private static final String PRODUCT_EDITION = "com.ibm.websphere.productEdition";
    private static final String PRODUCT_PROPERTIES_PATH = "lib/versions/WebSphereApplicationServer.properties";
    private static final String PRODUCT_INSTALL_TYPE = "com.ibm.websphere.productInstallType";
    private File installDir;
    private File installTempDir;
    private File userDir;
    private File userExtensionDir;
    private Properties productProperties;
    private Map<String, ProvisioningFeatureDefinition> featureDefs;
    private Map<String, ProvisioningFeatureDefinition> installFeatureDefs;
    private ManifestFileProcessor mfp;

    public Product(File installDir) {
        if (installDir != null) {
            this.installDir = installDir;
            Utils.setInstallDir((File)this.installDir);
        } else {
            this.installDir = Utils.getInstallDir();
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void refresh() {
        this.productProperties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(this.installDir, PRODUCT_PROPERTIES_PATH));
            this.productProperties.load(fis);
        }
        catch (Exception exception) {
            InstallUtils.close(fis);
            catch (Throwable throwable) {
                InstallUtils.close(fis);
                throw throwable;
            }
        }
        InstallUtils.close(fis);
        this.featureDefs = null;
        this.installFeatureDefs = null;
        this.mfp = null;
    }

    public String getProductId() {
        return this.productProperties.getProperty(PRODUCT_ID);
    }

    public String getProductVersion() {
        return this.productProperties.getProperty(PRODUCT_VERSION);
    }

    public String getProductEdition() {
        return this.productProperties.getProperty(PRODUCT_EDITION);
    }

    public String getProductInstallType() {
        return this.productProperties.getProperty(PRODUCT_INSTALL_TYPE);
    }

    ManifestFileProcessor getManifestFileProcessor() {
        if (this.mfp == null) {
            this.mfp = new ManifestFileProcessor();
        }
        return this.mfp;
    }

    public Map<String, ProvisioningFeatureDefinition> getFeatureDefinitions() {
        if (this.featureDefs == null) {
            this.featureDefs = this.getManifestFileProcessor().getFeatureDefinitions();
        }
        return this.featureDefs;
    }

    public Map<String, ProvisioningFeatureDefinition> getCoreFeatureDefinitions() {
        return this.getManifestFileProcessor().getFeatureDefinitions("core");
    }

    public Map<String, ProvisioningFeatureDefinition> getCoreFeatureDefinitionsExceptPlatform() {
        return this.getManifestFileProcessor().getCoreFeatureDefinitionsExceptPlatform();
    }

    public Map<String, ProvisioningFeatureDefinition> getFeatureCollectionDefinitions() {
        if (this.installFeatureDefs == null) {
            this.installFeatureDefs = this.getManifestFileProcessor().getInstallFeatureDefinitions();
        }
        return this.installFeatureDefs;
    }

    public Map<String, ProvisioningFeatureDefinition> getAllFeatureDefinitions() {
        TreeMap<String, ProvisioningFeatureDefinition> map = new TreeMap<String, ProvisioningFeatureDefinition>();
        map.putAll(this.getFeatureDefinitions());
        map.putAll(this.getFeatureCollectionDefinitions());
        return map;
    }

    public Map<String, ProvisioningFeatureDefinition> getAllCoreFeatureDefinitions() {
        TreeMap<String, ProvisioningFeatureDefinition> map = new TreeMap<String, ProvisioningFeatureDefinition>();
        map.putAll(this.getCoreFeatureDefinitions());
        map.putAll(this.getFeatureCollectionDefinitions());
        return map;
    }

    public Map<String, ProvisioningFeatureDefinition> getAllCoreFeatureDefinitionsExceptPlatform() {
        TreeMap<String, ProvisioningFeatureDefinition> map = new TreeMap<String, ProvisioningFeatureDefinition>();
        map.putAll(this.getCoreFeatureDefinitionsExceptPlatform());
        map.putAll(this.getFeatureCollectionDefinitions());
        return map;
    }

    public File getInstallTempDir() {
        if (this.installTempDir == null) {
            this.installTempDir = new File(this.getInstallDir(), "installTmp");
        }
        return this.installTempDir;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public File getUserDir() {
        if (this.userDir == null) {
            this.userDir = Utils.getUserDir();
        }
        return this.userDir;
    }

    public File getUserExtensionDir() {
        if (this.userExtensionDir == null) {
            this.userExtensionDir = new File(this.getUserDir(), "extension");
        }
        return this.userExtensionDir;
    }

    public File getUserDirExternal(String repoType) throws InstallException {
        File baseDir;
        block6: {
            try {
                ProductExtensionInfo productExtension = ProductExtension.getProductExtension((String)repoType);
                if (productExtension == null) {
                    throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.extension", repoType), 20);
                }
                String featurePath = productExtension.getLocation();
                if (featurePath != null) {
                    String normalizedPath = PathUtils.normalize((String)featurePath);
                    if (!PathUtils.pathIsAbsolute((String)normalizedPath)) {
                        File parentfile = Utils.getInstallDir().getParentFile();
                        baseDir = new File(parentfile, featurePath);
                    } else {
                        baseDir = new File(normalizedPath);
                    }
                    break block6;
                }
                throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.invalid.extension", repoType));
            }
            catch (IOException e) {
                throw new InstallException(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.ioexception.extension", repoType, e.getMessage()));
            }
        }
        return baseDir;
    }

    public boolean containsFeature(String featureName) {
        return this.getFeatureDefinitions().containsKey(featureName);
    }

    public void addFeature(String name, ProvisioningFeatureDefinition fd) {
        this.getFeatureDefinitions().put(name, fd);
    }

    public boolean containsFeatureCollection(String featureCollectionName) {
        return this.getFeatureCollectionDefinitions().containsKey(featureCollectionName);
    }

    public void addFeatureCollection(String name, ProvisioningFeatureDefinition fd) {
        this.getFeatureCollectionDefinitions().put(name, fd);
    }

    public Set<String> getAcceptedLicenses() {
        HashSet<String> acceptedLicenses = new HashSet<String>();
        for (ProvisioningFeatureDefinition fd : this.getAllFeatureDefinitions().values()) {
            String subsystemLicenseType = fd.getHeader("Subsystem-License");
            if (subsystemLicenseType == null || subsystemLicenseType.isEmpty()) continue;
            acceptedLicenses.add(subsystemLicenseType);
        }
        return acceptedLicenses;
    }

    public List<String> getExtensionNames() {
        ArrayList<String> extensionNames = new ArrayList<String>(0);
        List productExtensionInfoList = ProductExtension.getProductExtensions((File)this.getInstallDir());
        for (ProductExtensionInfo productExtensionInfo : productExtensionInfoList) {
            extensionNames.add(productExtensionInfo.getName());
        }
        return extensionNames;
    }

    public Set<String> getInstalledFeatures(String installedBy) {
        Map map = this.getManifestFileProcessor().getFeatureDefinitions(installedBy);
        return map == null ? new HashSet(0) : map.keySet();
    }

    public Set<String> getInstalledFeatures() {
        return new HashSet<String>(this.getFeatureDefinitions().keySet());
    }

    public boolean isInstalled(RepositoryResource installResource) {
        if (installResource instanceof EsaResource) {
            EsaResource esa = (EsaResource)installResource;
            String symName = esa.getProvideFeature();
            return this.containsFeature(symName) || this.containsFeatureCollection(symName);
        }
        return false;
    }

    public boolean isInstalled(ESAAsset esa) {
        String symName = esa.getFeatureName();
        return this.containsFeature(symName) || this.containsFeatureCollection(symName);
    }
}

