/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.CancelException;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.ArchiveUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class InstallKernelMap
implements Map {
    private static final String MAP_BASED_INSTALL_KERNEL = "mapBasedInstallKernel";
    private static final String RUNTIME_INSTALL_DIR = "runtime.install.dir";
    private static final String LICENSE_ACCEPT = "license.accept";
    private static final String REPOSITORIES_PROPERTIES = "repositories.properties";
    private static final String DOWLOAD_EXTERNAL_DEPS = "dowload.external.deps";
    private static final String USER_AGENT = "user.agent";
    private static final String PROGRESS_MONITOR_MESSAGE = "progress.monitor.message";
    private static final String PROGRESS_MONITOR_CANCELLED = "progress.monitor.cancelled";
    private static final String PROGRESS_MONITOR_SIZE = "progress.monitor.size";
    private static final String TARGET_USER_DIRECTORY = "target.user.directory";
    private static final String INSTALL_KERNEL_INIT_CODE = "install.kernel.init.code";
    private static final String INSTALL_KERNEL_INIT_ERROR_MESSAGE = "install.kernel.init.error.message";
    private static final String UNINSTALL_USER_FEATURES = "uninstall.user.features";
    private static final String FORCE_UNINSTALL = "force.uninstall";
    private static final String ACTION_INSTALL = "action.install";
    private static final String ACTION_INSTALL_RESULT = "action.install.result";
    private static final String ACTION_UNINSTALL = "action.uninstall";
    private static final String ACTION_RESULT = "action.result";
    private static final String ACTION_ERROR_MESSAGE = "action.error.message";
    private static final String MESSAGE_LOCALE = "message.locale";
    private static final Integer OK = 0;
    private static final Integer CANCELLED = -1;
    private static final Integer ERROR = 1;
    private final Map data = new HashMap();
    private InstallKernelInteractive installKernel;
    private InstallEventListener ielistener;
    private ActionType actionType = null;

    public InstallKernelMap() {
        this.data.put(LICENSE_ACCEPT, Boolean.FALSE);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        if (INSTALL_KERNEL_INIT_CODE.equals(key)) {
            return this.initKernel();
        }
        if (ACTION_RESULT.equals(key)) {
            if (this.actionType.equals((Object)ActionType.install)) {
                return this.install();
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return this.uninstall();
            }
            if (this.actionType.equals((Object)ActionType.resolve)) {
                return this.data.get(ACTION_RESULT);
            }
        } else if (PROGRESS_MONITOR_SIZE.equals(key)) {
            return this.getMonitorSize();
        }
        return this.data.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value) {
        if (LICENSE_ACCEPT.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(LICENSE_ACCEPT, value);
            return this.data.get(key);
        } else if (RUNTIME_INSTALL_DIR.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(RUNTIME_INSTALL_DIR, value);
            return this.data.get(key);
        } else if (REPOSITORIES_PROPERTIES.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(REPOSITORIES_PROPERTIES, value);
            System.setProperty("WLP_REPOSITORIES_PROPS", ((File)value).getAbsolutePath());
            try {
                Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
                if (repoProperties == null) return this.data.get(key);
                this.installKernel.setRepositoryProperties(repoProperties);
                return this.data.get(key);
            }
            catch (InstallException e) {
                throw new RuntimeException(e);
            }
        } else if (DOWLOAD_EXTERNAL_DEPS.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(DOWLOAD_EXTERNAL_DEPS, value);
            return this.data.get(key);
        } else if (USER_AGENT.equals(key)) {
            if (!(value instanceof String)) throw new IllegalArgumentException();
            this.data.put(USER_AGENT, value);
            if (this.installKernel == null) return this.data.get(key);
            this.installKernel.setUserAgent((String)value);
            return this.data.get(key);
        } else if (TARGET_USER_DIRECTORY.equals(key)) {
            if (!(value instanceof File)) throw new IllegalArgumentException();
            this.data.put(TARGET_USER_DIRECTORY, value);
            Utils.setUserDir((File)((File)value));
            return this.data.get(key);
        } else if (MESSAGE_LOCALE.equals(key)) {
            if (!(value instanceof Locale)) throw new IllegalArgumentException();
            this.data.put(MESSAGE_LOCALE, value);
            InstallLogUtils.Messages.setLocale((Locale)value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_MESSAGE.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_MESSAGE, value);
            return this.data.get(key);
        } else if (PROGRESS_MONITOR_CANCELLED.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(PROGRESS_MONITOR_CANCELLED, value);
            return this.data.get(key);
        } else if (ACTION_INSTALL.equals(key)) {
            if (!(value instanceof List) && !(value instanceof File)) throw new IllegalArgumentException();
            this.resolve(value);
            return this.data.get(key);
        } else if (UNINSTALL_USER_FEATURES.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(UNINSTALL_USER_FEATURES, value);
            return this.data.get(key);
        } else if (FORCE_UNINSTALL.equals(key)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException();
            this.data.put(FORCE_UNINSTALL, value);
            return this.data.get(key);
        } else if (ACTION_UNINSTALL.equals(key)) {
            if (!(value instanceof List)) throw new IllegalArgumentException();
            this.data.put(ACTION_UNINSTALL, value);
            this.actionType = ActionType.uninstall;
            return this.data.get(key);
        } else {
            if (!key.equals("debug")) return this.data.get(key);
            if (!(value instanceof Level)) throw new IllegalArgumentException();
            this.data.put("debug", value);
            ((InstallKernelImpl)this.installKernel).enableConsoleLog((Level)value);
        }
        return this.data.get(key);
    }

    private InstallEventListener getListener() {
        if (this.ielistener == null) {
            this.ielistener = new InstallEventListener(){

                @Override
                public void handleInstallEvent(InstallProgressEvent event) throws Exception {
                    if (InstallKernelMap.this.actionType != null) {
                        List messages;
                        if (InstallKernelMap.this.actionType.equals((Object)ActionType.install)) {
                            List messages2 = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE);
                            if (messages2 != null) {
                                messages2.add(event.message);
                                List cancelledList = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_CANCELLED);
                                if (((Boolean)cancelledList.get(0)).booleanValue()) {
                                    throw new CancelException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_CANCEL_INSTALL", new Object[0]), CANCELLED);
                                }
                            }
                        } else if (InstallKernelMap.this.actionType.equals((Object)ActionType.uninstall) && event.state == 255 && (messages = (List)InstallKernelMap.this.data.get(InstallKernelMap.PROGRESS_MONITOR_MESSAGE)) != null) {
                            messages.add(event.message);
                        }
                    }
                }
            };
        }
        return this.ielistener;
    }

    private Integer initKernel() {
        File installDir = (File)this.data.get(RUNTIME_INSTALL_DIR);
        Utils.setInstallDir((File)installDir);
        this.installKernel = InstallKernelFactory.getInteractiveInstance();
        String userAgent = (String)this.data.get(USER_AGENT);
        this.installKernel.setUserAgent(userAgent != null && !userAgent.isEmpty() ? userAgent : MAP_BASED_INSTALL_KERNEL);
        this.installKernel.setFirePublicAssetOnly(false);
        this.installKernel.addListener(this.getListener(), "PROGRESS");
        this.data.put(INSTALL_KERNEL_INIT_ERROR_MESSAGE, null);
        return OK;
    }

    private void resolve(Object installObject) {
        this.data.put(ACTION_INSTALL, null);
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        this.actionType = ActionType.resolve;
        if (installObject instanceof List) {
            List assets = (List)installObject;
            try {
                this.installKernel.resolve(assets, false);
                this.checkLicense();
                this.actionType = ActionType.install;
                this.data.put(ACTION_INSTALL, installObject);
            }
            catch (InstallException e) {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            }
        } else if (installObject instanceof File) {
            File esaFile = (File)installObject;
            boolean isESA = ArchiveUtils.ArchiveFileType.ESA.isType(esaFile.getName());
            if (isESA) {
                try {
                    String feature = InstallUtils.getFeatureName(esaFile);
                    this.installKernel.resolve(feature, esaFile, "usr");
                    this.checkLicense();
                    this.actionType = ActionType.install;
                    this.data.put(ACTION_INSTALL, installObject);
                }
                catch (InstallException e) {
                    this.data.put(ACTION_RESULT, ERROR);
                    this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
                }
            } else {
                this.data.put(ACTION_RESULT, ERROR);
                this.data.put(ACTION_ERROR_MESSAGE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MAPBASED_ERROR_UNSUPPORTED_FILE", esaFile.getAbsoluteFile()));
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void checkLicense() throws InstallException {
        Boolean accepted;
        Set<InstallLicense> licenses = this.installKernel.getFeatureLicense(Locale.getDefault());
        if (!(licenses.isEmpty() || (accepted = (Boolean)this.data.get(LICENSE_ACCEPT)) != null && accepted.booleanValue())) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
        }
    }

    private Integer getMonitorSize() {
        if (this.actionType != null) {
            if (this.actionType.equals((Object)ActionType.install)) {
                int numInstallResources = this.installKernel.getInstallResourcesSize();
                int numInstallAssets = this.installKernel.getLocalInstallAssetsSize();
                return numInstallResources * 2 + numInstallAssets + 1;
            }
            if (this.actionType.equals((Object)ActionType.uninstall)) {
                return 1;
            }
        }
        return 0;
    }

    public Integer install() {
        this.data.put(ACTION_RESULT, OK);
        this.data.put(ACTION_INSTALL_RESULT, null);
        this.data.put(ACTION_ERROR_MESSAGE, null);
        try {
            this.installKernel.checkResources();
            Boolean agreedToDownloadDependencies = (Boolean)this.data.get(DOWLOAD_EXTERNAL_DEPS);
            if (agreedToDownloadDependencies == null) {
                agreedToDownloadDependencies = Boolean.TRUE;
            }
            Map<String, Collection<String>> installedAssets = this.installKernel.install("usr", true, agreedToDownloadDependencies);
            this.data.put(ACTION_INSTALL_RESULT, installedAssets);
        }
        catch (CancelException e) {
            this.data.put(ACTION_RESULT, CANCELLED);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            return CANCELLED;
        }
        catch (InstallException e) {
            this.data.put(ACTION_RESULT, ERROR);
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            return ERROR;
        }
        return OK;
    }

    private Integer uninstall() {
        ArrayList<String> uninstallFeatures = this.data.containsKey(ACTION_UNINSTALL) ? new ArrayList<String>((Collection)this.data.get(ACTION_UNINSTALL)) : new ArrayList();
        this.data.put(ACTION_ERROR_MESSAGE, null);
        try {
            Boolean allowUninstallUserFeatures;
            InstallKernel installKernel = (InstallKernel)((Object)this.installKernel);
            Boolean forceUninstall = this.data.containsKey(FORCE_UNINSTALL) ? (Boolean)this.data.get(FORCE_UNINSTALL) : Boolean.FALSE;
            Boolean bl = allowUninstallUserFeatures = this.data.containsKey(UNINSTALL_USER_FEATURES) ? (Boolean)this.data.get(UNINSTALL_USER_FEATURES) : Boolean.FALSE;
            if (forceUninstall.booleanValue()) {
                if (uninstallFeatures.size() > 1) {
                    this.data.put(ACTION_ERROR_MESSAGE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_NUMBER_OF_FEATURES_FORCE_UNINSTALL", new Object[0]));
                    return ERROR;
                }
                installKernel.uninstallFeaturePrereqChecking((String)uninstallFeatures.get(0), allowUninstallUserFeatures, forceUninstall);
                installKernel.uninstallFeature((String)uninstallFeatures.get(0), forceUninstall);
            } else {
                if (allowUninstallUserFeatures != null && allowUninstallUserFeatures.booleanValue()) {
                    installKernel.uninstallFeaturePrereqChecking(uninstallFeatures);
                } else {
                    installKernel.uninstallCoreFeaturePrereqChecking(uninstallFeatures);
                }
                installKernel.uninstallFeature(uninstallFeatures);
            }
        }
        catch (InstallException e) {
            this.data.put(ACTION_ERROR_MESSAGE, e.getMessage());
            return ERROR;
        }
        return OK;
    }

    private static enum ActionType {
        install,
        uninstall,
        resolve;

    }
}

