/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal.watch;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.filemonitor.internal.DirectoryUpdateMonitor;
import com.ibm.ws.kernel.filemonitor.internal.UpdateMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WatchingDirectoryUpdateMonitor
extends DirectoryUpdateMonitor {
    private static final TraceComponent tc = Tr.register(WatchingDirectoryUpdateMonitor.class);
    private static final Set<FileVisitOption> options = Collections.singleton(FileVisitOption.FOLLOW_LINKS);
    private final WatchService watcher;
    private final Map<WatchKey, Path> watchKeys = new ConcurrentHashMap<WatchKey, Path>();
    private final Path monitoredDir;
    static final long serialVersionUID = -6711304250111827787L;

    public WatchingDirectoryUpdateMonitor(WatchService watcher, Path monitoredDir, UpdateMonitor.MonitorType type, String filter) {
        super(monitoredDir.toFile(), type, filter);
        this.monitoredDir = monitoredDir;
        this.watcher = watcher;
    }

    @Override
    public void init(Collection<File> baseline) {
        Collection<File> existingFiles = this.initialiseWatchService();
        baseline.addAll(existingFiles);
    }

    @FFDCIgnore(value={NotDirectoryException.class})
    private Collection<File> initialiseWatchService() {
        Set<File> files = new HashSet<File>();
        if (this.monitoredFile.exists()) {
            try {
                files = this.register(this.monitoredDir, this.isRecursing());
            }
            catch (NotDirectoryException nde) {
            }
            catch (IOException nde) {
                FFDCFilter.processException((Throwable)nde, (String)"com.ibm.ws.kernel.filemonitor.internal.watch.WatchingDirectoryUpdateMonitor", (String)"83", (Object)this, (Object[])new Object[0]);
            }
            if (this.isIncludeSelf() && Files.isDirectory(this.monitoredDir, new LinkOption[0])) {
                this.addToCollection(files, this.monitoredDir, false);
            }
        }
        return files;
    }

    private boolean addToCollection(Collection<File> files, Path path, boolean isFile) {
        File file = path.toFile();
        if (this.matches(file, isFile)) {
            return files.add(file);
        }
        return false;
    }

    private static Collection<File> removeAllDuplicates(Collection<File> c1, Collection<File> c2) {
        HashSet<File> filesInBothCollections = new HashSet<File>();
        Iterator<File> iter = c1.iterator();
        while (iter.hasNext()) {
            File f = iter.next();
            if (!c2.remove(f)) continue;
            filesInBothCollections.add(f);
            iter.remove();
        }
        return filesInBothCollections;
    }

    @Override
    public void scanForUpdates(Collection<File> created, Collection<File> modified, Collection<File> deleted) {
        if (this.watchKeys.isEmpty() && this.monitoredFile.exists()) {
            Collection<File> freshlyCreated = this.initialiseWatchService();
            created.addAll(freshlyCreated);
        }
        for (Map.Entry<WatchKey, Path> entry : this.watchKeys.entrySet()) {
            this.processWatchKey(created, modified, deleted, entry);
        }
        for (Map.Entry<WatchKey, Path> entry : this.watchKeys.entrySet()) {
            this.cullInvalidWatchKeys(deleted, entry);
        }
    }

    @FFDCIgnore(value={NotDirectoryException.class})
    private void processWatchKey(Collection<File> created, Collection<File> modified, Collection<File> deleted, Map.Entry<WatchKey, Path> entry) {
        WatchKey watchKey = entry.getKey();
        List<WatchEvent<?>> events = watchKey.pollEvents();
        watchKey.reset();
        for (WatchEvent<?> event : events) {
            if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Received overflow event on " + this.monitoredDir + ": " + event), (Object[])new Object[0]);
                continue;
            }
            Path context = (Path)event.context();
            Path child = entry.getValue().resolve(context);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processsing event, " + event.kind() + ", for path: " + child.toString()), (Object[])new Object[0]);
            }
            if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                if (Files.isDirectory(child, new LinkOption[0]) || created.contains(child.toFile())) continue;
                this.addToCollection(modified, child, true);
                continue;
            }
            if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                boolean previouslyDeleted;
                boolean isFile;
                boolean bl = isFile = !Files.isDirectory(child, new LinkOption[0]);
                if (deleted.contains(child.toFile())) {
                    previouslyDeleted = true;
                    deleted.remove(child.toFile());
                    if (isFile) {
                        this.addToCollection(modified, child, isFile);
                    }
                } else {
                    previouslyDeleted = false;
                    this.addToCollection(created, child, isFile);
                }
                if (!this.isRecursing()) continue;
                try {
                    if (isFile) continue;
                    Set<File> newlyCreated = this.register(child, this.isRecursing());
                    if (previouslyDeleted) {
                        Collection<File> previouslyDeletedFiles = WatchingDirectoryUpdateMonitor.removeAllDuplicates(newlyCreated, deleted);
                        modified.addAll(previouslyDeletedFiles);
                    }
                    created.addAll(newlyCreated);
                }
                catch (NotDirectoryException nde) {
                }
                catch (IOException nde) {
                    FFDCFilter.processException((Throwable)nde, (String)"com.ibm.ws.kernel.filemonitor.internal.watch.WatchingDirectoryUpdateMonitor", (String)"242", (Object)this, (Object[])new Object[]{created, modified, deleted, entry});
                }
                continue;
            }
            if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
            boolean isDirectory = this.watchKeys.containsValue(child);
            File f = child.toFile();
            if (created.remove(f)) continue;
            modified.remove(f);
            this.addToCollection(deleted, child, !isDirectory);
        }
    }

    private void cullInvalidWatchKeys(Collection<File> deleted, Map.Entry<WatchKey, Path> entry) {
        WatchKey watchKey = entry.getKey();
        if (!watchKey.isValid()) {
            Path path = entry.getValue();
            if (this.isIncludeSelf() && this.monitoredDir.equals(path)) {
                this.addToCollection(deleted, path, false);
            }
            this.watchKeys.remove(watchKey);
        }
    }

    private Set<File> register(final Path topDir, final boolean isRecursing) throws IOException {
        int depth = isRecursing ? Integer.MAX_VALUE : 1;
        WatchKey watchKey = topDir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
        this.watchKeys.put(watchKey, topDir);
        final HashSet<File> files = new HashSet<File>();
        Files.walkFileTree(topDir, options, depth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            static final long serialVersionUID = 4145129131765363869L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (isRecursing || dir.equals(topDir)) {
                    WatchKey watchKey = dir.register(WatchingDirectoryUpdateMonitor.this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
                    WatchingDirectoryUpdateMonitor.this.watchKeys.put(watchKey, dir);
                }
                if (WatchingDirectoryUpdateMonitor.this.isIncludeSelf() || !dir.equals(topDir)) {
                    WatchingDirectoryUpdateMonitor.this.addToCollection(files, dir, false);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                WatchingDirectoryUpdateMonitor.this.addToCollection(files, file, true);
                return FileVisitResult.CONTINUE;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return files;
    }

    @Override
    @FFDCIgnore(value={NotDirectoryException.class})
    public void destroy() {
        for (Map.Entry<WatchKey, Path> entry : this.watchKeys.entrySet()) {
            WatchKey watchKey = entry.getKey();
            watchKey.cancel();
        }
        this.watchKeys.clear();
        try {
            this.watcher.close();
        }
        catch (NotDirectoryException nde) {
        }
        catch (IOException nde) {
            FFDCFilter.processException((Throwable)nde, (String)"com.ibm.ws.kernel.filemonitor.internal.watch.WatchingDirectoryUpdateMonitor", (String)"344", (Object)this, (Object[])new Object[0]);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

