/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLNonTransactionalDataSource;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SQLSharedServerLeaseLog
implements SharedServerLeaseLog {
    private static final TraceComponent tc;
    private DataSource _theDS = null;
    private final CustomLogProperties _customLogProperties;
    private boolean _isOracle = false;
    private int _leaseTimeout;
    private final String _leaseTableName = "WAS_LEASES_LOG";
    private final String db2TablePreString = "CREATE TABLE ";
    private final String db2TablePostString = "( SERVER_IDENTITY VARCHAR(128), RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME BIGINT) ";
    private final String oracleTablePreString = "CREATE TABLE ";
    private final String oracleTablePostString = "( SERVER_IDENTITY VARCHAR(128), RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME NUMBER(19)) ";
    private static final Object _CreateTableLock;
    static final long serialVersionUID = -5752598636754898082L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public SQLSharedServerLeaseLog(CustomLogProperties logProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLSharedServerStatusLog", (Object)new Object[]{logProperties, this});
        }
        this._customLogProperties = logProperties;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLSharedServerStatusLog", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void getLeasesForPeers(PeerLeaseTable peerLeaseTable, String recoveryGroup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeasesForPeers", (Object)new Object[]{recoveryGroup, this});
        }
        Connection conn = null;
        ResultSet lockingRS = null;
        Statement lockingStmt = null;
        try {
            if (this._theDS == null) {
                this._theDS = this.getDataSourceFromProperties();
                if (this._theDS != null) {
                    conn = this.getConnection(this._theDS);
                }
            } else {
                conn = this._theDS.getConnection();
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection");
            }
            conn.setAutoCommit(false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"create a statement");
            }
            lockingStmt = conn.createStatement();
            if (recoveryGroup == null) {
                recoveryGroup = "";
            }
            boolean newTable = true;
            Object object = _CreateTableLock;
            synchronized (object) {
                try {
                    String queryString = "SELECT SERVER_IDENTITY, LEASE_TIME FROM WAS_LEASES_LOG WHERE RECOVERY_GROUP = '" + recoveryGroup + "'";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Attempt to select from the lease table - " + queryString));
                    }
                    lockingRS = lockingStmt.executeQuery(queryString);
                    newTable = false;
                }
                catch (Exception queryString) {
                    FFDCFilter.processException((Throwable)queryString, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"168", (Object)this, (Object[])new Object[]{peerLeaseTable, recoveryGroup});
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e));
                    }
                    try {
                        this.createLeaseTable(conn);
                        conn.commit();
                        newTable = true;
                    }
                    catch (Exception exception) {
                        void ine;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"181", (Object)this, (Object[])new Object[]{peerLeaseTable, recoveryGroup});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Table Creation failed with exception: " + ine));
                        }
                        throw ine;
                    }
                }
            }
            if (newTable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Table Creation succeeded");
                }
            } else {
                while (lockingRS.next()) {
                    String recoveryId = lockingRS.getString(1);
                    long leaseTime = lockingRS.getLong(2);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Lease Table: read recoveryId: " + recoveryId));
                        Tr.event((TraceComponent)tc, (String)("Lease Table: read leaseTime: " + leaseTime));
                    }
                    PeerLeaseData pld = new PeerLeaseData(recoveryId, leaseTime, this._leaseTimeout);
                    peerLeaseTable.addPeerEntry(pld);
                }
            }
            conn.commit();
        }
        finally {
            if (lockingRS != null && !lockingRS.isClosed()) {
                lockingRS.close();
            }
            if (lockingStmt != null && !lockingStmt.isClosed()) {
                lockingStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void updateServerLease(String recoveryIdentity, String recoveryGroup, boolean isServerStartup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateServerLease", (Object)new Object[]{recoveryIdentity, recoveryGroup, isServerStartup, this});
        }
        Connection conn = null;
        Object currentEx = null;
        Statement lockingStmt = null;
        Statement updateStmt = null;
        ResultSet lockingRS = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Work with recoveryIdentity - ", (Object)recoveryIdentity);
        }
        if (recoveryGroup == null) {
            recoveryGroup = "";
        }
        try {
            if (this._theDS == null) {
                this._theDS = this.getDataSourceFromProperties();
                if (this._theDS != null) {
                    conn = this.getConnection(this._theDS);
                }
            } else {
                conn = this._theDS.getConnection();
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection");
            }
            conn.setAutoCommit(false);
            lockingStmt = conn.createStatement();
            boolean newTable = true;
            try {
                String queryString = "SELECT LEASE_TIME, LEASE_OWNER FROM WAS_LEASES_LOG WHERE SERVER_IDENTITY='" + recoveryIdentity + "' FOR UPDATE OF LEASE_TIME";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempt to select the row for UPDATE using - " + queryString));
                }
                lockingRS = lockingStmt.executeQuery(queryString);
                newTable = false;
            }
            catch (Exception queryString) {
                void e;
                FFDCFilter.processException((Throwable)queryString, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"307", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e));
                }
                currentEx = e;
            }
            if (currentEx != null) {
                if (isServerStartup) {
                    Object e = _CreateTableLock;
                    synchronized (e) {
                        try {
                            Tr.audit((TraceComponent)tc, (String)"WTRN0108I: Create Shared Lease Table");
                            this.createLeaseTable(conn);
                            conn.commit();
                            newTable = true;
                        }
                        catch (Exception exception) {
                            void ine;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"329", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Table Creation failed with exception: " + ine));
                            }
                            throw ine;
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Lease select update failed with exception: " + currentEx));
                }
                throw currentEx;
            }
            boolean needInsert = true;
            if (!newTable) {
                if (lockingRS.next()) {
                    long storedLease = lockingRS.getLong(1);
                    String storedLeaseOwner = lockingRS.getString(2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Acquired lock row, stored lease value is: " + storedLease + ", stored owner is: " + storedLeaseOwner));
                    }
                    if (isServerStartup) {
                        PeerLeaseData pld = new PeerLeaseData(recoveryIdentity, storedLease, this._leaseTimeout);
                        if (pld.isExpired()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Lease has expired, we should update lease and recover");
                            }
                        } else if (!storedLeaseOwner.equals(recoveryIdentity)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"A peer is recovering, we will fail our recovery and exit");
                            }
                            Object[] errorObject = new Object[]{recoveryIdentity};
                            RecoveryFailedException rex = new RecoveryFailedException();
                            throw rex;
                        }
                    }
                    String updateString = "UPDATE WAS_LEASES_LOG SET LEASE_TIME = ?, RECOVERY_GROUP = ?, LEASE_OWNER = ? WHERE SERVER_IDENTITY='" + recoveryIdentity + "'";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("update lease for " + recoveryIdentity));
                    }
                    updateStmt = conn.prepareStatement(updateString);
                    long fir1 = System.currentTimeMillis();
                    updateStmt.setLong(1, fir1);
                    updateStmt.setString(2, recoveryGroup);
                    updateStmt.setString(3, recoveryIdentity);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Ready to UPDATE using string - " + updateString + " and time: " + fir1));
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Update Lease for server with recovery identity " + recoveryIdentity));
                    int ret = updateStmt.executeUpdate();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have updated Server row with return: " + ret));
                    }
                    needInsert = false;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find row");
                }
            }
            if (needInsert) {
                this.insertNewLease(recoveryIdentity, recoveryGroup, conn);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"COMMIT the change");
            }
            conn.commit();
        }
        catch (SQLException newTable) {
            FFDCFilter.processException((Throwable)newTable, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"429", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
            if (tc.isDebugEnabled()) {
                void sqlex;
                Tr.debug((TraceComponent)tc, (String)("Lease update failed with exception: " + sqlex));
            }
        }
        finally {
            if (lockingRS != null && !lockingRS.isClosed()) {
                lockingRS.close();
            }
            if (lockingStmt != null && !lockingStmt.isClosed()) {
                lockingStmt.close();
            }
            if (updateStmt != null && !updateStmt.isClosed()) {
                updateStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerLease");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewLease(String recoveryIdentity, String recoveryGroup, Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insertNewLease", (Object)this);
        }
        boolean serviceId = true;
        String insertString = "INSERT INTO WAS_LEASES_LOG (SERVER_IDENTITY, RECOVERY_GROUP, LEASE_OWNER, LEASE_TIME) VALUES (?,?,?,?)";
        Statement specStatement = null;
        long fir1 = System.currentTimeMillis();
        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Insert New Lease for server with recovery identity " + recoveryIdentity));
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Need to setup new row using - " + insertString + ", and time: " + fir1));
            }
            specStatement = conn.prepareStatement(insertString);
            specStatement.setString(1, recoveryIdentity);
            specStatement.setString(2, recoveryGroup);
            specStatement.setString(3, recoveryIdentity);
            specStatement.setLong(4, fir1);
            int ret = specStatement.executeUpdate();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have inserted Server row with return: " + ret));
            }
        }
        finally {
            if (specStatement != null && !specStatement.isClosed()) {
                specStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insertNewLease");
        }
    }

    private DataSource getDataSourceFromProperties() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDataSourceFromProperties", (Object)this);
        }
        DataSource dataSource = null;
        Properties internalLogProperties = this._customLogProperties.properties();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Recovery log internal properties are " + internalLogProperties));
        }
        String fullLogDirectory = internalLogProperties.getProperty("LOG_DIRECTORY");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory));
        }
        StringTokenizer st = new StringTokenizer(fullLogDirectory, "?");
        String cname = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cname = " + cname));
        }
        Properties dbStringProps = new Properties();
        String dbPropertiesString = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbPropertiesString = " + dbPropertiesString));
        }
        dbStringProps.load(new StringReader(dbPropertiesString.replace(',', '\n')));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbStringProps = " + dbStringProps));
        }
        String dsName = dbStringProps.getProperty("datasource");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Data Source name = " + dsName));
        }
        SQLNonTransactionalDataSource sqlNonTranDS = new SQLNonTransactionalDataSource(dsName, this._customLogProperties);
        dataSource = sqlNonTranDS.getDataSource();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDataSourceFromProperties", (Object)dataSource);
        }
        return dataSource;
    }

    private Connection getConnection(DataSource dataSource) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)this);
        }
        Connection conn = null;
        conn = dataSource.getConnection();
        if (conn != null) {
            String dbName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got connection: " + conn));
            }
            DatabaseMetaData mdata = conn.getMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got metadata: " + mdata));
            }
            if ((dbName = mdata.getDatabaseProductName()).toLowerCase().contains("oracle")) {
                this._isOracle = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is an Oracle Database");
                }
            } else if (dbName.toLowerCase().contains("db2")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a DB2 Database");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("This is neither Oracle nor DB2, it is " + dbName));
            }
            String dbVersion = mdata.getDatabaseProductVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("You are now connected to " + dbName + ", version " + dbVersion));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLeaseTable(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLeaseTable", (Object)new Object[]{conn, this});
        }
        Statement createTableStmt = null;
        Statement specStatement = null;
        try {
            createTableStmt = conn.createStatement();
            if (this._isOracle) {
                String oracleTableString = "CREATE TABLE WAS_LEASES_LOG( SERVER_IDENTITY VARCHAR(128), RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME NUMBER(19)) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Table using: " + oracleTableString));
                }
                createTableStmt.executeUpdate(oracleTableString);
            } else {
                String db2TableString = "CREATE TABLE WAS_LEASES_LOG( SERVER_IDENTITY VARCHAR(128), RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME BIGINT) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create DB2 Table using: " + db2TableString));
                }
                createTableStmt.executeUpdate(db2TableString);
            }
        }
        finally {
            if (createTableStmt != null && !createTableStmt.isClosed()) {
                createTableStmt.close();
            }
            if (specStatement != null && !specStatement.isClosed()) {
                specStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createLeaseTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void deleteServerLease(String recoveryIdentity) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteServerLease", (Object)new Object[]{recoveryIdentity, this});
        }
        Connection conn = null;
        boolean sqlSuccess = false;
        Object currentSqlEx = null;
        Statement deleteStmt = null;
        try {
            if (this._theDS == null) {
                this._theDS = this.getDataSourceFromProperties();
                if (this._theDS != null) {
                    conn = this.getConnection(this._theDS);
                }
            } else {
                conn = this._theDS.getConnection();
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"deleteServerLease", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection");
            }
            conn.setAutoCommit(false);
            deleteStmt = conn.createStatement();
            String deleteString = "DELETE FROM WAS_LEASES_LOG WHERE SERVER_IDENTITY='" + recoveryIdentity + "'";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("delete server lease for " + recoveryIdentity + "using string " + deleteString));
            }
            int ret = deleteStmt.executeUpdate(deleteString);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have deleted row with return: " + ret + ", commit the change"));
            }
            conn.commit();
            Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Deleted Lease for server with recovery identity " + recoveryIdentity));
        }
        catch (SQLException deleteString) {
            FFDCFilter.processException((Throwable)deleteString, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"721", (Object)this, (Object[])new Object[]{recoveryIdentity});
            if (tc.isDebugEnabled()) {
                void sqlex;
                Tr.debug((TraceComponent)tc, (String)("Lease delete failed with exception: " + sqlex));
            }
        }
        finally {
            if (deleteStmt != null && !deleteStmt.isClosed()) {
                deleteStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteServerLease");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, this});
        }
        boolean peerClaimed = false;
        Connection conn = null;
        Statement lockingStmt = null;
        Statement updateStmt = null;
        ResultSet lockingRS = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Recovering server with recoveryIdentity - ", (Object)recoveryIdentityToRecover);
        }
        try {
            if (this._theDS == null) {
                this._theDS = this.getDataSourceFromProperties();
                if (this._theDS != null) {
                    conn = this.getConnection(this._theDS);
                }
            } else {
                conn = this._theDS.getConnection();
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection");
            }
            conn.setAutoCommit(false);
            lockingStmt = conn.createStatement();
            try {
                String queryString = "SELECT LEASE_TIME FROM WAS_LEASES_LOG WHERE SERVER_IDENTITY='" + recoveryIdentityToRecover + "' FOR UPDATE OF LEASE_TIME";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempt to select the row for UPDATE using - " + queryString));
                }
                lockingRS = lockingStmt.executeQuery(queryString);
            }
            catch (Exception queryString) {
                void e;
                FFDCFilter.processException((Throwable)queryString, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"803", (Object)this, (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e));
                }
                throw new InternalLogException("Failed to query the lease time, exc: " + e, null);
            }
            if (lockingRS.next()) {
                PeerLeaseData pld;
                long storedLease = lockingRS.getLong(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Acquired server row, stored lease value is: " + storedLease));
                }
                if ((pld = new PeerLeaseData(recoveryIdentityToRecover, storedLease, this._leaseTimeout)).isExpired()) {
                    String updateString = "UPDATE WAS_LEASES_LOG SET LEASE_TIME = ?, LEASE_OWNER = ? WHERE SERVER_IDENTITY='" + recoveryIdentityToRecover + "'";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("update lease for " + recoveryIdentityToRecover));
                    }
                    updateStmt = conn.prepareStatement(updateString);
                    long fir1 = System.currentTimeMillis();
                    updateStmt.setLong(1, fir1);
                    updateStmt.setString(2, myRecoveryIdentity);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Ready to UPDATE using string - " + updateString + " and time: " + fir1));
                    }
                    int ret = updateStmt.executeUpdate();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have updated server row with return: " + ret));
                    }
                    peerClaimed = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find row");
                }
                throw new InternalLogException("Could not find lease", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"COMMIT the change");
            }
            conn.commit();
        }
        catch (SQLException storedLease) {
            FFDCFilter.processException((Throwable)storedLease, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLSharedServerLeaseLog", (String)"863", (Object)this, (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo});
            if (tc.isDebugEnabled()) {
                void sqlex;
                Tr.debug((TraceComponent)tc, (String)("Lease update failed with exception: " + sqlex));
            }
        }
        finally {
            if (lockingRS != null && !lockingRS.isClosed()) {
                lockingRS.close();
            }
            if (lockingStmt != null && !lockingStmt.isClosed()) {
                lockingStmt.close();
            }
            if (updateStmt != null && !updateStmt.isClosed()) {
                updateStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery");
        }
        return peerClaimed;
    }

    public boolean lockPeerLease(String recoveryIdentity) {
        return true;
    }

    public boolean releasePeerLease(String recoveryIdentity) throws Exception {
        return true;
    }

    public boolean lockLocalLease(String recoveryIdentity) {
        return true;
    }

    public boolean releaseLocalLease(String recoveryIdentity) throws Exception {
        return true;
    }

    public void setPeerRecoveryLeaseTimeout(int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object)leaseTimeout);
        }
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(SQLSharedServerLeaseLog.class);
        tc = Tr.register(SQLSharedServerLeaseLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        _CreateTableLock = new Object();
    }
}

