/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLMultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitSectionException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import java.util.Collection;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SQLRecoverableUnitImpl
implements RecoverableUnit {
    private static final TraceComponent tc;
    private long _identity;
    private HashMap _recoverableUnitSections;
    private SQLMultiScopeRecoveryLog _recLog;
    private byte[] _deflatedFailureScope;
    private FailureScope _failureScope;
    private String _serverName;
    private String _clientName;
    private int _clientVersion;
    private String _logName;
    private int _logIdentifier;
    private String _traceId;
    static final long serialVersionUID = 2908505113872311707L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public SQLRecoverableUnitImpl(SQLMultiScopeRecoveryLog recLog, long identity, FailureScope failureScope, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)new Object[]{recLog, new Long(identity), failureScope, new Boolean(recovered)});
        }
        this._deflatedFailureScope = FailureScopeManager.toByteArray((FailureScope)failureScope);
        this._failureScope = failureScope;
        this._identity = identity;
        this._recLog = recLog;
        this._recoverableUnitSections = new HashMap();
        this._recLog.addRecoverableUnit(this, recovered);
        this._serverName = recLog.serverName();
        this._clientName = recLog.clientName();
        this._clientVersion = recLog.clientVersion();
        this._logName = recLog.logName();
        this._logIdentifier = recLog.logIdentifier();
        this._traceId = "SQLRecoverableUnitImpl:serverName=" + this._serverName + ":" + "clientName=" + this._clientName + ":" + "clientVersion=" + this._clientVersion + ":" + "logName=" + this._logName + ":" + "logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)this);
        }
    }

    SQLRecoverableUnitImpl(SQLMultiScopeRecoveryLog recLog, long identity, FailureScope failureScope) {
        this(recLog, identity, failureScope, false);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)new Object[]{recLog, new Long(identity), failureScope});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLRecoverableUnitImpl", (Object)this);
        }
    }

    public RecoverableUnitSection createSection(int identity, boolean singleData) throws RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSection", (Object)new Object[]{this, new Integer(identity), new Boolean(singleData)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        Integer sectionId = new Integer(identity);
        SQLRecoverableUnitSectionImpl recoverableUnitSection = null;
        if (!this._recoverableUnitSections.containsKey(sectionId)) {
            recoverableUnitSection = new SQLRecoverableUnitSectionImpl(this._recLog, this, this._identity, identity, singleData);
            this._recoverableUnitSections.put(sectionId, recoverableUnitSection);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SQLRecoverableUnitImpl '" + this._identity + "' created a new RecoverableUnitSection with identity '" + identity + "'"));
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("SQLRecoverableUnitImpl '" + this._identity + "' was unable to create a RecoverableUnitSection with id '" + identity + "' as it already exists"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)"RecoverableUnitSectionExistsException");
            }
            throw new RecoverableUnitSectionExistsException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSection", (Object)recoverableUnitSection);
        }
        return recoverableUnitSection;
    }

    public void removeSection(int identity) throws InvalidRecoverableUnitSectionException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSection", (Object)new Object[]{this, new Integer(identity)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSection", (Object)"UnsupportedOperationException");
        }
        throw new UnsupportedOperationException();
    }

    public RecoverableUnitSection lookupSection(int identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupSection", (Object)new Object[]{this, new Integer(identity)});
        }
        SQLRecoverableUnitSectionImpl recoverableUnitSection = (SQLRecoverableUnitSectionImpl)this._recoverableUnitSections.get(new Integer(identity));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupSection", (Object)recoverableUnitSection);
        }
        return recoverableUnitSection;
    }

    public void writeSections() throws InternalLogException {
        this.writeSections(false);
    }

    void writeSections(boolean rewriteRequired) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeSections", (Object)new Object[]{this, new Boolean(rewriteRequired)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        for (SQLRecoverableUnitSectionImpl section : this._recoverableUnitSections.values()) {
            this.writeSection(section);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeSections");
        }
    }

    void writeSection(SQLRecoverableUnitSectionImpl target) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeSection", (Object)new Object[]{this, target});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        target.write();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeSection");
        }
    }

    public void forceSections() throws InternalLogException {
        this.forceSections(false);
    }

    /*
     * WARNING - void declaration
     */
    void forceSections(boolean rewriteRequired) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forceSections", (Object)new Object[]{this, new Boolean(rewriteRequired)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)this);
            }
            throw new InternalLogException(null);
        }
        try {
            this.writeSections(rewriteRequired);
            this._recLog.forceSections();
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitImpl", (String)"601", (Object)this, (Object[])new Object[]{rewriteRequired});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLRecoverableUnitImpl.forceSections", (String)"531", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRecoverableUnitImpl", (String)"607", (Object)this, (Object[])new Object[]{rewriteRequired});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.SQLRecoverableUnitImpl.forceSections", (String)"537", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forceSections");
        }
    }

    public LogCursor sections() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sections", (Object)this);
        }
        Collection recoverableUnitSectionsValues = this._recoverableUnitSections.values();
        LogCursorImpl cursor = new LogCursorImpl(null, recoverableUnitSectionsValues, false, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sections", (Object)cursor);
        }
        return cursor;
    }

    public long identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"identity", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"identity", (Object)new Long(this._identity));
        }
        return this._identity;
    }

    void remove() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"remove", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Remove completed for recoverable unit " + this._identity + ". Clear internal state"));
        }
        this._recoverableUnitSections.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    protected FailureScope failureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"failureScope", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"failureScope", (Object)this._failureScope);
        }
        return this._failureScope;
    }

    public String toString() {
        return this._traceId;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(SQLRecoverableUnitImpl.class);
        tc = Tr.register(SQLRecoverableUnitImpl.class, (String)"Transaction", null);
    }
}

