/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.repository.resolver.internal.resource.InstallableEntityCapability;
import com.ibm.ws.repository.resolver.internal.resource.InstallableEntityRequirement;
import com.ibm.ws.repository.resolver.internal.resource.ProductRequirement;
import com.ibm.ws.repository.resolver.internal.resource.ResourceImpl;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class SampleResource
extends ResourceImpl {
    private final String sampleName;

    public static SampleResource createInstance(com.ibm.ws.repository.resources.SampleResource massiveSample) {
        Collection requiredFeatures;
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        String appliesTo = massiveSample.getAppliesTo();
        if (appliesTo != null && !appliesTo.isEmpty()) {
            requirements.add(new ProductRequirement(appliesTo));
        }
        if ((requiredFeatures = massiveSample.getRequireFeature()) != null) {
            for (String requiredFeature : requiredFeatures) {
                requirements.add(new InstallableEntityRequirement(requiredFeature, "osgi.subsystem.feature"));
            }
        }
        return new SampleResource(massiveSample.getShortName(), massiveSample.getShortName().toLowerCase(), requirements, "repo", (RepositoryResource)massiveSample);
    }

    private SampleResource(String shortName, String lowerCaseShortName, List<Requirement> requirements, String location, RepositoryResource massiveResource) {
        super(SampleResource.createCapabilities(shortName, lowerCaseShortName), requirements, location, massiveResource);
        this.sampleName = shortName;
    }

    private static List<Capability> createCapabilities(String shortName, String lowerCaseShortName) {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(new InstallableEntityCapability(shortName, shortName, lowerCaseShortName, null, "sample"));
        return capabilities;
    }

    public String toString() {
        return "SampleResource [name=" + this.sampleName + "]";
    }
}

