/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal.resource;

import com.ibm.ws.product.utility.extension.ifix.xml.Applicability;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.Offering;
import com.ibm.ws.product.utility.extension.ifix.xml.Problem;
import com.ibm.ws.product.utility.extension.ifix.xml.Resolves;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import com.ibm.ws.product.utility.extension.ifix.xml.Updates;
import com.ibm.ws.repository.resolver.internal.resource.InstallableEntityCapability;
import com.ibm.ws.repository.resolver.internal.resource.ProductRequirement;
import com.ibm.ws.repository.resolver.internal.resource.ResourceImpl;
import com.ibm.ws.repository.resources.IfixResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class IFixResource
extends ResourceImpl
implements Resource,
Comparable<IFixResource> {
    private final Date iFixDate;

    public static IFixResource createInstance(IFixInfo iFixInfo) {
        Set updatedFiles;
        List offerings;
        List problems;
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        Resolves resolves = iFixInfo.getResolves();
        if (resolves != null && (problems = resolves.getProblems()) != null) {
            for (Problem problem : problems) {
                capabilities.add(new InstallableEntityCapability(problem.getDisplayId(), "ifix"));
            }
        }
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        Applicability applicability = iFixInfo.getApplicability();
        if (applicability != null && (offerings = applicability.getOfferings()) != null && !offerings.isEmpty()) {
            VersionRange range = new VersionRange(((Offering)offerings.get(0)).getTolerance());
            Version minimum = IFixResource.convertVersion(range.getLeft());
            Version maximum = IFixResource.convertVersion(range.getRight());
            range = new VersionRange(range.getLeftType(), minimum, maximum, range.getRightType());
            requirements.add(new ProductRequirement(range));
        }
        ArrayList<Date> updateDates = new ArrayList<Date>();
        Updates updates = iFixInfo.getUpdates();
        if (updates != null && (updatedFiles = updates.getFiles()) != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            for (UpdatedFile updatedFile : updatedFiles) {
                String dateString = updatedFile.getDate();
                if (dateString == null) continue;
                try {
                    Date date = dateFormat.parse(updatedFile.getDate());
                    updateDates.add(date);
                }
                catch (ParseException e) {}
            }
        }
        Collections.sort(updateDates);
        Date lastUpdateDate = updateDates.size() > 0 ? (Date)updateDates.get(updateDates.size() - 1) : new Date(0L);
        return new IFixResource(capabilities, requirements, "install", lastUpdateDate, null);
    }

    public static IFixResource createInstance(IfixResource massiveFix) {
        Collection aparIds = massiveFix.getProvideFix();
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (String aparId : aparIds) {
            capabilities.add(new InstallableEntityCapability(aparId, "ifix"));
        }
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        String appliesTo = massiveFix.getAppliesTo();
        if (appliesTo != null && !appliesTo.isEmpty()) {
            requirements.add(new ProductRequirement(appliesTo));
        }
        Date iFixDate = massiveFix.getDate();
        return new IFixResource(capabilities, requirements, "repo", iFixDate, (RepositoryResource)massiveFix);
    }

    static Version convertVersion(Version version) {
        String qualifier = version.getQualifier();
        if (qualifier == null || qualifier.isEmpty()) {
            int micro = version.getMicro();
            qualifier = Integer.toString(micro % 1000);
            version = new Version(version.getMajor(), version.getMinor(), micro /= 1000, qualifier);
        }
        return version;
    }

    private IFixResource(List<Capability> capabilities, List<Requirement> requirements, String location, Date mostRecentUpdateDate, RepositoryResource massiveResource) {
        super(capabilities, requirements, location, massiveResource);
        this.iFixDate = mostRecentUpdateDate != null ? mostRecentUpdateDate : new Date(0L);
    }

    @Override
    public int compareTo(IFixResource o) {
        int locationCheck = this.compareLocation(o);
        if (locationCheck != 0) {
            return locationCheck;
        }
        return o.iFixDate.compareTo(this.iFixDate);
    }
}

