/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.DefaultArtifactNotification;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileArtifactNotifier
implements ArtifactNotifier,
FileMonitor,
ArtifactNotifier.ArtifactListener {
    private final ZipFileContainer root;
    private final ContainerFactoryHolder cfh;
    private final Hashtable<String, Object> serviceProperties = new Hashtable();
    private ServiceRegistration<FileMonitor> service = null;
    private boolean listenerRegistered;
    private final Map<String, Collection<ArtifactNotifier.ArtifactListener>> listeners;
    private final Set<String> pathsBeingMonitored;
    private final String rootAbsolutePath;
    private final ArtifactEntry entryInParent;
    private final ArtifactNotifier.ArtifactNotification emptyNotification;
    private Long interval;
    private String notificationType;
    static final long serialVersionUID = -4444509856579143394L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ZipFileArtifactNotifier(ZipFileContainer root, ContainerFactoryHolder cfh, String absPath) {
        this.root = root;
        this.rootAbsolutePath = absPath;
        this.entryInParent = null;
        this.cfh = cfh;
        this.listeners = new ConcurrentHashMap<String, Collection<ArtifactNotifier.ArtifactListener>>();
        this.pathsBeingMonitored = new HashSet<String>();
        this.listenerRegistered = false;
        this.emptyNotification = new DefaultArtifactNotification((ArtifactContainer)root, Collections.unmodifiableCollection(Collections.emptySet()));
    }

    public ZipFileArtifactNotifier(ZipFileContainer root, ContainerFactoryHolder cfh, ArtifactEntry entryInParent) {
        this.root = root;
        this.rootAbsolutePath = null;
        this.entryInParent = entryInParent;
        this.cfh = cfh;
        this.listeners = new ConcurrentHashMap<String, Collection<ArtifactNotifier.ArtifactListener>>();
        this.pathsBeingMonitored = new HashSet<String>();
        this.listenerRegistered = false;
        this.emptyNotification = new DefaultArtifactNotification((ArtifactContainer)root, Collections.unmodifiableCollection(Collections.emptySet()));
    }

    private void verifyTargets(ArtifactNotifier.ArtifactNotification targets) throws IllegalArgumentException {
        if (targets.getContainer().getRoot() != this.root) {
            throw new IllegalArgumentException();
        }
    }

    private void rebuildPaths() {
        this.pathsBeingMonitored.clear();
        this.pathsBeingMonitored.addAll(this.listeners.keySet());
    }

    private void updateMonitoredPaths(Set<String> pathsToAdd, Set<String> pathsToRemove) {
        boolean updateNeeded = false;
        if (pathsToAdd != null && !pathsToAdd.isEmpty()) {
            this.pathsBeingMonitored.addAll(pathsToAdd);
            updateNeeded = true;
        }
        if (pathsToRemove != null && !pathsToRemove.isEmpty()) {
            this.rebuildPaths();
            this.pathsBeingMonitored.removeAll(pathsToRemove);
            updateNeeded = true;
        }
        if (updateNeeded) {
            this.updateFileMonitorService();
        }
    }

    private boolean addTarget(String path, ArtifactNotifier.ArtifactListener listener) {
        boolean pathIsNew = true;
        for (String lpath : this.listeners.keySet()) {
            if (!path.equals(lpath) && !path.startsWith(lpath + "/")) continue;
            pathIsNew = false;
        }
        Collection<ArtifactNotifier.ArtifactListener> list = this.listeners.get(path);
        if (list == null) {
            list = new ConcurrentLinkedQueue<ArtifactNotifier.ArtifactListener>();
            this.listeners.put(path, list);
        }
        list.add(listener);
        return pathIsNew;
    }

    public synchronized boolean registerForNotifications(ArtifactNotifier.ArtifactNotification targets, ArtifactNotifier.ArtifactListener callbackObject) throws IllegalArgumentException {
        this.verifyTargets(targets);
        HashSet<String> pathsToMonitor = new HashSet<String>();
        for (String path : targets.getPaths()) {
            boolean addToMonitorList;
            if (path.startsWith("!")) {
                path = path.substring(1);
            }
            if (!(addToMonitorList = this.addTarget(path, callbackObject))) continue;
            pathsToMonitor.add(path);
        }
        this.updateMonitoredPaths(pathsToMonitor, null);
        return true;
    }

    public boolean removeListener(ArtifactNotifier.ArtifactListener listenerToRemove) {
        boolean success = false;
        HashSet<String> pathsToRemove = new HashSet<String>();
        for (Map.Entry<String, Collection<ArtifactNotifier.ArtifactListener>> listenersByPath : this.listeners.entrySet()) {
            for (ArtifactNotifier.ArtifactListener listener : listenersByPath.getValue()) {
                if (listener != listenerToRemove) continue;
                pathsToRemove.add(listenersByPath.getKey());
            }
        }
        HashSet<String> pathsToReallyRemove = new HashSet<String>(pathsToRemove.size());
        for (String path : pathsToRemove) {
            Collection<ArtifactNotifier.ArtifactListener> listenersForPath = this.listeners.get(path);
            if (listenersForPath.size() == 1) {
                this.listeners.remove(path);
                pathsToReallyRemove.add(path);
                continue;
            }
            listenersForPath.remove(listenerToRemove);
        }
        this.updateMonitoredPaths(null, pathsToReallyRemove);
        if (pathsToRemove.size() > 0) {
            success = true;
        }
        return success;
    }

    private synchronized void updateFileMonitorService() {
        if (this.rootAbsolutePath != null) {
            this.updateFileMonitorServiceForZipFile();
        } else {
            this.updateArtifactListenerForEntry();
        }
    }

    private synchronized void updateArtifactListenerForEntry() {
        if (this.pathsBeingMonitored.size() > 0 && !this.listenerRegistered) {
            ArtifactContainer notificationContainer = this.entryInParent.getRoot();
            DefaultArtifactNotification notificationForSelfInParent = new DefaultArtifactNotification(notificationContainer, Collections.singleton(this.entryInParent.getPath()));
            ArtifactNotifier notifierForEntryInParent = notificationContainer.getArtifactNotifier();
            this.listenerRegistered = notifierForEntryInParent.registerForNotifications((ArtifactNotifier.ArtifactNotification)notificationForSelfInParent, (ArtifactNotifier.ArtifactListener)this);
            this.root.listEntries();
        } else if (this.pathsBeingMonitored.size() == 0 && this.listenerRegistered) {
            ArtifactContainer notificationContainer = this.entryInParent.getRoot();
            ArtifactNotifier notifierForEntryInParent = notificationContainer.getArtifactNotifier();
            notifierForEntryInParent.removeListener((ArtifactNotifier.ArtifactListener)this);
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private synchronized void updateFileMonitorServiceForZipFile() {
        if (this.service == null) {
            try {
                BundleContext ctx = this.cfh.getBundleContext();
                this.serviceProperties.put("service.vendor", "IBM");
                Long newInterval = 5000L;
                if (this.interval != null) {
                    newInterval = this.interval;
                }
                this.serviceProperties.put("monitor.interval", "" + newInterval + "ms");
                String type = this.notificationType;
                if (type == null) {
                    type = "timed";
                }
                this.serviceProperties.put("monitor.type", type);
                this.serviceProperties.put("monitor.directories", new String[]{this.rootAbsolutePath});
                this.serviceProperties.put("monitor.files", new String[]{this.rootAbsolutePath});
                this.serviceProperties.put("monitor.recurse", true);
                this.serviceProperties.put("monitor.filter", ".*");
                this.service = ctx.registerService(FileMonitor.class, (Object)this, this.serviceProperties);
                this.root.listEntries();
            }
            catch (IllegalStateException ise) {}
        } else if (this.pathsBeingMonitored.size() == 0) {
            try {
                this.service.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.service = null;
        }
    }

    public synchronized boolean setNotificationOptions(long interval, boolean useMBean) {
        if (this.rootAbsolutePath == null) {
            return false;
        }
        Long compareInterval = interval;
        if (compareInterval.equals(this.interval) && (useMBean && "external".equals(this.notificationType) || !useMBean && "timed".equals(this.notificationType))) {
            return true;
        }
        this.interval = compareInterval;
        String string = this.notificationType = useMBean ? "external" : "timed";
        if (this.service != null) {
            this.updateFileMonitorService();
        }
        return true;
    }

    public void onBaseline(Collection<File> baseline) {
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        boolean modified = false;
        if (modifiedFiles.size() > 0) {
            modified = true;
        }
        if (deletedFiles.size() > 0) {
            if (modified) {
                throw new IllegalStateException(modifiedFiles.toString() + deletedFiles.toString());
            }
            modified = false;
        }
        if (createdFiles.size() > 0) {
            throw new IllegalStateException(createdFiles.toString());
        }
        this.notifyAllListeners(modified);
    }

    public void notifyEntryChange(ArtifactNotifier.ArtifactNotification added, ArtifactNotifier.ArtifactNotification removed, ArtifactNotifier.ArtifactNotification modified) {
        boolean modifiedflag = false;
        if (modified.getPaths().size() > 0) {
            modifiedflag = true;
        }
        if (removed.getPaths().size() > 0) {
            if (modifiedflag) {
                throw new IllegalStateException(modified.toString() + removed.toString());
            }
            modifiedflag = false;
        }
        if (added.getPaths().size() > 0) {
            throw new IllegalStateException(added.toString());
        }
        this.notifyAllListeners(modifiedflag);
    }

    private ArtifactNotifier.ArtifactNotification collectNotificationsForPath(String pathAndName) {
        ArrayList<String> gatheredPaths = new ArrayList<String>();
        NavigableMap<String, ZipEntry> allEntries = this.root.listEntries();
        if ("/".equals(pathAndName)) {
            for (String key : allEntries.keySet()) {
                gatheredPaths.add('/' + key);
            }
            gatheredPaths.add("/");
        } else {
            String firstKey = pathAndName.substring(1);
            SortedMap<String, ZipEntry> subEntries = allEntries.subMap(firstKey, firstKey + 0);
            for (String key : subEntries.keySet()) {
                gatheredPaths.add('/' + key);
            }
        }
        return new DefaultArtifactNotification((ArtifactContainer)this.root, gatheredPaths);
    }

    private void notifyAllListeners(boolean modified) {
        for (Map.Entry<String, Collection<ArtifactNotifier.ArtifactListener>> listenersForPath : this.listeners.entrySet()) {
            ArtifactNotifier.ArtifactNotification paths = this.collectNotificationsForPath(listenersForPath.getKey());
            if (paths.getPaths().size() <= 0) continue;
            for (ArtifactNotifier.ArtifactListener listener : listenersForPath.getValue()) {
                if (modified) {
                    listener.notifyEntryChange(this.emptyNotification, this.emptyNotification, paths);
                    continue;
                }
                listener.notifyEntryChange(this.emptyNotification, paths, this.emptyNotification);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZipFileArtifactNotifier.class);
    }
}

