/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.cache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.cache.internal.CacheHashMap;
import com.ibm.ws.artifact.zip.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileHandleImpl
implements ZipFileHandle {
    static final TraceComponent tc = Tr.register(ZipFileHandleImpl.class);
    private final String path;
    private final File file;
    private ZipFile zipFile;
    private int refs;
    private static final int MAX_CACHE_ENTRY_SIZE = 8192;
    private static final int MAX_CACHE_ENTRIES = 16;
    private static final Map<String, byte[]> dataCache = Collections.synchronizedMap(new CacheHashMap(16));
    static final long serialVersionUID = 4311869427952196216L;

    ZipFileHandleImpl(String path) {
        this.path = path;
        this.file = new File(path);
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public synchronized ZipFile open() throws IOException {
        if (this.zipFile == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("[" + this.hashCode() + "] Opening FileHandle to " + this.path), (Object[])new Object[0]);
            }
            this.zipFile = Utils.newZipFile(this.file);
        }
        ++this.refs;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("[" + this.hashCode() + "] refCount now " + this.refs), (Object[])new Object[0]);
        }
        return this.zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.refs == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("[" + this.hashCode() + "] attempt to call close when closed & ref at zero.. caused by.. "), (Object[])new Object[0]);
                Exception e = new Exception();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                e.printStackTrace(ps);
                Tr.debug((TraceComponent)tc, (String)baos.toString(), (Object[])new Object[0]);
            }
            return;
        }
        if (--this.refs != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("[" + this.hashCode() + "] refCount now " + this.refs), (Object[])new Object[0]);
            }
            return;
        }
        if (this.zipFile != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("[" + this.hashCode() + "] Closing handle to path " + this.path), (Object[])new Object[0]);
                }
                this.zipFile.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("[" + this.hashCode() + "] refCount now " + this.refs), (Object[])new Object[0]);
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileHandleImpl", (String)"98", (Object)this, (Object[])new Object[0]);
            }
            finally {
                this.zipFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private byte[] readDataToByteArray(InputStream in) throws IOException {
        byte[] byArray;
        block8: {
            if (in == null) {
                return null;
            }
            try {
                int readCount;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] data = new byte[8192];
                while ((readCount = in.read(data, 0, data.length)) != -1) {
                    baos.write(data, 0, readCount);
                }
                baos.flush();
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                block9: {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        void io;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileHandleImpl", (String)"128", (Object)this, (Object[])new Object[]{in});
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug((TraceComponent)tc, (String)"IO Exception closing input stream while caching zip entry", (Object[])new Object[]{io});
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                void io;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.cache.internal.ZipFileHandleImpl", (String)"128", (Object)this, (Object[])new Object[]{in});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"IO Exception closing input stream while caching zip entry", (Object[])new Object[]{io});
            }
        }
        return byArray;
    }

    public long getLastModified() {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){
            static final long serialVersionUID = -2110395146417379777L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Long run() {
                return ZipFileHandleImpl.this.file.lastModified();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    @Override
    public InputStream getInputStream(ZipFile zf, ZipEntry ze) throws IOException {
        long size = ze.getSize();
        if (size < 8192L && size > 0L && !ze.getName().endsWith(".class")) {
            String path = ze.getName();
            path = path + ":::" + ze.getCrc();
            byte[] data = dataCache.get(path = path + ":::" + this.getLastModified());
            if (data != null) {
                return new ByteArrayInputStream(data);
            }
            data = this.readDataToByteArray(zf.getInputStream(ze));
            if (data != null) {
                dataCache.put(path, data);
                return new ByteArrayInputStream(data);
            }
            return null;
        }
        return zf.getInputStream(ze);
    }
}

