/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.zos.command.processing.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.zos.command.processing.internal.CommandProcessor;
import com.ibm.ws.zos.command.processing.internal.ModifyResultsImpl;
import com.ibm.ws.zos.core.command.processing.CommandHandler;
import com.ibm.ws.zos.core.command.processing.ModifyResults;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CommandHandlerHolder
implements Comparable<CommandHandlerHolder> {
    final CommandProcessor commandProcessor;
    final ServiceReference<CommandHandler> serviceReference;
    final String filterSpec;
    CommandHandler target = null;
    String targetHandlerName = null;
    Pattern filterPattern = null;
    final long serviceId;
    final int serviceRanking;
    final Boolean displayHelp;
    static final long serialVersionUID = -111818994516214413L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    CommandHandlerHolder(CommandProcessor commandProcessor, ServiceReference<CommandHandler> serviceReference) {
        this.commandProcessor = commandProcessor;
        this.serviceReference = serviceReference;
        this.filterSpec = (String)serviceReference.getProperty("modify.filter.regex");
        this.serviceId = (Long)serviceReference.getProperty("service.id");
        Object tmp = serviceReference.getProperty("service.ranking");
        this.serviceRanking = tmp == null ? 0 : (Integer)tmp;
        String displayHelpStr = (String)serviceReference.getProperty("display.command.help");
        this.displayHelp = displayHelpStr == null || displayHelpStr.compareToIgnoreCase("FALSE") != 0;
    }

    ServiceReference<CommandHandler> getServiceReference() {
        return this.serviceReference;
    }

    CommandHandler getService() {
        if (this.target != null) {
            return this.target;
        }
        ComponentContext context = this.commandProcessor.getComponentContext();
        String referenceName = this.commandProcessor.getWsHandlerReferenceName();
        this.target = (CommandHandler)context.locateService(referenceName, this.serviceReference);
        this.targetHandlerName = this.target.getName();
        return this.target;
    }

    Pattern getFilter() {
        if (this.filterPattern == null && this.filterSpec != null) {
            this.filterPattern = Pattern.compile(this.filterSpec);
        }
        return this.filterPattern;
    }

    @Override
    public int compareTo(CommandHandlerHolder holderToCompare) {
        if (this.equals(holderToCompare)) {
            return 0;
        }
        int compare = holderToCompare.serviceRanking - this.serviceRanking;
        if (compare == 0) {
            return holderToCompare.serviceId > this.serviceId ? -1 : 1;
        }
        return holderToCompare.serviceRanking > this.serviceRanking ? 1 : -1;
    }

    public boolean equals(Object holderToCompare) {
        if (this == holderToCompare) {
            return true;
        }
        if (holderToCompare == null || !(holderToCompare instanceof CommandHandlerHolder)) {
            return false;
        }
        return this.serviceId == ((CommandHandlerHolder)holderToCompare).serviceId;
    }

    public int hashCode() {
        return (int)this.serviceId;
    }

    /*
     * WARNING - void declaration
     */
    public ModifyResults deliverCommand(String modifyCommmand) {
        ModifyResultsImpl results = new ModifyResultsImpl();
        results.setCompletionStatus(2);
        try {
            CommandHandler handler;
            Pattern filter = this.getFilter();
            if ((filter == null || filter.matcher(modifyCommmand).matches()) && (handler = this.getService()) != null) {
                handler.handleModify(modifyCommmand, (ModifyResults)results);
            }
        }
        catch (Throwable filter) {
            void t;
            FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.zos.command.processing.internal.CommandHandlerHolder", (String)"208", (Object)this, (Object[])new Object[]{modifyCommmand});
            results.setCompletionStatus(3);
            ArrayList<String> response = new ArrayList<String>();
            response.add("CommandHandlerHolder:deliverCommand Caught \"" + t.getClass().getName() + "\", " + t.getMessage());
            results.setResponses(response);
            results.setResponsesContainMSGIDs(false);
        }
        return results;
    }

    String getCommandHandlerName() {
        return this.targetHandlerName;
    }

    boolean displayHelp() {
        return this.displayHelp != null ? this.displayHelp : true;
    }

    List<String> getHelp() {
        List helpMsgs = null;
        CommandHandler handler = this.getService();
        if (handler != null) {
            helpMsgs = handler.getHelp();
        }
        return helpMsgs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";target=").append(this.target);
        sb.append(",serviceReference=").append(this.serviceReference);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CommandHandlerHolder.class);
    }
}

