/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cds;

import com.ibm.cds.CDSBundleFile;
import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapperChain;

public class CDSHookImpls
extends ClassLoaderHook
implements BundleFileWrapperFactoryHook {
    private static SharedClassHelperFactory factory = Shared.getSharedClassHelperFactory();
    private static Method minimizeMethod = null;
    private static boolean hasMinimizeMethod = true;

    private static CDSBundleFile getCDSBundleFile(BundleFile bundleFile) {
        CDSBundleFile cdsBundleFile = null;
        if (bundleFile instanceof BundleFileWrapperChain) {
            BundleFile wrapped = null;
            do {
                if ((wrapped = ((BundleFileWrapperChain)bundleFile).getWrapped()) instanceof CDSBundleFile) {
                    cdsBundleFile = (CDSBundleFile)wrapped;
                    break;
                }
                bundleFile = ((BundleFileWrapperChain)bundleFile).getNext();
            } while (wrapped != null);
        }
        return cdsBundleFile;
    }

    public void recordClassDefine(String name, Class clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        if (clazz == null || !this.hasMagicClassNumber(classbytes) || CDSHookImpls.getCDSBundleFile(classpathEntry.getBundleFile()) == null) {
            return;
        }
        try {
            byte[] originalClassBytes = entry.getBytes();
            if (originalClassBytes != classbytes) {
                boolean modified = false;
                modified = originalClassBytes.length == classbytes.length ? !Arrays.equals(classbytes, originalClassBytes) : true;
                if (modified) {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
        CDSBundleFile cdsFile = CDSHookImpls.getCDSBundleFile(classpathEntry.getBundleFile());
        if (cdsFile.getURL() == null) {
            return;
        }
        SharedClassURLHelper urlHelper = cdsFile.getURLHelper();
        if (urlHelper == null) {
            CDSBundleFile hostBundleFile = CDSHookImpls.getCDSBundleFile(manager.getGeneration().getBundleFile());
            if (hostBundleFile != null) {
                urlHelper = hostBundleFile.getURLHelper();
            }
            if (urlHelper != null) {
                cdsFile.setURLHelper(urlHelper);
            }
        }
        if (urlHelper != null) {
            urlHelper.storeSharedClass(cdsFile.getURL(), clazz);
            cdsFile.setPrimed(true);
        }
    }

    private boolean runMinimizeMethod(SharedClassURLHelper urlHelper) {
        if (hasMinimizeMethod && urlHelper != null) {
            if (minimizeMethod == null) {
                hasMinimizeMethod = false;
                try {
                    Class<?> c = urlHelper.getClass();
                    Field isSupported = c.getField("MINIMIZE_ENABLED");
                    if (isSupported != null && isSupported.getBoolean(urlHelper)) {
                        minimizeMethod = c.getMethod("setMinimizeUpdateChecks", null);
                        hasMinimizeMethod = true;
                    }
                }
                catch (Exception exception) {}
            }
            if (minimizeMethod != null) {
                try {
                    minimizeMethod.invoke((Object)urlHelper, null);
                    return true;
                }
                catch (Exception exception) {
                    hasMinimizeMethod = false;
                }
            }
        }
        return false;
    }

    private boolean hasMagicClassNumber(byte[] classbytes) {
        if (classbytes == null || classbytes.length < 4) {
            return false;
        }
        return (classbytes[0] & 0xCA) == 202 && (classbytes[1] & 0xFE) == 254 && (classbytes[2] & 0xBA) == 186 && (classbytes[3] & 0xBE) == 190;
    }

    public void classLoaderCreated(ModuleClassLoader classLoader) {
        if (factory == null) {
            return;
        }
        CDSBundleFile hostFile = null;
        try {
            SharedClassURLHelper urlHelper = factory.getURLHelper((ClassLoader)classLoader);
            boolean minimizeSucceeded = this.runMinimizeMethod(urlHelper);
            hostFile = CDSHookImpls.getCDSBundleFile(classLoader.getClasspathManager().getGeneration().getBundleFile());
            if (hostFile != null) {
                hostFile.setURLHelper(urlHelper);
                if (minimizeSucceeded) {
                    hostFile.setPrimed(true);
                }
            }
        }
        catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {}
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        CDSBundleFile sourceFile;
        CDSBundleFile hostFile = CDSHookImpls.getCDSBundleFile(hostmanager.getGeneration().getBundleFile());
        if (hostFile != (sourceFile = CDSHookImpls.getCDSBundleFile(sourceGeneration.getBundleFile())) && hostFile != null && sourceFile != null) {
            SharedClassURLHelper urlHelper = hostFile.getURLHelper();
            sourceFile.setURLHelper(urlHelper);
        }
        return false;
    }

    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        CDSBundleFile newBundleFile;
        if (!base && generation.getBundleInfo().getBundleId() != 0L) {
            SharedClassURLHelper urlHelper = null;
            Object baseFile = generation.getBundleFile();
            if ((baseFile = CDSHookImpls.getCDSBundleFile(baseFile)) != null) {
                urlHelper = ((CDSBundleFile)((Object)baseFile)).getURLHelper();
            }
            newBundleFile = new CDSBundleFile(bundleFile, urlHelper);
        } else {
            newBundleFile = new CDSBundleFile(bundleFile);
        }
        return newBundleFile;
    }
}

