/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.security;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.member.security.CollectiveCertificateConfig;
import com.ibm.ws.collective.security.CollectiveDNUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.collective.CollectiveAuthenticationPlugin;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={CollectiveAuthenticationPlugin.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.ranking:Integer=0"})
public class MemberCollectiveAuthenticationPlugin
implements CollectiveAuthenticationPlugin {
    private static final TraceComponent tc = Tr.register(MemberCollectiveAuthenticationPlugin.class);
    static final String KEY_COLLECTIVE_TRUST = "collectiveTrust";
    static final String KEY_COLLECTIVE_CERT_CONFIG_SERVICE_REF = "CollectiveCertificateConfig";
    static final String KEY_KEYSTORE_SERVICE_REF = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    private final AtomicServiceReference<CollectiveCertificateConfig> collectiveCertConfigServiceRef = new AtomicServiceReference("CollectiveCertificateConfig");
    private Object rdn;
    static final long serialVersionUID = -4307167475874130661L;

    @Activate
    protected void activate(ComponentContext cc) {
        this.keyStoreServiceRef.activate(cc);
        this.collectiveCertConfigServiceRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.keyStoreServiceRef.deactivate(cc);
    }

    @Reference(name="keyStoreService", service=KeyStoreService.class)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.setReference(reference);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> reference) {
        this.keyStoreServiceRef.unsetReference(reference);
    }

    @Reference(name="CollectiveCertificateConfig", service=CollectiveCertificateConfig.class)
    protected void setCollectiveCertificateConfig(ServiceReference<CollectiveCertificateConfig> reference) {
        this.collectiveCertConfigServiceRef.setReference(reference);
    }

    protected void unsetCollectiveCertificateConfig(ServiceReference<CollectiveCertificateConfig> ref) {
        this.collectiveCertConfigServiceRef.unsetReference(ref);
    }

    @FFDCIgnore(value={InvalidNameException.class})
    public boolean isCollectiveCertificateChain(X509Certificate[] certChain) {
        if (certChain.length != 2) {
            String dn = "Zero-length certificate chain";
            if (certChain.length >= 1) {
                dn = certChain[0].getSubjectX500Principal().getName();
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The certificate chain is not length 2, this is not a collective cert chain. Certificate DN: " + dn), (Object[])new Object[0]);
            }
            return false;
        }
        X509Certificate subjectCert = certChain[0];
        X509Certificate issuerCert = certChain[1];
        try {
            String dn = subjectCert.getSubjectX500Principal().getName();
            CollectiveDNUtil.validateCollectiveDNSyntax((String)dn);
            CollectiveDNUtil.validateCollectiveRootDNSyntax((String)subjectCert.getIssuerX500Principal().getName());
            CollectiveDNUtil.validateCollectiveRootDNSyntax((String)issuerCert.getSubjectX500Principal().getName());
            CollectiveDNUtil.validateCollectiveRootDNSyntax((String)issuerCert.getIssuerX500Principal().getName());
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The presented certificate chain is a collective cert chain. Proceeding to authentication with DN: " + dn), (Object[])new Object[0]);
            }
            return true;
        }
        catch (InvalidNameException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"InvalidNameException while processing cert chain in isCollectiveCertificateChain, certificate is not a Collective Certificate chain.", (Object[])new Object[]{e.getMessage()});
            }
            return false;
        }
    }

    @FFDCIgnore(value={InvalidNameException.class})
    public boolean isCollectiveCACertificate(X509Certificate[] certChain) {
        boolean isValidDC = false;
        if (certChain.length == 0) {
            String dn = "Zero-length certificate chain";
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The certificate is not a valid CA signed collective certificate. Certificate DN: " + dn), (Object[])new Object[0]);
            }
            return isValidDC;
        }
        X509Certificate subjectCert = certChain[0];
        try {
            String dn = subjectCert.getSubjectX500Principal().getName();
            isValidDC = this.validateCollectiveRDN(dn);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The presented CA signed certificate is valid collective certificate. Proceeding to authentication with DN: " + dn), (Object[])new Object[0]);
            }
            return isValidDC;
        }
        catch (InvalidNameException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"InvalidNameException while processing cert chain in isCollectiveCACertificate, certificate is not a valid third party Collective Certificate.", (Object[])new Object[]{e.getMessage()});
            }
            return isValidDC;
        }
    }

    public void authenticateCertificateChain(X509Certificate[] certChain, boolean collectiveCert) throws AuthenticationException {
        if (collectiveCert) {
            this.validateCollectiveCertificate(certChain);
        } else {
            this.validateCACertificate(certChain);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void validateCollectiveCertificate(X509Certificate[] certChain) throws AuthenticationException {
        if (certChain.length != 2) {
            String rejectedDN = "Zero-length certificate chain";
            if (certChain.length >= 1) {
                rejectedDN = certChain[0].getSubjectX500Principal().getName();
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The certificate chain is not length 2, this is not a collective cert chain. Rejecting authentication. Rejected DN: " + rejectedDN), (Object[])new Object[0]);
            }
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"MEMBER_SECURITY_REJECT_CERT", (Object[])new Object[]{rejectedDN}, (String)"CWWKX8131E: The presented certificate is not a collective certificate. Authentication is denied for DN: {0}"));
        }
        X509Certificate subjectCert = certChain[0];
        X509Certificate issuerCert = certChain[1];
        String subjectCertSubjectDN = subjectCert.getSubjectX500Principal().getName();
        try {
            CollectiveDNUtil.validateCollectiveDNSyntax((String)subjectCertSubjectDN);
            CollectiveDNUtil.validateCollectiveRootDNSyntax((String)subjectCert.getIssuerX500Principal().getName());
            CollectiveDNUtil.validateCollectiveRootDNSyntax((String)issuerCert.getSubjectX500Principal().getName());
            CollectiveDNUtil.validateCollectiveRootDNSyntax((String)issuerCert.getIssuerX500Principal().getName());
            CollectiveDNUtil.getCollectiveRole((String)subjectCertSubjectDN);
        }
        catch (InvalidNameException invalidNameException) {
            void e;
            FFDCFilter.processException((Throwable)invalidNameException, (String)"com.ibm.ws.collective.member.internal.security.MemberCollectiveAuthenticationPlugin", (String)"232", (Object)this, (Object[])new Object[]{certChain});
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected InvalidNameException during authenticateCertificateChain for what should have been a collective chain. Rejecting authentication.", (Object[])new Object[]{e});
            }
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"MEMBER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX8131E: The presented certificate is not a collective certificate. Authentication is denied for DN: {0}"), (Exception)e);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"The presented certificate chain is a controller collective cert chain. Authentication successful.", (Object[])new Object[0]);
        }
    }

    private void validateCACertificate(X509Certificate[] certChain) throws AuthenticationException {
        if (certChain.length == 0) {
            String rejectedDN = "Zero-length certificate chain";
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("The certificate chain is not length 1, this is not a collective cert chain. Rejecting authentication. Rejected DN: " + rejectedDN), (Object[])new Object[0]);
            }
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{rejectedDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
        }
        KeyStoreService ksServ = (KeyStoreService)this.keyStoreServiceRef.getService();
        String subjectCertSubjectDN = certChain[0].getSubjectX500Principal().getName();
        try {
            String alias = this.getSignerAlias(certChain, ksServ);
            if (alias.isEmpty()) {
                throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
            }
            X509Certificate cert = ksServ.getX509CertificateFromKeyStore(KEY_COLLECTIVE_TRUST, alias);
            certChain[0].verify(cert.getPublicKey());
        }
        catch (CertificateException alias) {
            FFDCFilter.processException((Throwable)alias, (String)"com.ibm.ws.collective.member.internal.security.MemberCollectiveAuthenticationPlugin", (String)"283", (Object)this, (Object[])new Object[]{certChain});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
        }
        catch (KeyStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.security.MemberCollectiveAuthenticationPlugin", (String)"291", (Object)this, (Object[])new Object[]{certChain});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
        }
        catch (InvalidKeyException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.security.MemberCollectiveAuthenticationPlugin", (String)"298", (Object)this, (Object[])new Object[]{certChain});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
        }
        catch (NoSuchAlgorithmException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.collective.member.internal.security.MemberCollectiveAuthenticationPlugin", (String)"305", (Object)this, (Object[])new Object[]{certChain});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
        }
        catch (NoSuchProviderException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.collective.member.internal.security.MemberCollectiveAuthenticationPlugin", (String)"312", (Object)this, (Object[])new Object[]{certChain});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
        }
        catch (SignatureException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.collective.member.internal.security.MemberCollectiveAuthenticationPlugin", (String)"319", (Object)this, (Object[])new Object[]{certChain});
            throw new AuthenticationException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages", (String)"CONTROLLER_SECURITY_REJECT_CERT", (Object[])new Object[]{subjectCertSubjectDN}, (String)"CWWKX9204E: The presented certificate is not a valid collective certificate. Authentication is denied for DN: {0}"));
        }
    }

    public boolean validateCollectiveRDN(String dn) throws InvalidNameException {
        Rdn configuredRdn;
        CollectiveCertificateConfig collectiveCertificateConfig = (CollectiveCertificateConfig)this.collectiveCertConfigServiceRef.getService();
        LdapName name = new LdapName(dn);
        List<Rdn> certificateDN = name.getRdns();
        if (!certificateDN.contains(configuredRdn = new Rdn(collectiveCertificateConfig.getRDN()))) {
            throw new InvalidNameException("Validation of the Collective CA signed certification failed. Incoming certificate relative distinguished name '" + dn + "' does not match configurated RDN '" + this.rdn + "'");
        }
        return true;
    }

    private String getSignerAlias(X509Certificate[] certChain, KeyStoreService ksServ) throws KeyStoreException, CertificateException {
        HashSet trustAliasList = (HashSet)ksServ.getTrustedCertEntriesInKeyStore(KEY_COLLECTIVE_TRUST);
        Iterator iterator = trustAliasList.iterator();
        X500Principal issuerPrincipal = certChain[0].getIssuerX500Principal();
        while (iterator.hasNext()) {
            String aliasName = (String)iterator.next();
            X509Certificate cert = ksServ.getX509CertificateFromKeyStore(KEY_COLLECTIVE_TRUST, aliasName);
            if (!cert.getSubjectX500Principal().equals(issuerPrincipal)) continue;
            return aliasName;
        }
        return "";
    }
}

