/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.MemberJMXEndpoint;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, service={}, configurationPid={"com.ibm.ws.management.repository.member.jmxEndpoint"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public final class MemberJMXEndpointImpl
implements MemberJMXEndpoint,
Runnable {
    private static final TraceComponent tc = Tr.register(MemberJMXEndpointImpl.class);
    private static final Map<String, String> emptyMap = Collections.emptyMap();
    private volatile EventAdmin eventAdmin = null;
    private volatile ScheduledExecutorService schedExec = null;
    static final int MAX_WAIT_MINUTES = 2;
    static final String CFG_KEY_DEFAULT_HOST_NAME = "_defaultHostName";
    static final String LOCALHOST = "localhost";
    static final String JMX_ALIAS = "jmxAlias";
    static final String JMXEndpointRef = "jmxEndpointObject";
    private final AtomicServiceReference<Object> jmxEndpointRef = new AtomicServiceReference("jmxEndpointObject");
    private boolean isActive = false;
    private boolean seenJMXEndpoint = false;
    private volatile String hostname = null;
    private volatile String httpsPort = null;
    private volatile String defaultHostName = null;
    private ComponentContext cc;
    private ServiceRegistration<?> registration = null;
    private ScheduledFuture<?> futureWarning = null;
    static final long serialVersionUID = 7088114508261671423L;

    @Reference(service=EventAdmin.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setEventAdminService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unsetEventAdminService(EventAdmin eventAdmin) {
    }

    @Reference(service=ScheduledExecutorService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setScheduledExecutorService(ScheduledExecutorService schedExec) {
        this.schedExec = schedExec;
    }

    protected void unsetScheduledExecutorService(ScheduledExecutorService schedExec) {
    }

    @Reference(name="jmxEndpointObject", service=Object.class, target="(name=JMXConnectorEndpoint)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setJMXEndpointObject(ServiceReference<Object> ref) {
        this.updatedJMXEndpointObject(ref);
    }

    protected synchronized void updatedJMXEndpointObject(ServiceReference<Object> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Update jmxEndpointObject ", (Object[])new Object[]{ref});
        }
        this.seenJMXEndpoint = true;
        this.jmxEndpointRef.setReference(ref);
        this.determineJMXEndpoint();
    }

    protected void unsetJMXEndpointObject(ServiceReference<Object> ref) {
        this.jmxEndpointRef.unsetReference(ref);
    }

    private void sendJMXEndpointChangedEvent(String newHost, String newPort) {
        this.eventAdmin.postEvent(new Event("com/ibm/ws/management/repository/member/MemberJMXEndpoint/updated", emptyMap));
    }

    private void unregisterService() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    private void registerService() {
        if (this.registration == null) {
            this.registration = this.cc.getBundleContext().registerService(MemberJMXEndpoint.class, (Object)this, null);
        }
    }

    private synchronized void determineJMXEndpoint() {
        if (!this.isActive) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"We are not active or have been deactivated, nothing to do...", (Object[])new Object[]{this.isActive});
            }
            return;
        }
        ServiceReference ref = this.jmxEndpointRef.getReference();
        if (ref == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The JMX Endpoint does not exist yet, nothing to do.. ", (Object[])new Object[0]);
            }
            return;
        }
        String oldHost = this.hostname;
        String oldPort = this.httpsPort;
        String host = (String)ref.getProperty("jmxHost");
        String alias = (String)ref.getProperty(JMX_ALIAS);
        if (alias != null && alias.startsWith("*")) {
            if (LOCALHOST.equals(this.defaultHostName)) {
                host = LOCALHOST;
            }
            if (LOCALHOST.equals(host)) {
                host = this.defaultHostName;
            }
        }
        this.hostname = host;
        this.httpsPort = ref.getProperty("jmxPort").toString();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("JMX endpoint has been determined: host=" + this.hostname + " port=" + this.httpsPort + ". Previous endpoint: host=" + oldHost + " port=" + oldPort), (Object[])new Object[0]);
        }
        if (this.stringChanged(oldHost, this.hostname) || this.stringChanged(oldPort, this.httpsPort)) {
            this.sendJMXEndpointChangedEvent(this.httpsPort, this.hostname);
        }
        if (this.hostname != null && this.httpsPort != null) {
            this.registerService();
        } else {
            this.unregisterService();
        }
    }

    @Trivial
    private boolean stringChanged(String oldValue, String newValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    @Activate
    protected synchronized void activate(ComponentContext cc, @Sensitive Map<String, Object> properties) {
        this.cc = cc;
        this.isActive = true;
        this.jmxEndpointRef.activate(cc);
        this.modified(properties);
        if (this.hostname == null || this.httpsPort == null) {
            this.futureWarning = this.schedExec.schedule(this, 2L, TimeUnit.MINUTES);
        }
    }

    @Override
    public synchronized void run() {
        ServiceReference ref;
        this.futureWarning = null;
        if (this.isActive && !FrameworkState.isStopping() && !this.seenJMXEndpoint && (ref = this.jmxEndpointRef.getReference()) == null) {
            Tr.warning((TraceComponent)tc, (String)"JMX_ENDPOINT_NO_DEFAULT_HOST", (Object[])new Object[]{2});
        }
    }

    @Modified
    protected synchronized void modified(@Sensitive Map<String, Object> properties) {
        this.defaultHostName = (String)properties.get(CFG_KEY_DEFAULT_HOST_NAME);
        this.determineJMXEndpoint();
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc) {
        this.isActive = false;
        if (this.futureWarning != null) {
            this.futureWarning.cancel(false);
            this.futureWarning = null;
        }
        this.unregisterService();
        this.jmxEndpointRef.deactivate(cc);
    }

    @Override
    public synchronized String getHostName() {
        return this.hostname;
    }

    @Override
    public synchronized String getHTTPSPort() {
        return this.httpsPort;
    }
}

