/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.product.utility.BaseCommandTask;
import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.ExecutionContext;
import com.ibm.ws.product.utility.extension.FileUtils;
import com.ibm.ws.product.utility.extension.IFixUtils;
import com.ibm.ws.product.utility.extension.MD5Utils;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.product.utility.extension.ifix.xml.UpdatedFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ValidateCommandTask
extends BaseCommandTask {
    public static final String VALIDATE_TASK_NAME = "validate";
    private File wlpInstallRoot;
    private CommandConsole commandConsole;
    private boolean printErrorOnly = false;
    private boolean printStartMessage = false;
    private int overallFailed = 0;

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>();
    }

    @Override
    public String getTaskName() {
        return VALIDATE_TASK_NAME;
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("validate.desc", new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return super.getTaskHelp("validate.desc", "validate.usage.options", "validate.option-key.", "validate.option-desc.", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(ExecutionContext context) {
        this.commandConsole = context.getCommandConsole();
        this.wlpInstallRoot = context.getAttribute("WLP_INSTALLATION_LOCATION", File.class);
        try {
            if (!this.printErrorOnly || this.printStartMessage) {
                this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.start", new Object[0]));
            }
            ManifestFileProcessor mfp = new ManifestFileProcessor();
            Map features = mfp.getFeatureDefinitions();
            for (ProvisioningFeatureDefinition pfd : features.values()) {
                StringBuilder result = new StringBuilder();
                Formatter formatter = new Formatter(result);
                String featureName = pfd.getFeatureName();
                File csFile = pfd.getFeatureChecksumFile();
                if (!csFile.exists()) continue;
                FileInputStream csis = null;
                Properties csprops = new Properties();
                try {
                    csis = new FileInputStream(csFile);
                    csprops.load(csis);
                }
                catch (IOException e) {
                    try {
                        this.commandConsole.printInfoMessage(this.getMessage("info.validate.validating.feature", featureName));
                        this.commandConsole.printlnErrorMessage(this.getMessage("ERROR_CHECKSUMS_FILE_NOT_LOADED", csFile.getAbsoluteFile()));
                        this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.exception", e.getMessage()));
                    }
                    catch (Throwable throwable) {
                        FileUtils.tryToClose(csis);
                        throw throwable;
                    }
                    FileUtils.tryToClose(csis);
                    return;
                }
                FileUtils.tryToClose(csis);
                boolean resultFlag = true;
                for (String string : csprops.keySet()) {
                    String jarChecksum = csprops.getProperty(string);
                    File installRoot = csFile.getParentFile().getParentFile().getParentFile().getParentFile();
                    File jarFile = new File(installRoot, string);
                    if (!jarFile.exists()) {
                        formatter.format("  %1$s %2$s%n", this.getMessage("info.validate.validating.result.error", new Object[0]), this.getMessage("info.validate.content.file.not.exist", string));
                        ++this.overallFailed;
                        resultFlag = false;
                        continue;
                    }
                    if (this.validate(jarFile, jarChecksum, string)) continue;
                    formatter.format("  %1$s %2$s%n", this.getMessage("info.validate.validating.result.error", new Object[0]), this.getMessage("info.validate.content.file.broken", string));
                    ++this.overallFailed;
                    resultFlag = false;
                }
                if (resultFlag && pfd.getVisibility() != Visibility.PUBLIC) continue;
                this.printResult(featureName, resultFlag, result.toString());
            }
            if (this.overallFailed == 0) {
                Set<String> fixesToReApply = ValidateCommandTask.getFixesToReapply(mfp, this.commandConsole);
                if (!fixesToReApply.isEmpty()) {
                    this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.fixes.need.reapplying", fixesToReApply));
                }
                this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.success", new Object[0]));
            } else {
                this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.fail", this.overallFailed));
            }
        }
        catch (ValidateException e) {
            this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.exception", e.getMessage()));
            return;
        }
    }

    private boolean validate(File targetFile, String expectedChecksum, String jarPath) throws ValidateException {
        Map<String, IFixInfo> latestFixInfos;
        IFixInfo latestFixInfo;
        String realchecksum;
        try {
            realchecksum = MD5Utils.getFileMD5String(targetFile);
        }
        catch (IOException e) {
            this.commandConsole.printlnErrorMessage(this.getMessage("ERROR_UNABLE_READ_FILE", targetFile.getAbsoluteFile(), e.getMessage()));
            throw new ValidateException();
        }
        boolean validated = realchecksum.equals(expectedChecksum);
        if (!validated && (latestFixInfo = (latestFixInfos = IFixUtils.getLatestFixInfos(this.wlpInstallRoot, this.commandConsole)).get(jarPath)) != null) {
            for (UpdatedFile updatedFile : latestFixInfo.getUpdates().getFiles()) {
                if (!updatedFile.getId().equals(jarPath)) continue;
                String ifixedHashCode = updatedFile.getHash();
                validated = realchecksum.equals(ifixedHashCode);
            }
        }
        return validated;
    }

    private void printResult(String featureName, boolean flag, String result) {
        if (flag) {
            if (!this.printErrorOnly) {
                this.commandConsole.printInfoMessage(this.getMessage("info.validate.validating.feature", featureName));
                this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.validating.result.pass", new Object[0]));
            }
        } else {
            this.commandConsole.printInfoMessage(this.getMessage("info.validate.validating.feature", featureName));
            this.commandConsole.printlnInfoMessage(this.getMessage("info.validate.validating.result.fail", new Object[0]));
            this.commandConsole.printInfoMessage(result);
        }
    }

    public static Set<String> getFixesToReapply(ManifestFileProcessor mfp, CommandConsole commandConsole) {
        HashSet<String> fixesToReApply = new HashSet<String>();
        for (Map.Entry entry : mfp.getFeatureDefinitionsByProduct().entrySet()) {
            String productExtensionName = (String)entry.getKey();
            Map productFeatures = (Map)entry.getValue();
            ContentBasedLocalBundleRepository bundleRepo = null;
            File installLocation = new File(mfp.getProdFeatureLocation(productExtensionName));
            bundleRepo = productExtensionName == "core" ? mfp.getBundleRepository("", null) : mfp.getBundleRepository(productExtensionName, null);
            if (installLocation == null) continue;
            fixesToReApply.addAll(IFixUtils.getIFixesThatMustBeReapplied(installLocation, productFeatures, bundleRepo, commandConsole));
        }
        return fixesToReApply;
    }

    public void setPrintErrorOnly(boolean printErrorOnly) {
        this.printErrorOnly = printErrorOnly;
    }

    public void setPrintStartMessage(boolean printStartMessage) {
        this.printStartMessage = printStartMessage;
    }

    public boolean isSuccessful() {
        return this.overallFailed == 0;
    }

    private static class ValidateException
    extends Exception {
        private ValidateException() {
        }
    }
}

