/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.probeExtensionImpl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.request.timing.config.HungRequestTimingConfig;
import com.ibm.ws.request.timing.manager.HungRequestManager;
import com.ibm.ws.request.timing.manager.ProbationaryRequestManager;
import com.ibm.ws.request.timing.queue.DelayedRequestQueue;
import com.ibm.ws.request.timing.queue.HungRequest;
import com.ibm.wsspi.probeExtension.ProbeExtension;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.util.List;

public class HungRequestProbeExtension
implements ProbeExtension {
    private static final TraceComponent tc = Tr.register(HungRequestProbeExtension.class, (String)"requestTiming", (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private volatile HungRequestTimingConfig config = new HungRequestTimingConfig();
    private final DelayedRequestQueue<HungRequest> requestQueue = new DelayedRequestQueue();
    private final ProbationaryRequestManager<HungRequestTimingConfig, HungRequest> probHungReqMgr = new ProbationaryRequestManager<HungRequestTimingConfig, HungRequest>(this.config, this.requestQueue, HungRequest.class);
    private final HungRequestManager hungReqMgr = new HungRequestManager(this.requestQueue);
    private volatile boolean hasStopped = false;

    public void processEntryEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processEntryEvent " + event), (Object[])new Object[0]);
        }
        if (!this.hasStopped) {
            this.probHungReqMgr.setLastRequestTime(System.nanoTime());
            this.probHungReqMgr.startTimer();
            this.hungReqMgr.startHandler();
        }
    }

    public void processExitEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processExitEvent " + event), (Object[])new Object[0]);
        }
        if (!this.hasStopped) {
            this.hungReqMgr.logMessageIfHung(requestContext);
        }
    }

    public void setConfig(HungRequestTimingConfig config) {
        this.config = config;
        this.probHungReqMgr.setConfig(config);
    }

    public void updateConfig(HungRequestTimingConfig config) {
        this.config = config;
        this.probHungReqMgr.resetTimer(this.config);
    }

    public void stop() {
        this.hasStopped = true;
        this.probHungReqMgr.stopTimer();
        this.hungReqMgr.stopHandler();
        this.requestQueue.clear();
    }

    public void processCounter(Event event) {
    }

    public int getRequestSampleRate() {
        return this.config.getSampleRate();
    }

    public boolean invokeForRootEventsOnly() {
        return true;
    }

    public boolean invokeForEventEntry() {
        return true;
    }

    public boolean invokeForEventExit() {
        return true;
    }

    public List<String> invokeForEventTypes() {
        return null;
    }

    public boolean invokeForCounter() {
        return false;
    }

    public int getContextInfoRequirement() {
        return this.config.getContextInfoRequirement();
    }
}

