/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.manager;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.request.timing.RequestTimingService;
import com.ibm.ws.request.timing.manager.ThreadDumpManager;
import com.ibm.ws.request.timing.queue.DelayedRequestQueue;
import com.ibm.ws.request.timing.queue.HungRequest;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class HungRequestManager {
    private static final TraceComponent tc = Tr.register(HungRequestManager.class, (String)"requestTiming", (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS(HungRequestManager.class, (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private final ConcurrentHashMap<String, RequestContext> hungRequests;
    private final DelayedRequestQueue<HungRequest> requestQueue;
    private final ThreadDumpManager threadDumpScheduler;
    private final Object syncHandlerObject = new Object(){};
    private volatile Future<?> future = null;
    private final Runnable hungRequestHandler = new Runnable(){

        @Override
        @Trivial
        public void run() {
            while (true) {
                try {
                    while (true) {
                        final HungRequest hungRequest = (HungRequest)HungRequestManager.this.requestQueue.processNext();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Removing request from the queue...", (Object[])new Object[]{hungRequest.toString()});
                        }
                        Runnable hungRequestTask = new Runnable(){

                            @Override
                            @Trivial
                            public void run() {
                                try {
                                    HungRequest request = hungRequest;
                                    boolean includeContextInfo = request.includeContextInfo();
                                    RequestContext requestContext = request.getRequestContext();
                                    long hungReqThreshold = request.getHungRequestThreshold();
                                    if (requestContext.getRequestState() != 100) {
                                        if (tc.isWarningEnabled()) {
                                            double activeTime = (double)(System.nanoTime() - requestContext.getRootEvent().getStartTime()) / 1000000.0;
                                            Tr.warning((TraceComponent)tc, (String)"HUNG_REQUEST_WARNING", (Object[])new Object[]{requestContext.getRequestId().getId(), DataFormatHelper.padHexString((int)((int)requestContext.getThreadId()), (int)8), String.format("%.3f", activeTime), requestContext.getRequestState() == 11 ? RequestContext.dumpTree((Event)requestContext.getRootEvent(), (boolean)includeContextInfo) + nls.getString("TRUNCATED_REQUEST_MESSAGE", null) : RequestContext.dumpTree((Event)requestContext.getRootEvent(), (boolean)includeContextInfo)});
                                        }
                                        if (HungRequestManager.this.hungRequests.putIfAbsent(requestContext.getRequestId().getId(), requestContext) == null) {
                                            HungRequestManager.this.threadDumpScheduler.startTimer();
                                        }
                                        request.resetDelay(hungReqThreshold);
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Re-queuing request ...", (Object[])new Object[]{request.toString()});
                                        }
                                        HungRequestManager.this.requestQueue.requeueRequest(request);
                                    } else {
                                        HungRequestManager.this.hungRequests.remove(requestContext.getRequestId().getId());
                                        HungRequestManager.this.requestQueue.removeRequest(request);
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Discarding request..", (Object[])new Object[]{request.toString()});
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"157", (Object)this);
                                }
                            }
                        };
                        RequestTimingService.getExecutorService().submit(hungRequestTask);
                    }
                }
                catch (InterruptedException exit) {
                }
                catch (Exception e) {
                    HungRequestManager.this.stopHandler();
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"167", (Object)this);
                    continue;
                }
                break;
            }
        }
    };

    public HungRequestManager(DelayedRequestQueue<HungRequest> queue) {
        this.requestQueue = queue;
        this.hungRequests = new ConcurrentHashMap();
        this.threadDumpScheduler = new ThreadDumpManager(3, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHandler() {
        if (this.future == null) {
            boolean startedHandler = false;
            Object object = this.syncHandlerObject;
            synchronized (object) {
                if (this.future == null) {
                    this.future = RequestTimingService.getExecutorService().submit(this.hungRequestHandler);
                    startedHandler = true;
                }
            }
            if (startedHandler && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Starting hung request handler", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHandler() {
        boolean stoppedHandler = false;
        Object object = this.syncHandlerObject;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
                stoppedHandler = true;
                this.threadDumpScheduler.stopTimer();
            }
        }
        if (stoppedHandler && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Stopping hung request handler.", (Object[])new Object[0]);
        }
    }

    public void logMessageIfHung(RequestContext requestContext) {
        if (this.hungRequests.containsKey(requestContext.getRequestId().getId())) {
            double totalHungDuration = (double)(System.nanoTime() - requestContext.getRootEvent().getStartTime()) / 1000000.0;
            if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"HUNG_REQUEST_COMPLETED_INFO", (Object[])new Object[]{requestContext.getRequestId().getId(), DataFormatHelper.padHexString((int)((int)requestContext.getThreadId()), (int)8), String.format("%.3f", totalHungDuration)});
            }
        }
    }
}

