/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.config;

import com.ibm.ws.request.timing.config.Timing;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RequestTimingConfig {
    private final int sampleRate;
    private final int contextInfoRequirement;
    private final long requestThresholdMin;
    private final long requestThresholdMax;
    private final Map<String, Timing> requestTiming;
    private final Map<String, Timing> unmodifiableMap;

    public RequestTimingConfig(int sampleRate, int contextInfoRequirement, Map<String, Timing> requestTiming) {
        this.sampleRate = sampleRate;
        this.contextInfoRequirement = contextInfoRequirement;
        this.requestTiming = requestTiming;
        this.unmodifiableMap = Collections.unmodifiableMap(requestTiming);
        this.requestThresholdMin = this.getReqThresholdMin();
        this.requestThresholdMax = this.getReqThresholdMax();
    }

    public RequestTimingConfig() {
        this(1, 2, new HashMap<String, Timing>());
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getContextInfoRequirement() {
        return this.contextInfoRequirement;
    }

    public Map<String, Timing> getRequestTiming() {
        return this.unmodifiableMap;
    }

    public long getRequestThresholdMin() {
        return this.requestThresholdMin;
    }

    public long getRequestThresholdMax() {
        return this.requestThresholdMax;
    }

    public long getRequestThreshold(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' can not be null");
        }
        if (this.requestTiming.containsKey(type)) {
            return this.requestTiming.get(type).getRequestThreshold();
        }
        return this.requestTiming.get("all").getRequestThreshold();
    }

    private long getReqThresholdMin() {
        long requestThreasholdMin = Long.MAX_VALUE;
        for (Map.Entry<String, Timing> entry : this.requestTiming.entrySet()) {
            if (entry.getValue().getRequestThreshold() <= 0L) continue;
            requestThreasholdMin = Math.min(requestThreasholdMin, entry.getValue().getRequestThreshold());
        }
        if (requestThreasholdMin == Long.MAX_VALUE) {
            requestThreasholdMin = 0L;
        }
        return requestThreasholdMin;
    }

    private long getReqThresholdMax() {
        long requestThreasholdMax = Long.MIN_VALUE;
        for (Map.Entry<String, Timing> entry : this.requestTiming.entrySet()) {
            requestThreasholdMax = Math.max(requestThreasholdMax, entry.getValue().getRequestThreshold());
        }
        return requestThreasholdMax;
    }
}

