/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.request.timing.config.HungRequestTimingConfig;
import com.ibm.ws.request.timing.config.SlowRequestTimingConfig;
import com.ibm.ws.request.timing.config.Timing;
import com.ibm.ws.request.timing.probeExtensionImpl.HungRequestProbeExtension;
import com.ibm.ws.request.timing.probeExtensionImpl.SlowRequestProbeExtension;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

public class RequestTimingService {
    private static final TraceComponent tc = Tr.register(RequestTimingService.class);
    private volatile ConfigurationAdmin configAdmin = null;
    private volatile SlowRequestProbeExtension slowRequestProbeExt = null;
    private volatile HungRequestProbeExtension hungRequestProbeExt = null;
    private static volatile ScheduledExecutorService scheduledExecSrvc = null;
    private static volatile ExecutorService executorSrvc = null;
    private static volatile LibertyProcess libertyProcess = null;

    @Activate
    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        this.configureService(configuration, false);
    }

    @Modified
    protected void modified(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Modified " + this), (Object[])new Object[0]);
        }
        this.configureService(configuration, true);
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
        this.slowRequestProbeExt.stop();
        this.hungRequestProbeExt.stop();
    }

    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    protected void setScheduledExecutor(ScheduledExecutorService scheduledExecSrvc) {
        RequestTimingService.scheduledExecSrvc = scheduledExecSrvc;
    }

    protected void unsetScheduledExecutor(ScheduledExecutorService scheduledExecSrvc) {
        RequestTimingService.scheduledExecSrvc = null;
    }

    protected void setExecutor(ExecutorService executorSrvc) {
        RequestTimingService.executorSrvc = executorSrvc;
    }

    protected void unsetExecutor(ExecutorService executorSrvc) {
        RequestTimingService.executorSrvc = null;
    }

    protected void setLibertyProcess(LibertyProcess libertyProcess) {
        RequestTimingService.libertyProcess = libertyProcess;
    }

    protected void unsetLibertyProcess(LibertyProcess libertyProcess) {
        RequestTimingService.libertyProcess = null;
    }

    protected void setSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = probeExt;
    }

    protected void unsetSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = null;
    }

    protected void setHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = probeExt;
    }

    protected void unsetHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = null;
    }

    private void configureService(Map<String, Object> configuration, boolean modified) {
        long slowRequestThreshold = 10000L;
        long hungRequestThreshold = 600000L;
        int sampleRate = 1;
        int contextInfoRequirement = 0;
        HashMap<String, Timing> slowRequestTiming = new HashMap<String, Timing>();
        HashMap<String, Timing> hungRequestTiming = new HashMap<String, Timing>();
        if (configuration.containsKey("sampleRate") && (sampleRate = Integer.parseInt(configuration.get("sampleRate").toString())) < 1) {
            sampleRate = 1;
        }
        if (configuration.containsKey("includeContextInfo")) {
            boolean includeContextInfo = Boolean.parseBoolean(configuration.get("includeContextInfo").toString());
            contextInfoRequirement = includeContextInfo ? 0 : 2;
        }
        if (configuration.containsKey("slowRequestThreshold")) {
            slowRequestThreshold = Long.parseLong(configuration.get("slowRequestThreshold").toString());
        }
        if (configuration.containsKey("hungRequestThreshold")) {
            hungRequestThreshold = Long.parseLong(configuration.get("hungRequestThreshold").toString());
        }
        slowRequestTiming.put("all", new Timing("all", slowRequestThreshold));
        hungRequestTiming.put("all", new Timing("all", hungRequestThreshold));
        Configuration config = null;
        String[] timingPids = (String[])configuration.get("timing");
        if (timingPids != null && this.configAdmin != null) {
            for (String timingPid : timingPids) {
                try {
                    config = this.configAdmin.getConfiguration(timingPid);
                    Dictionary configElement = config.getProperties();
                    long typeSlowReqThreshold = 0L;
                    long typeHungReqThreshold = 0L;
                    typeSlowReqThreshold = configElement.get("slowRequestThreshold") != null ? Long.parseLong(configElement.get("slowRequestThreshold").toString()) : slowRequestThreshold;
                    typeHungReqThreshold = configElement.get("hungRequestThreshold") != null ? Long.parseLong(configElement.get("hungRequestThreshold").toString()) : hungRequestThreshold;
                    String type = configElement.get("eventType").toString();
                    slowRequestTiming.put(type, new Timing(type, typeSlowReqThreshold));
                    hungRequestTiming.put(type, new Timing(type, typeHungReqThreshold));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        SlowRequestTimingConfig slowReqTimingConfig = new SlowRequestTimingConfig(sampleRate, contextInfoRequirement, slowRequestTiming);
        HungRequestTimingConfig hungReqTimingConfig = new HungRequestTimingConfig(contextInfoRequirement, hungRequestTiming);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Request timing configuration", (Object[])new Object[]{slowReqTimingConfig, hungReqTimingConfig});
        }
        if (modified) {
            this.slowRequestProbeExt.updateConfig(slowReqTimingConfig);
            this.hungRequestProbeExt.updateConfig(hungReqTimingConfig);
        } else {
            this.slowRequestProbeExt.setConfig(slowReqTimingConfig);
            this.hungRequestProbeExt.setConfig(hungReqTimingConfig);
        }
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecSrvc;
    }

    public static ExecutorService getExecutorService() {
        return executorSrvc;
    }

    public static LibertyProcess getLibertyProcess() {
        return libertyProcess;
    }
}

