/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.utils;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.utils.BaseLinksBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinksBuilderImpl<T>
implements BaseLinksBuilder<T> {
    protected Map<String, String> pathParams;
    protected MultivaluedMap<String, String> queryParams;
    protected ResourceRecord record;
    protected String resourcePath;
    protected String subResourcePath;
    protected URI baseUri;
    protected URI relativeTo;
    protected MessageContext context;
    protected ResourceRegistry registry;
    protected boolean relativize;
    protected boolean addAltParam;

    protected AbstractLinksBuilderImpl(MessageContext context) {
        this.context = context;
        this.registry = context.getAttribute(ResourceRegistry.class);
        this.pathParams = new HashMap<String, String>();
        this.queryParams = new MultivaluedMapImpl<String, String>();
        this.record = context.getAttribute(SearchResult.class).getResource().getRecord();
        this.initPaths();
        this.initRelativize();
        this.initAddAltParam();
        this.baseUri(null);
        this.relativeTo = null;
    }

    private void initPaths() {
        UriInfo uriInfo = this.context.getUriInfo();
        this.resourcePath = null;
        this.subResourcePath = null;
        List matchedURIs = uriInfo.getMatchedURIs(false);
        if (matchedURIs.size() == 1) {
            this.resourcePath = (String)matchedURIs.get(0);
            this.subResourcePath = null;
        } else {
            List matchedResources = uriInfo.getMatchedResources();
            if (matchedURIs.size() == matchedResources.size()) {
                this.resourcePath = (String)matchedURIs.get(0);
                this.subResourcePath = null;
            } else {
                this.resourcePath = (String)matchedURIs.get(1);
                this.subResourcePath = ((String)matchedURIs.get(0)).substring(this.resourcePath.length() + 1);
            }
        }
    }

    private void initRelativize() {
        this.relativize = Boolean.parseBoolean(this.context.getProperties().getProperty("wink.defaultUrisRelative", "true"));
        String relative = (String)this.context.getUriInfo().getQueryParameters(false).getFirst((Object)"relative-urls");
        if (relative != null) {
            this.relativize = Boolean.parseBoolean(relative);
        }
    }

    private void initAddAltParam() {
        this.addAltParam = Boolean.parseBoolean(this.context.getProperties().getProperty("wink.addAltParam", "true"));
    }

    @Override
    public final T resource(Class<?> resource) {
        this.record = this.registry.getRecord(resource);
        this.resourcePath = this.record.getTemplateProcessor().getTemplate();
        this.subResourcePath = null;
        return (T)this;
    }

    @Override
    public final T resource(Object resource) {
        this.record = this.registry.getRecord(resource);
        this.resourcePath = this.record.getTemplateProcessor().getTemplate();
        this.subResourcePath = null;
        return (T)this;
    }

    @Override
    public final T subResource(String template) {
        this.subResourcePath = UriTemplateProcessor.normalizeUri(template);
        return (T)this;
    }

    @Override
    public final T pathParam(String name, String value) {
        this.pathParams.put(name, value);
        return (T)this;
    }

    @Override
    public final T queryParam(String name, String value) {
        this.queryParams.add((Object)name, (Object)value);
        return (T)this;
    }

    @Override
    public final T baseUri(URI base) {
        this.baseUri = base;
        if (this.baseUri == null) {
            this.baseUri = this.context.getUriInfo().getBaseUri();
        }
        return (T)this;
    }

    @Override
    public final T relativeTo(URI relativeTo) {
        this.relativeTo = relativeTo;
        return (T)this;
    }

    @Override
    public final T relativize(boolean relativize) {
        this.relativize = relativize;
        return (T)this;
    }

    @Override
    public final T addAltParam(boolean addAltParam) {
        this.addAltParam = addAltParam;
        return (T)this;
    }

    protected UriBuilder initUriBuilder() {
        return this.initUriBuilder(this.resourcePath);
    }

    protected UriBuilder initUriBuilder(String path) {
        UriBuilder builder = null;
        if (this.relativize) {
            builder = UriBuilder.fromPath((String)path);
        } else {
            builder = UriBuilder.fromUri((URI)this.baseUri);
            if (this.baseUri.getPath() != null && this.baseUri.getPath().equals("/")) {
                builder.replacePath(path);
            } else {
                builder.path(path);
            }
        }
        return builder;
    }

    protected SyndLink getLink(Collection<SyndLink> links, String relation) {
        for (SyndLink link : links) {
            if (!relation.equals(link.getRel())) continue;
            return link;
        }
        return null;
    }

    protected SyndLink createLink(String rel, MediaType type, URI href) {
        String hrefStr = this.resolveLink(href);
        return new SyndLink(rel, type != null ? type.toString() : null, hrefStr);
    }

    protected String resolveLink(URI link) {
        if (!this.relativize) {
            return link.toString();
        }
        String relative = null;
        if (this.relativeTo == null) {
            relative = this.context.getUriInfo().getPath(false);
        } else {
            URI relativeUri = this.baseUri.relativize(this.relativeTo);
            relative = relativeUri.toString();
        }
        return UriHelper.relativize(relative, link.toString());
    }

    @Override
    public abstract List<SyndLink> build(List<SyndLink> var1);
}

