/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.wink.common.categories.Categories;
import org.apache.wink.common.categories.CollectionCategories;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDocumentCollectionData {
    private String workspace;
    private String title;
    private String uri;
    private Collection<MediaType> accepts;
    private List<Categories> categories;
    private Set<MediaType> produces;
    private static final CollectionComparator COLLECTION_COMPARATOR = new CollectionComparator();

    public ServiceDocumentCollectionData(String workspace, String title, String uri, Collection<MediaType> accepts, List<Categories> categories, Set<MediaType> produces) {
        this.workspace = workspace;
        this.title = title;
        this.uri = uri;
        this.accepts = accepts;
        this.categories = categories;
        this.produces = produces;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Collection<MediaType> getAccepts() {
        return this.accepts;
    }

    public void setAccepts(Collection<MediaType> accepts) {
        this.accepts = accepts;
    }

    public List<Categories> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Categories> categories) {
        this.categories = categories;
    }

    public Set<MediaType> getProduces() {
        return this.produces;
    }

    public void setProduces(Set<MediaType> produces) {
        this.produces = produces;
    }

    public static List<ServiceDocumentCollectionData> buildServiceDocumentCollectionList(UriInfo uriInfo) {
        ResourceRegistry resourceRegistry = RuntimeContextTLS.getRuntimeContext().getAttribute(ResourceRegistry.class);
        ArrayList<ServiceDocumentCollectionData> collections = new ArrayList<ServiceDocumentCollectionData>();
        for (ResourceRecord record : resourceRegistry.getRecords()) {
            ClassMetadata metadata = record.getMetadata();
            if (metadata.getWorkspaceName() == null) continue;
            List<Categories> collectionCategories = ServiceDocumentCollectionData.getCollectionCategories(record, resourceRegistry, uriInfo);
            UriTemplateProcessor template = record.getTemplateProcessor();
            Set<MediaType> consumes = ServiceDocumentCollectionData.getCollectionConsumes(metadata);
            Set<MediaType> produces = ServiceDocumentCollectionData.getCollectionProduces(metadata);
            ServiceDocumentCollectionData sd = new ServiceDocumentCollectionData(metadata.getWorkspaceName(), metadata.getCollectionTitle(), template.toString(), consumes, collectionCategories, produces);
            collections.add(sd);
        }
        if (collections != null) {
            Collections.sort(collections, COLLECTION_COMPARATOR);
        }
        return collections;
    }

    private static Set<MediaType> getCollectionConsumes(ClassMetadata metadata) {
        HashSet<MediaType> consumes = new HashSet<MediaType>();
        for (MethodMetadata method : metadata.getResourceMethods()) {
            if (!method.getHttpMethod().equals("POST")) continue;
            consumes.addAll(method.getConsumes());
        }
        for (MethodMetadata method : metadata.getSubResourceMethods()) {
            if (!method.getHttpMethod().equals("POST")) continue;
            consumes.addAll(method.getConsumes());
        }
        return consumes;
    }

    private static Set<MediaType> getCollectionProduces(ClassMetadata metadata) {
        HashSet<MediaType> produces = new HashSet<MediaType>();
        for (MethodMetadata method : metadata.getResourceMethods()) {
            produces.addAll(method.getProduces());
        }
        for (MethodMetadata method : metadata.getSubResourceMethods()) {
            produces.addAll(method.getProduces());
        }
        return produces;
    }

    private static List<Categories> getCollectionCategories(ResourceRecord record, ResourceRegistry resourceRegistry, UriInfo uriInfo) {
        List<Categories> collectionCategories = null;
        if (CollectionCategories.class.isAssignableFrom(record.getMetadata().getResourceClass())) {
            Object instance = record.getObjectFactory().getInstance(null);
            collectionCategories = ((CollectionCategories)instance).getCategories();
        }
        if (collectionCategories != null) {
            ServiceDocumentCollectionData.resolveOutOfLineCategoriesListHref(collectionCategories, resourceRegistry, uriInfo);
        }
        return collectionCategories;
    }

    private static void resolveOutOfLineCategoriesListHref(List<Categories> collectionCategories, ResourceRegistry resourceRegistry, UriInfo uriInfo) {
        for (Categories categories : collectionCategories) {
            if (!categories.isOutOfLine()) continue;
            ServiceDocumentCollectionData.resolveOutOfLineCategoriesHref(categories, resourceRegistry, uriInfo);
        }
    }

    private static void resolveOutOfLineCategoriesHref(Categories categories, ResourceRegistry resourceRegistry, UriInfo uriInfo) {
        String categoriesDocUri = null;
        if (categories.getHref() != null) {
            return;
        }
        if (categories.getHandlingClass() != null) {
            ResourceRecord record = resourceRegistry.getRecord(categories.getHandlingClass());
            categoriesDocUri = ServiceDocumentCollectionData.getCategoriesDocBaseUri(categories, record);
        } else if (categories.getHandlingInstance() != null) {
            ResourceRecord record = resourceRegistry.getRecord(categories.getHandlingInstance());
            categoriesDocUri = ServiceDocumentCollectionData.getCategoriesDocBaseUri(categories, record);
        }
        if (categoriesDocUri != null) {
            categoriesDocUri = UriHelper.appendPathToBaseUri(uriInfo.getBaseUri().toString(), categoriesDocUri);
            categoriesDocUri = UriHelper.appendAltToPath(categoriesDocUri, MediaTypeUtils.ATOM_CATEGORIES_DOCUMENT_TYPE);
            categories.setHref(categoriesDocUri);
        }
    }

    private static String getCategoriesDocBaseUri(Categories cats, ResourceRecord record) {
        String categoriesDocBaseUri = null;
        MultivaluedMap<String, String> templateParams = cats.getTemplateParameters();
        UriTemplateProcessor template = record.getTemplateProcessor();
        categoriesDocBaseUri = template.expand(templateParams);
        return categoriesDocBaseUri;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectionComparator
    implements Comparator<ServiceDocumentCollectionData> {
        private CollectionComparator() {
        }

        @Override
        public int compare(ServiceDocumentCollectionData o1, ServiceDocumentCollectionData o2) {
            int workspaceCompare = o1.getWorkspace().compareTo(o2.getWorkspace());
            if (workspaceCompare != 0) {
                return workspaceCompare;
            }
            String title1 = o1.getTitle();
            String title2 = o2.getTitle();
            if (title1 == null && title2 == null) {
                return 0;
            }
            if (title1 == null) {
                return 1;
            }
            if (title2 == null) {
                return -1;
            }
            return title1.compareTo(title2);
        }
    }
}

