/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.resources;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.internal.resources.RootResource;
import org.apache.wink.server.internal.resources.ServiceDocumentCollectionData;

@Path(value="/")
public class HtmlServiceDocumentResource
extends RootResource {
    private static final String APP_SERVICE_DOCUMENT_TYPE = MediaTypeUtils.toEncodedString(MediaTypeUtils.ATOM_SERVICE_DOCUMENT_TYPE);
    private static final String TEXT_CSS = "text/css";
    private String serviceDocumentCssPath;
    private static final String START_HTML = "<html>";
    private static final String END_HTML = "</html>";
    private static final String START_HEAD = "<head>";
    private static final String CSS = "<style type=\"text/css\" media=\"all\">  h1 {  padding: 4px 4px 4px 24px;  color: #333333;  background-color: #C8C8C8;  font-weight: bold;  font-size: 24px;} h2 {  padding: 4px 4px 4px 24px;  color: #F8F8F8;  background-color: #686868;  font-weight: bold;  font-size: 16px;}    </style>";
    private static final String END_HEAD = "</head>";
    private static final String START_TITLE = "<title>";
    private static final String END_TITLE = "</title>";
    private static final String START_LINK = "<link rel=";
    private static final String END_TAG = "/>";
    private static final String CLOSE_TAG = ">";
    private static final String START_BODY = "<body>";
    private static final String END_BODY = "</body>";
    private static final String START_HEAD_1 = "<h1>";
    private static final String END_HEAD_1 = "</h1>";
    private static final String START_PARAGRAPH = "<p>";
    private static final String END_PARAGRAPH = "</p>";
    private static final String START_A_HREF = "<a ";
    private static final String END_A_HREF = "</a>";
    private static final String START_HEAD_2 = "<h2>";
    private static final String END_HEAD_2 = "</h2>";
    private static final String START_TABLE = "<table>";
    private static final String END_TABLE = "</table>";
    private static final String START_T_BODY = "<tbody>";
    private static final String END_T_BODY = "</tbody>";
    private static final String START_TR = "<tr>";
    private static final String END_TR = "</tr>";
    private static final String START_TD = "<td>";
    private static final String END_TD = "</td>";
    private static final String TYPE = "type=";
    private static final String HREF = "href=";
    private static final String TITLE = "title=";
    private static final String SPACE = " ";
    private static final String APOSTROPHE = "\"";
    private static final String CSS_REL = "stylesheet";
    private static final String OPEN_SEARCH_REL = "search";

    public void setServiceDocumentCssPath(String serviceDocumentCssPath) {
        this.serviceDocumentCssPath = serviceDocumentCssPath;
    }

    public String getServiceDocumentCssPath() {
        return this.serviceDocumentCssPath;
    }

    @GET
    @Produces(value={"text/html"})
    public String getServiceDocumentHtml(@Context UriInfo uriInfo) {
        String baseUri = uriInfo.getBaseUri().toString();
        String titleValue = "Service Document";
        StringBuilder htmlDocStrBldr = new StringBuilder(START_HTML);
        htmlDocStrBldr.append(START_HEAD).append(START_TITLE).append("Service Document").append(END_TITLE);
        this.addCssLink(htmlDocStrBldr);
        this.addOpenSearchLinks(htmlDocStrBldr, baseUri);
        htmlDocStrBldr.append(END_HEAD);
        htmlDocStrBldr.append(START_BODY).append(START_HEAD_1).append("Service Document").append(END_HEAD_1);
        String linkToAdd = uriInfo.getAbsolutePathBuilder().queryParam("alt", new Object[]{APP_SERVICE_DOCUMENT_TYPE}).build(new Object[0]).toString();
        htmlDocStrBldr.append(START_PARAGRAPH).append(START_A_HREF).append(HREF).append(APOSTROPHE).append(linkToAdd).append(APOSTROPHE).append(CLOSE_TAG).append("View Service Document in XML format").append(END_A_HREF).append(END_PARAGRAPH);
        LinkedHashMap<String, ArrayList<ServiceDocumentCollectionData>> workspaces = new LinkedHashMap<String, ArrayList<ServiceDocumentCollectionData>>();
        List<ServiceDocumentCollectionData> serviceDocumentCollectionList = this.getCollections(uriInfo);
        for (ServiceDocumentCollectionData serviceDocumentCollectionData : serviceDocumentCollectionList) {
            ArrayList<ServiceDocumentCollectionData> serviceDocumentCollections = (ArrayList<ServiceDocumentCollectionData>)workspaces.get(serviceDocumentCollectionData.getWorkspace());
            if (serviceDocumentCollections == null) {
                serviceDocumentCollections = new ArrayList<ServiceDocumentCollectionData>(1);
                workspaces.put(serviceDocumentCollectionData.getWorkspace(), serviceDocumentCollections);
            }
            serviceDocumentCollections.add(serviceDocumentCollectionData);
        }
        for (Map.Entry entry : workspaces.entrySet()) {
            String workspaceTitleValue = (String)entry.getKey();
            List collections = (List)entry.getValue();
            if (collections == null) continue;
            htmlDocStrBldr.append(START_HEAD_2).append(workspaceTitleValue).append(END_HEAD_2);
            htmlDocStrBldr.append(START_TABLE).append(START_T_BODY);
            for (ServiceDocumentCollectionData collection : collections) {
                String collectionName = collection.getTitle();
                String template = collection.getUri();
                String colUri = UriHelper.appendPathToBaseUri(baseUri, template);
                if (collection.getProduces() != null && collection.getProduces().contains(MediaType.TEXT_HTML_TYPE)) {
                    colUri = UriHelper.appendAltToPath(colUri, MediaType.TEXT_HTML_TYPE);
                }
                boolean isParameterOnUri = this.collectionHasTemplateHref(template);
                htmlDocStrBldr.append(START_TR).append(START_TD).append(collectionName).append(":").append(END_TD);
                htmlDocStrBldr.append(START_TD);
                if (!isParameterOnUri) {
                    htmlDocStrBldr.append("&nbsp;&nbsp;").append(START_A_HREF).append(HREF).append(APOSTROPHE).append(colUri).append(APOSTROPHE).append(CLOSE_TAG).append(UriEncoder.decodeString(colUri)).append(END_A_HREF);
                } else {
                    htmlDocStrBldr.append("&nbsp;&nbsp;").append(UriEncoder.decodeString(colUri));
                }
                htmlDocStrBldr.append(END_TD).append(END_TR);
            }
            htmlDocStrBldr.append(END_T_BODY).append(END_TABLE);
        }
        htmlDocStrBldr.append(END_BODY).append(END_HTML);
        return htmlDocStrBldr.toString();
    }

    private boolean collectionHasTemplateHref(String collectionUri) {
        return collectionUri.indexOf(123) > 0;
    }

    private void addCssLink(StringBuilder htmlDocStrBldr) {
        if (this.serviceDocumentCssPath != null && !this.serviceDocumentCssPath.equals("")) {
            htmlDocStrBldr.append(START_LINK).append(APOSTROPHE).append(CSS_REL).append(APOSTROPHE).append(SPACE).append(TYPE).append(APOSTROPHE).append(TEXT_CSS).append(APOSTROPHE).append(SPACE).append(HREF).append(APOSTROPHE).append(this.serviceDocumentCssPath).append(APOSTROPHE).append(END_TAG);
        } else {
            htmlDocStrBldr.append(CSS);
        }
    }

    private void addOpenSearchLinks(StringBuilder htmlDocStrBldr, String baseUri) {
        ResourceRegistry registry = RuntimeContextTLS.getRuntimeContext().getAttribute(ResourceRegistry.class);
        for (ResourceRecord record : registry.getRecords()) {
            if (!this.providesOpenSearch(record) || this.collectionHasTemplateHref(record.getTemplateProcessor().getTemplate())) continue;
            htmlDocStrBldr.append(START_LINK).append(APOSTROPHE).append(OPEN_SEARCH_REL).append(APOSTROPHE).append(SPACE).append(TYPE).append(APOSTROPHE).append("application/opensearchdescription+xml").append(APOSTROPHE);
            String template = record.getTemplateProcessor().getTemplate();
            htmlDocStrBldr.append(SPACE).append(HREF).append(APOSTROPHE).append(UriHelper.appendAltToPath(UriHelper.appendPathToBaseUri(baseUri, template), MediaTypeUtils.OPENSEARCH_TYPE)).append(APOSTROPHE);
            htmlDocStrBldr.append(SPACE).append(TITLE).append(APOSTROPHE).append(record.getMetadata().getCollectionTitle()).append(SPACE).append("Search").append(APOSTROPHE).append(END_TAG);
        }
    }

    private boolean providesOpenSearch(ResourceRecord record) {
        for (MethodMetadata method : record.getMetadata().getResourceMethods()) {
            if (!this.providesOpenSearch(method)) continue;
            return true;
        }
        for (MethodMetadata method : record.getMetadata().getSubResourceMethods()) {
            if (!this.providesOpenSearch(method)) continue;
            return true;
        }
        return false;
    }

    private boolean providesOpenSearch(MethodMetadata method) {
        return method.getHttpMethod().equals("GET") && ((Object)method.getProduces()).equals(MediaTypeUtils.OPENSEARCH_TYPE);
    }
}

