/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.providers.entity.html;

import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.wink.common.model.synd.SyndCategory;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndFeed;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.common.model.synd.SyndPerson;
import org.apache.wink.common.model.synd.SyndText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSyndFeedAdapter {
    private final SyndFeed syndFeed;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public HtmlSyndFeedAdapter(SyndFeed syndFeed) {
        this.syndFeed = syndFeed;
    }

    public String getId() {
        String id = this.syndFeed.getId();
        if (id != null) {
            return id;
        }
        return "";
    }

    public String getUpdated() {
        if (this.syndFeed.getUpdated() != null) {
            return this.simpleDateFormat.format(this.syndFeed.getUpdated());
        }
        return "";
    }

    public String getTitle() {
        SyndText textBean = this.syndFeed.getTitle();
        if (textBean != null) {
            return textBean.getValue();
        }
        return "";
    }

    public List<SyndLink> getLinks() {
        return this.syndFeed.getLinks();
    }

    public List<SyndCategory> getCategories() {
        return this.syndFeed.getCategories();
    }

    public String getAuthor() {
        String name;
        List<SyndPerson> authors = this.syndFeed.getAuthors();
        if (!authors.isEmpty() && (name = authors.get(0).getName()) != null) {
            return name;
        }
        return "";
    }

    public String getSubTitle() {
        SyndText textBean = this.syndFeed.getSubtitle();
        if (textBean != null) {
            return textBean.getValue();
        }
        return "";
    }

    public SyndEntry getSyndEntry(int i) {
        List<SyndEntry> entries = this.syndFeed.getEntries();
        if (i >= 0 && i < entries.size()) {
            return entries.get(i);
        }
        return null;
    }

    public int getNumOfEntries() {
        return this.syndFeed.getEntries().size();
    }
}

