/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.log;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.log.LogUtilities;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceInvocation
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResourceInvocation.class);

    public void init(Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        logger.trace("handleRequest({}, {}) entry", (Object)context, (Object)chain);
        try {
            if (logger.isDebugEnabled()) {
                this.logStartRequest(context);
            }
            chain.doChain(context);
        }
        finally {
            if (logger.isDebugEnabled()) {
                this.logFinishRequest(context);
            }
        }
        logger.trace("handleRequest({}, {}) exit", (Object)context, (Object)chain);
    }

    private void logStartRequest(MessageContext context) {
        context.setAttribute(ResourceInvocationData.class, new ResourceInvocationData());
    }

    public void logFinishRequest(MessageContext context) {
        try {
            ResourceInvocationData data = context.getAttribute(ResourceInvocationData.class);
            if (data == null) {
                return;
            }
            List<ResourceRecord> resClassData = data.getResourceMetadata();
            List<MethodMetadata> resMethodData = data.getMethodMetadata();
            StringBuffer sb = new StringBuffer();
            Formatter f = new Formatter(sb);
            int size = resMethodData.size();
            for (int i = 0; i < size; ++i) {
                f.format("%n-> %1$s.%2$s", resClassData.get(i).getMetadata().getResourceClass().getName(), this.prettyMethodPrint(resMethodData.get(i).getReflectionMethod()));
                if (!logger.isTraceEnabled()) continue;
                LogUtilities.logResourceMetadata(Collections.singletonList(resClassData.get(i)), logger, true, true);
            }
            SearchResult result = context.getAttribute(SearchResult.class);
            if (result.isError()) {
                ResourceInstance instance = result.getResource();
                if (instance != null) {
                    f.format("%n-> %1$s.(No matching method)", instance.getResourceClass().getName());
                    if (logger.isTraceEnabled()) {
                        LogUtilities.logResourceMetadata(Collections.singletonList(result.getResource().getRecord()), logger, true, true);
                    }
                } else {
                    f.format("No resource instance was invoked.", new Object[0]);
                }
            }
            logger.debug("Resource invocation:{}", (Object)sb);
        }
        catch (Exception e) {
            logger.trace("Encountered exception while calling logFinishRequest", (Throwable)e);
        }
    }

    private String prettyMethodPrint(Method javaMethod) {
        if (javaMethod == null) {
            return "";
        }
        StringBuffer methodName = new StringBuffer();
        methodName.append(javaMethod.getName());
        boolean isFirst = true;
        methodName.append("(");
        for (Class<?> paramTypes : javaMethod.getParameterTypes()) {
            if (!isFirst) {
                methodName.append(",");
            } else {
                isFirst = false;
            }
            methodName.append(paramTypes.getSimpleName());
        }
        methodName.append(")");
        return methodName.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceInvocationData {
        private List<ResourceRecord> resourceMetadata = new ArrayList<ResourceRecord>();
        private List<MethodMetadata> methodMeta = new ArrayList<MethodMetadata>();

        public List<ResourceRecord> getResourceMetadata() {
            return this.resourceMetadata;
        }

        public List<MethodMetadata> getMethodMetadata() {
            return this.methodMeta;
        }

        public void addInvocation(MessageContext context) {
            try {
                ResourceInvocationData data = context.getAttribute(ResourceInvocationData.class);
                if (data == null) {
                    return;
                }
                SearchResult result = context.getAttribute(SearchResult.class);
                data.getResourceMetadata().add(result.getResource().getRecord());
                if (result.isFound()) {
                    data.getMethodMetadata().add(result.getMethod().getMetadata());
                }
            }
            catch (Exception e) {
                logger.trace("Encountered exception while calling addInvocation", (Throwable)e);
            }
        }
    }
}

