/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.log;

import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.SubResourceRecord;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogUtilities {
    static final int BREAK_POINT = 20;

    private LogUtilities() {
    }

    static String constructMethodString(Method javaMethod) {
        if (javaMethod == null) {
            return "";
        }
        StringBuffer methodName = new StringBuffer();
        methodName.append(javaMethod.getName());
        boolean isFirst = true;
        methodName.append("(");
        for (Class<?> paramTypes : javaMethod.getParameterTypes()) {
            if (!isFirst) {
                methodName.append(",");
            } else {
                isFirst = false;
            }
            methodName.append(paramTypes.getSimpleName());
        }
        methodName.append(")");
        return methodName.toString();
    }

    static String constructMediaTypeString(Set<MediaType> mtSet) {
        if (mtSet == null || mtSet.isEmpty()) {
            return "[*/*]";
        }
        return mtSet.toString();
    }

    public static void logResourceMetadata(List<ResourceRecord> resourceRecords, Logger logger, boolean isTrace, boolean isLogForOneResource) {
        StringBuffer sb = new StringBuffer();
        Formatter f = new Formatter(sb);
        f.format("%n%1$-80s %2$-13s %3$-20s %4$-20s %5$s", "Path", "HTTP Method", "Consumes", "Produces", "Resource Method");
        int counter = 0;
        for (ResourceRecord record : resourceRecords) {
            try {
                String resourceClassName = record.getMetadata().getResourceClass().getName();
                ClassMetadata resourceMetadata = record.getMetadata();
                String resourcePath = resourceMetadata.getPath();
                for (MethodMetadata methodMetadata : resourceMetadata.getResourceMethods()) {
                    ++counter;
                    try {
                        String path = resourcePath;
                        String httpMethod = methodMetadata.getHttpMethod();
                        String consumes = LogUtilities.constructMediaTypeString(methodMetadata.getConsumes());
                        String produces = LogUtilities.constructMediaTypeString(methodMetadata.getProduces());
                        String methodName = LogUtilities.constructMethodString(methodMetadata.getReflectionMethod());
                        f.format("%n%1$-80s %2$-13s %3$-20s %4$-20s %5$s.%6$s", path, httpMethod, consumes, produces, resourceClassName, methodName);
                    }
                    catch (Exception e) {
                        logger.trace("Could not print the entire method metadata for {}", (Object)resourceClassName, (Object)e);
                    }
                    if (counter % 20 != 0) continue;
                    if (isTrace) {
                        if (isLogForOneResource) {
                            logger.trace("Resource information for {}:{}", (Object)resourceMetadata.getResourceClass().getName(), (Object)sb);
                        } else {
                            logger.trace(Messages.getMessage("registeredResources", sb));
                        }
                    } else if (isLogForOneResource) {
                        logger.debug("Resource information for {}:{}", (Object)resourceMetadata.getResourceClass().getName(), (Object)sb);
                    } else {
                        logger.debug(Messages.getMessage("registeredResources", sb));
                    }
                    sb = new StringBuffer();
                    f = new Formatter(sb);
                    f.format("%n%1$-80s %2$-13s %3$-20s %4$-20s %5$s", "Path", "HTTP Method", "Consumes", "Produces", "Resource Method");
                }
                for (SubResourceRecord subResourceRecord : record.getSubResourceRecords()) {
                    ++counter;
                    try {
                        MethodMetadata method = subResourceRecord.getMetadata();
                        StringBuilder path = new StringBuilder(resourcePath);
                        if (!resourcePath.endsWith("/")) {
                            path.append("/");
                        }
                        path.append(method.getPath());
                        String httpMethod = method.getHttpMethod();
                        if (httpMethod == null) {
                            httpMethod = "(Sub-Locator)";
                        }
                        String consumes = LogUtilities.constructMediaTypeString(method.getConsumes());
                        String produces = LogUtilities.constructMediaTypeString(method.getProduces());
                        String methodName = LogUtilities.constructMethodString(method.getReflectionMethod());
                        f.format("%n%1$-80s %2$-13s %3$-20s %4$-20s %5$s.%6$s", path, httpMethod, consumes, produces, resourceClassName, methodName);
                    }
                    catch (Exception e) {
                        logger.trace("Could not print the entire method metadata for {}", (Object)resourceClassName, (Object)e);
                    }
                    if (counter % 20 != 0) continue;
                    if (isTrace) {
                        if (isLogForOneResource) {
                            logger.trace("Resource information for {}:{}", (Object)resourceMetadata.getResourceClass().getName(), (Object)sb);
                        } else {
                            logger.trace(Messages.getMessage("registeredResources", sb));
                        }
                    } else if (isLogForOneResource) {
                        logger.debug("Resource information for {}:{}", (Object)resourceMetadata.getResourceClass().getName(), (Object)sb);
                    } else {
                        logger.debug(Messages.getMessage("registeredResources", sb));
                    }
                    sb = new StringBuffer();
                    f = new Formatter(sb);
                    f.format("%n%1$-80s %2$-13s %3$-20s %4$-20s %5$s", "Path", "HTTP Method", "Consumes", "Produces", "Resource Method");
                }
            }
            catch (Exception e) {
                logger.trace("Could not print the entire resource metadata", (Throwable)e);
            }
        }
        if (counter % 20 != 0) {
            if (isTrace) {
                if (isLogForOneResource) {
                    logger.trace("Resource information for {}:{}", (Object)resourceRecords.get(0).getMetadata().getResourceClass().getName(), (Object)sb);
                } else {
                    logger.trace(Messages.getMessage("registeredResources", sb));
                }
            } else if (isLogForOneResource) {
                logger.debug("Resource information for {}:{}", (Object)resourceRecords.get(0).getMetadata().getResourceClass().getName(), (Object)sb);
            } else {
                logger.debug(Messages.getMessage("registeredResources", sb));
            }
            sb = new StringBuffer();
            f = new Formatter(sb);
            f.format("%n%1$-80s %2$-13s %3$-20s %4$-20s %5$s", "Path", "HTTP Method", "Consumes", "Produces", "Resource Method");
        }
    }
}

