/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.log;

import java.util.Formatter;
import java.util.Map;
import org.apache.wink.server.internal.lifecycle.metadata.EJBBeanMetadata;
import org.apache.wink.server.internal.lifecycle.metadata.EJBMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EJBs {
    private static final Logger logger = LoggerFactory.getLogger(EJBs.class);
    private EJBMetadata ejbMetadata;

    public EJBs(EJBMetadata ejbMetadata) {
        this.ejbMetadata = ejbMetadata;
    }

    public void log() {
        try {
            if (logger.isDebugEnabled()) {
                if (this.ejbMetadata == null) {
                    logger.debug("No EJB metadata was available.");
                    return;
                }
                Map<String, EJBBeanMetadata> beanMetadata = this.ejbMetadata.getEjbMetadata();
                if (beanMetadata == null || beanMetadata.size() == 0) {
                    logger.debug("No EJB metadata was available.");
                    return;
                }
                StringBuffer sb = new StringBuffer();
                Formatter f = new Formatter(sb);
                f.format("%n%1$-80s %2$-80s", "EJB Interface View/Class", "EJB Bean Name");
                EJBBeanMetadata metadata = null;
                for (String ejbInterface : beanMetadata.keySet()) {
                    metadata = beanMetadata.get(ejbInterface);
                    String interfaceView = metadata.getLocalBusinessInterface() != null ? metadata.getLocalBusinessInterface() : ejbInterface;
                    f.format("%n%1$-100s %2$-50s", interfaceView, metadata.getBeanName());
                }
                logger.debug(sb.toString());
            }
        }
        catch (Exception e) {
            logger.trace("An error occurred logging the EJB metadata information. {}", (Throwable)e);
        }
    }
}

