/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.internal.WinkConfiguration;
import org.apache.wink.common.internal.contexts.MediaTypeCharsetAdjuster;
import org.apache.wink.common.internal.contexts.ProvidersImpl;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.runtime.AbstractRuntimeContext;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.MediaTypeMapper;
import org.apache.wink.server.internal.contexts.HttpHeadersImpl;
import org.apache.wink.server.internal.contexts.RequestImpl;
import org.apache.wink.server.internal.contexts.SecurityContextImpl;
import org.apache.wink.server.internal.contexts.ServerMediaTypeCharsetAdjuster;
import org.apache.wink.server.internal.contexts.UriInfoImpl;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.internal.utils.LinkBuildersImpl;
import org.apache.wink.server.utils.LinkBuilders;

public class ServerMessageContext
extends AbstractRuntimeContext
implements MessageContext {
    private int responseStatusCode;
    private Object responseEntity;
    private MediaType responseMediaType;
    private String httpMethod;

    public ServerMessageContext(HttpServletRequest servletRequest, HttpServletResponse servletResponse, DeploymentConfiguration configuration) {
        this.httpMethod = this.buildHttpMethod(configuration.getHttpMethodOverrideHeaders(), servletRequest);
        this.responseStatusCode = -1;
        this.setAttribute(HttpServletRequest.class, servletRequest);
        this.setAttribute(HttpServletRequestWrapper.class, new HttpServletRequestWrapper(servletRequest));
        WrappedResponse responseWrapper = new WrappedResponse(servletRequest, servletResponse, configuration.getMediaTypeMapper());
        this.setAttribute(HttpServletResponse.class, responseWrapper);
        this.setAttribute(HttpServletResponseWrapper.class, responseWrapper);
        this.setAttribute(ServletContext.class, configuration.getServletContext());
        this.setAttribute(ServletConfig.class, configuration.getServletConfig());
        this.setAttribute(FilterConfig.class, configuration.getFilterConfig());
        this.setAttribute(WinkConfiguration.class, configuration);
        this.setAttribute(DeploymentConfiguration.class, configuration);
        this.setAttribute(ResourceRegistry.class, configuration.getResourceRegistry());
        this.setAttribute(ProvidersRegistry.class, configuration.getProvidersRegistry());
        if (configuration.isDefaultResponseCharset() || configuration.isUseAcceptCharset()) {
            this.setAttribute(MediaTypeCharsetAdjuster.class, ServerMediaTypeCharsetAdjuster.getInstance());
        }
        this.initContexts();
        List<Application> apps = configuration.getApplications();
        if (apps != null && !apps.isEmpty()) {
            this.setAttribute(Application.class, apps.get(0));
        }
    }

    private void initContexts() {
        this.setAttribute(Providers.class, new ProvidersImpl(this.getDeploymentConfiguration().getProvidersRegistry(), this));
        this.setAttribute(HttpHeaders.class, new HttpHeadersImpl(this));
        UriInfoImpl uriInfoImpl = new UriInfoImpl(this);
        this.setAttribute(UriInfo.class, uriInfoImpl);
        this.setAttribute(UriInfoImpl.class, uriInfoImpl);
        this.setAttribute(SecurityContext.class, new SecurityContextImpl(this));
        this.setAttribute(Request.class, new RequestImpl(this));
        this.setAttribute(LinkBuilders.class, new LinkBuildersImpl(this));
    }

    private String buildHttpMethod(String[] httpMethodOverrideHeaders, HttpServletRequest servletRequest) {
        if (httpMethodOverrideHeaders != null) {
            for (String httpMethodOverrideHeader : httpMethodOverrideHeaders) {
                String xHttpMethodOverride = servletRequest.getHeader(httpMethodOverrideHeader.trim());
                if (xHttpMethodOverride == null) continue;
                return xHttpMethodOverride.trim();
            }
        }
        try {
            return servletRequest.getMethod();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Properties getProperties() {
        return this.getDeploymentConfiguration().getProperties();
    }

    public void setResponseStatusCode(int responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseEntity(Object entity) {
        this.responseEntity = entity;
    }

    public Object getResponseEntity() {
        return this.responseEntity;
    }

    public void setResponseMediaType(MediaType responseMediaType) {
        this.responseMediaType = responseMediaType;
    }

    public MediaType getResponseMediaType() {
        return this.responseMediaType;
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String toString() {
        return String.format("Method: %s, Path: %s, MediaType: %s", this.getHttpMethod(), this.getUriInfo().getPath(false), this.getHttpHeaders().getMediaType());
    }

    public LinkBuilders getLinkBuilders() {
        return this.getAttribute(LinkBuilders.class);
    }

    public InputStream getInputStream() throws IOException {
        return this.getAttribute(HttpServletRequest.class).getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getAttribute(HttpServletResponse.class).getOutputStream();
    }

    private DeploymentConfiguration getDeploymentConfiguration() {
        return (DeploymentConfiguration)this.getAttribute(WinkConfiguration.class);
    }

    private class WrappedResponse
    extends HttpServletResponseWrapper {
        private final HttpServletRequest servletRequest;
        private final MediaTypeMapper mediaTypeMapper;
        private String userContentType;

        WrappedResponse(HttpServletRequest servletRequest, HttpServletResponse servletResponse, MediaTypeMapper mediaTypeMapper) {
            super(servletResponse);
            this.userContentType = null;
            this.servletRequest = servletRequest;
            this.mediaTypeMapper = mediaTypeMapper;
        }

        public void setHeader(String name, String value) {
            if (name.equals("Content-Type")) {
                this.setContentType(value);
            } else {
                super.setHeader(name, value);
            }
        }

        public void addHeader(String name, String value) {
            if (name.equals("Content-Type")) {
                this.setContentType(value);
            } else {
                super.addHeader(name, value);
            }
        }

        public void setContentType(String type) {
            this.userContentType = type;
            if (this.mediaTypeMapper == null) {
                super.setContentType(type);
            } else {
                MediaType realResponseMimeType = this.getRealResponseMimeType(type);
                super.setContentType(realResponseMimeType.toString());
            }
        }

        public String getContentType() {
            if (this.userContentType != null) {
                return this.userContentType;
            }
            return super.getContentType();
        }

        private MediaType getRealResponseMimeType(String responseMimeType) {
            return this.mediaTypeMapper.mapOutputMediaType(MediaType.valueOf((String)responseMimeType), ServerMessageContext.this.getHttpHeaders());
        }
    }
}

