/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.abdera;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.writer.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/atom+xml", "application/json"})
@Consumes(value={"application/atom+xml"})
@Provider
public class AbderaAtomFeedProvider
implements MessageBodyWriter<Feed>,
MessageBodyReader<Feed> {
    private static final Abdera ATOM_ENGINE = new Abdera();

    public long getSize(Feed feed, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Feed.class.isAssignableFrom(type);
    }

    public void writeTo(Feed feed, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
            Writer w = ATOM_ENGINE.getWriterFactory().getWriter("json");
            feed.writeTo(w, entityStream);
        } else {
            feed.writeTo(entityStream);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Feed.class == type;
    }

    public Feed readFrom(Class<Feed> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        Document doc = ATOM_ENGINE.getParser().parse(entityStream);
        return (Feed)doc.getRoot();
    }
}

