/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.jcdi.server.internal.lifecycle;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.ObjectCreationException;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDISingletonObjectFactory<T>
implements ObjectFactory<T> {
    private final Logger logger = LoggerFactory.getLogger(JCDISingletonObjectFactory.class);
    private final T instance;
    private final CreationalContext<?> creationalContext;
    private boolean isReleased = false;

    public JCDISingletonObjectFactory(Class<T> clazz, BeanManager beanManager) {
        Annotation[] annotations = clazz.getAnnotations();
        ArrayList<Annotation> qualifierAnnotations = new ArrayList<Annotation>(1);
        for (Annotation a : annotations) {
            if (!beanManager.isQualifier(a.annotationType())) continue;
            qualifierAnnotations.add(a);
        }
        Set beans = beanManager.getBeans(clazz, qualifierAnnotations.toArray(new Annotation[0]));
        Bean theBean = (Bean)beans.iterator().next();
        this.creationalContext = beanManager.createCreationalContext((Contextual)theBean);
        try {
            this.instance = beanManager.getReference(theBean, clazz, this.creationalContext);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(Messages.getMessage("jcdiSingletonObjectFactoryCannotInstantiateInstance", clazz.getName()), (Throwable)e);
            }
            throw new ObjectCreationException(e);
        }
    }

    @Override
    public T getInstance(RuntimeContext context) {
        return this.instance;
    }

    @Override
    public Class<T> getInstanceClass() {
        return this.instance.getClass();
    }

    @Override
    public void releaseAll(RuntimeContext context) {
        if (this.isReleased) {
            return;
        }
        this.isReleased = true;
        if (this.creationalContext != null) {
            this.creationalContext.release();
        }
    }

    @Override
    public void releaseInstance(T instance, RuntimeContext context) {
    }
}

