/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.jcdi.server.internal.lifecycle;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.ObjectCreationException;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ApplicationMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.jcdi.server.internal.lifecycle.JCDIDefaultObjectFactory;
import org.apache.wink.jcdi.server.internal.lifecycle.JCDISingletonObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDILifecycleManager<T>
implements LifecycleManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(JCDILifecycleManager.class);
    private BeanManager beanManager = null;

    public JCDILifecycleManager() {
        logger.trace("JCDILifecycleManager created");
    }

    void setBeanManager(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public boolean setBeanManager(Object object) {
        boolean bmSet = false;
        if (object instanceof BeanManager) {
            this.beanManager = (BeanManager)object;
            bmSet = true;
        } else {
            logger.trace("Passed-in object is not a BeanManager instance, so will not set");
        }
        return bmSet;
    }

    BeanManager getBeanManager() {
        if (this.beanManager == null) {
            try {
                InitialContext initialContext = new InitialContext();
                this.beanManager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
            }
            catch (NamingException e) {
                logger.warn(Messages.getMessage("couldNotFindBeanManager"), (Throwable)e);
            }
        }
        return this.beanManager;
    }

    @Override
    public ObjectFactory<T> createObjectFactory(T object) throws ObjectCreationException {
        logger.trace("createObjectFactory({}) entry", object);
        if (object == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "object"));
        }
        logger.trace("createObjectFactory() exit returning null");
        return null;
    }

    @Override
    public ObjectFactory<T> createObjectFactory(Class<T> cls) throws ObjectCreationException {
        logger.trace("createObjectFactory({}) entry", cls);
        if (cls == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "cls"));
        }
        BeanManager beanManager = this.getBeanManager();
        if (JCDILifecycleManager.isJCDIManagedBean(cls, beanManager)) {
            if (ProviderMetadataCollector.isProvider(cls) || ApplicationMetadataCollector.isApplication(cls)) {
                logger.trace("createObjectFactory() returning JCDISingletonObjectFactory");
                return new JCDISingletonObjectFactory<T>(cls, beanManager);
            }
            logger.trace("createObjectFactory() returning JCDIDefaultObjectFactory");
            return new JCDIDefaultObjectFactory<T>(cls, beanManager);
        }
        logger.trace("createObjectFactory() returning null");
        return null;
    }

    static <T> boolean isJCDIManagedBean(Class<T> cls, BeanManager beanManager) {
        logger.trace("isJCDIManagedBean({}, {}) entry", cls, (Object)beanManager);
        Annotation[] annotations = cls.getAnnotations();
        ArrayList<Annotation> qualifierAnnotations = new ArrayList<Annotation>(1);
        for (Annotation a : annotations) {
            if (!beanManager.isQualifier(a.annotationType())) continue;
            qualifierAnnotations.add(a);
        }
        logger.trace("Qualifier annotations are {}", qualifierAnnotations);
        Set beans = beanManager.getBeans(cls, qualifierAnnotations.toArray(new Annotation[0]));
        logger.trace("Beans are {}", (Object)beans);
        if (beans == null || beans.isEmpty()) {
            logger.debug("{} is NOT a JCDI managed bean.", cls);
            logger.trace("isJCDIManagedBean() returning false");
            return false;
        }
        logger.debug("{} is a JCDI managed bean.", cls);
        logger.trace("isJCDIManagedBean() returning true");
        return true;
    }
}

