/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.jcdi.server.internal.lifecycle;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDIDefaultObjectFactory<T>
implements ObjectFactory<T> {
    private final Class<T> clazz;
    private final BeanManager beanManager;
    private Bean<?> theBean;
    private IdentityHashMap<T, CreationalContext<T>> creationalContextMap;

    public JCDIDefaultObjectFactory(Class<T> c, BeanManager beanManager) {
        this.clazz = c;
        this.beanManager = beanManager;
        this.theBean = null;
    }

    IdentityHashMap<T, CreationalContext<T>> getCreationalContextMap() {
        return this.creationalContextMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getInstance(RuntimeContext context) {
        if (this.theBean == null) {
            Annotation[] annotations = this.clazz.getAnnotations();
            ArrayList<Annotation> qualifierAnnotations = new ArrayList<Annotation>(1);
            for (Annotation a : annotations) {
                if (!this.beanManager.isQualifier(a.annotationType())) continue;
                qualifierAnnotations.add(a);
            }
            Set beans = this.beanManager.getBeans(this.clazz, qualifierAnnotations.toArray(new Annotation[0]));
            this.theBean = (Bean)beans.iterator().next();
        }
        CreationalContext creationalContext = this.beanManager.createCreationalContext(this.theBean);
        Object instance = this.beanManager.getReference(this.theBean, this.clazz, creationalContext);
        if (context != null) {
            context.setAttribute(CreationalContext.class, creationalContext);
        } else {
            JCDIDefaultObjectFactory jCDIDefaultObjectFactory = this;
            synchronized (jCDIDefaultObjectFactory) {
                if (this.creationalContextMap == null) {
                    this.creationalContextMap = new IdentityHashMap();
                }
                this.creationalContextMap.put(instance, creationalContext);
            }
        }
        return (T)instance;
    }

    @Override
    public Class<T> getInstanceClass() {
        return this.clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAll(RuntimeContext context) {
        JCDIDefaultObjectFactory jCDIDefaultObjectFactory = this;
        synchronized (jCDIDefaultObjectFactory) {
            if (this.creationalContextMap != null) {
                for (CreationalContext<T> c : this.creationalContextMap.values()) {
                    c.release();
                }
                this.creationalContextMap = null;
            }
        }
    }

    @Override
    public void releaseInstance(T instance, RuntimeContext context) {
        CreationalContext creationalContext;
        if (context != null && (creationalContext = (CreationalContext)context.getAttributes().remove(CreationalContext.class.getName())) != null) {
            creationalContext.release();
        }
    }
}

