/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.jcdi.server.internal.extension;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.apache.wink.common.internal.registry.metadata.ApplicationMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.jcdi.server.internal.extension.JAXRSJCDICustomInjectionTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDIExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(JCDIExtension.class);

    public <T> void observeProcessInjectionTarget(@Observes ProcessInjectionTarget<T> pij) {
        logger.trace("observeProcessInjectionTarget({}) entry", pij);
        if (JCDIExtension.isJAXRSBean(pij.getAnnotatedType().getJavaClass())) {
            logger.trace("Was JAX-RS annotated class so changing the injection target");
            pij.setInjectionTarget(new JAXRSJCDICustomInjectionTarget(pij.getInjectionTarget()));
        }
        logger.trace("observeProcessInjectionTarget() exit");
    }

    static boolean isJAXRSBean(Class<?> cls) {
        if (logger.isTraceEnabled()) {
            logger.trace("isJAXRSBean({}) entry", (Object)cls.getName());
        }
        boolean result = false;
        if (ProviderMetadataCollector.isProvider(cls)) {
            result = true;
        } else if (ResourceMetadataCollector.isResource(cls)) {
            result = true;
        } else if (ApplicationMetadataCollector.isApplication(cls)) {
            result = true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("isJAXRSBean({}) exit", (Object)result);
        }
        return result;
    }
}

