/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.jcdi.server.internal.extension;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.CreationUtils;
import org.apache.wink.common.internal.registry.metadata.ApplicationMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSJCDICustomInjectionTarget<T>
implements InjectionTarget<T> {
    private static final Logger logger = LoggerFactory.getLogger(JAXRSJCDICustomInjectionTarget.class);
    private ClassMetadata classMetadata;
    private final InjectionTarget<T> delegate;

    static <T> ClassMetadata collectClassMetadata(Class<T> cls) {
        ClassMetadata classMetadata = null;
        if (ProviderMetadataCollector.isProvider(cls)) {
            classMetadata = ProviderMetadataCollector.collectMetadata(cls);
        } else if (ResourceMetadataCollector.isResource(cls)) {
            classMetadata = ResourceMetadataCollector.collectMetadata(cls);
        } else if (ApplicationMetadataCollector.isApplication(cls)) {
            classMetadata = ApplicationMetadataCollector.collectMetadata(cls);
        }
        return classMetadata;
    }

    public JAXRSJCDICustomInjectionTarget(InjectionTarget<T> delegate) {
        logger.trace("constructor({}) entry", delegate);
        this.delegate = delegate;
        logger.trace("constructor() exit");
    }

    public void inject(final T instance, CreationalContext<T> creationalContext) {
        logger.trace("inject({}, {}) entry", instance, creationalContext);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws PrivilegedActionException {
                    if (JAXRSJCDICustomInjectionTarget.this.classMetadata == null) {
                        logger.trace("Collecting classMetadata for {}", (Object)this);
                        JAXRSJCDICustomInjectionTarget.this.classMetadata = JAXRSJCDICustomInjectionTarget.collectClassMetadata(instance.getClass());
                    }
                    logger.trace("Calling CreationUtils.injectFields for instance");
                    try {
                        CreationUtils.injectFields(instance, JAXRSJCDICustomInjectionTarget.this.classMetadata, RuntimeContextTLS.getRuntimeContext());
                    }
                    catch (IOException e) {
                        throw new PrivilegedActionException(e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.warn(Messages.getMessage("exceptionDuringInjection"), (Throwable)e);
        }
        logger.trace("calling delegate.inject(instance, creationalContext)");
        this.delegate.inject(instance, creationalContext);
        logger.trace("inject() exit");
    }

    public void postConstruct(T instance) {
        this.delegate.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.delegate.preDestroy(instance);
    }

    public void dispose(T instance) {
        this.delegate.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegate.getInjectionPoints();
    }

    public T produce(CreationalContext<T> creationalContext) {
        return (T)this.delegate.produce(creationalContext);
    }
}

