/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.wadl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.apache.wink.common.model.wadl.Application;
import org.apache.wink.common.model.wadl.Doc;
import org.apache.wink.common.model.wadl.Link;
import org.apache.wink.common.model.wadl.Method;
import org.apache.wink.common.model.wadl.Option;
import org.apache.wink.common.model.wadl.Param;
import org.apache.wink.common.model.wadl.ParamStyle;
import org.apache.wink.common.model.wadl.Representation;
import org.apache.wink.common.model.wadl.Request;
import org.apache.wink.common.model.wadl.Resource;
import org.apache.wink.common.model.wadl.ResourceType;
import org.apache.wink.common.model.wadl.Resources;
import org.apache.wink.common.model.wadl.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WADLBuilder {
    private Application application = new Application();
    private Stack<Resource> parentResources = new Stack();
    private Resources resources;
    private Resource resource;
    private ResourceType resourceType;
    private Method method;
    private Request request;
    private Response response;
    private Representation representation;
    private Param param;
    private Option paramOption;
    private Link paramLink;

    public WADLBuilder newBuilder() {
        WADLBuilder builder = new WADLBuilder();
        return builder;
    }

    private WADLBuilder() {
    }

    public Application build() {
        return this.application;
    }

    public WADLBuilder doc(String lang, String title, List<Object> docContent) {
        Doc doc = new Doc();
        doc.setLang(lang);
        doc.setTitle(title);
        if (docContent != null) {
            doc.getContent().addAll(docContent);
        }
        if (this.paramLink != null) {
            this.paramLink.getDoc().add(doc);
        } else if (this.paramOption != null) {
            this.paramOption.getDoc().add(doc);
        } else if (this.param != null) {
            this.param.getDoc().add(doc);
        } else if (this.representation != null) {
            this.representation.getDoc().add(doc);
        } else if (this.response != null) {
            this.response.getDoc().add(doc);
        } else if (this.request != null) {
            this.request.getDoc().add(doc);
        } else if (this.method != null) {
            this.method.getDoc().add(doc);
        } else if (this.resourceType != null) {
            this.resourceType.getDoc().add(doc);
        } else if (this.resource != null) {
            this.resource.getDoc().add(doc);
        } else if (this.resources != null) {
            this.resources.getDoc().add(doc);
        } else if (this.application != null) {
            this.application.getDoc().add(doc);
        }
        return this;
    }

    public WADLBuilder resources(String baseURI) {
        this.resources = new Resources();
        this.resources.setBase(baseURI);
        this.application.getResources().add(this.resources);
        this.resource = null;
        this.method = null;
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder rootResource(String id, String path, List<String> type, String queryType) {
        if (this.resources == null) {
            throw new IllegalStateException();
        }
        this.resource = new Resource();
        this.resource.setId(id);
        this.resource.setPath(path);
        this.resource.setQueryType(queryType);
        if (type != null) {
            this.resource.getType().addAll(type);
        }
        this.resources.getResource().add(this.resource);
        this.parentResources.clear();
        this.resourceType = null;
        this.method = null;
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder resource(String id, String path, List<String> type, String queryType) {
        if (this.resources == null) {
            throw new IllegalStateException();
        }
        this.resource = new Resource();
        this.resource.setId(id);
        this.resource.setPath(path);
        this.resource.setQueryType(queryType);
        if (type != null) {
            this.resource.getType().addAll(type);
        }
        Resource parent = null;
        if (!this.parentResources.isEmpty()) {
            parent = this.parentResources.peek();
        }
        if (parent == null) {
            this.resources.getResource().add(this.resource);
        } else {
            parent.getMethodOrResource().add(this.resource);
        }
        this.resourceType = null;
        this.method = null;
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder resourceType(String id) {
        if (this.resources == null) {
            throw new IllegalStateException();
        }
        this.resourceType = new ResourceType();
        this.resourceType.setId(id);
        this.application.getResourceTypeOrMethodOrRepresentation().add(this.resourceType);
        this.resource = null;
        this.method = null;
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder subResourceBegin(String id, String path, List<String> type, String queryType) {
        if (this.resource == null) {
            throw new IllegalStateException();
        }
        this.parentResources.push(this.resource);
        this.resource = new Resource();
        this.resource.setId(id);
        this.resource.setPath(path);
        this.resource.setQueryType(queryType);
        if (type != null) {
            this.resource.getType().addAll(type);
        }
        Resource parent = null;
        if (!this.parentResources.isEmpty()) {
            parent = this.parentResources.peek();
        }
        if (parent == null) {
            if (this.resourceType != null) {
                this.resourceType.getMethodOrResource().add(this.resource);
            } else if (this.resources != null) {
                this.resources.getResource().add(this.resource);
            }
        } else {
            parent.getMethodOrResource().add(this.resource);
        }
        this.method = null;
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder subResourceEnd() {
        this.resource = !this.parentResources.isEmpty() ? this.parentResources.pop() : null;
        this.method = null;
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder paramReference(String href) {
        this.param = new Param();
        this.param.setHref(href);
        if (this.representation != null) {
            this.representation.getParam().add(this.param);
        } else if (this.response != null) {
            this.response.getParam().add(this.param);
        } else if (this.request != null) {
            this.request.getParam().add(this.param);
        } else if (this.resourceType != null) {
            this.resourceType.getParam().add(this.param);
        } else if (this.resource != null) {
            this.resource.getParam().add(this.param);
        }
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder param(String id, String name, ParamStyle style, QName type, String defaultValue, String path, boolean isRequired, boolean isRepeated, String fixedValue) {
        this.param = new Param();
        this.param.setId(id);
        this.param.setName(name);
        this.param.setStyle(style);
        this.param.setType(type);
        this.param.setDefault(defaultValue);
        this.param.setPath(path);
        this.param.setRequired(isRequired);
        this.param.setRepeating(isRepeated);
        this.param.setFixed(fixedValue);
        if (this.representation != null) {
            this.representation.getParam().add(this.param);
        } else if (this.response != null) {
            this.response.getParam().add(this.param);
        } else if (this.request != null) {
            this.request.getParam().add(this.param);
        } else if (this.resourceType != null) {
            this.resourceType.getParam().add(this.param);
        } else if (this.resource != null) {
            this.resource.getParam().add(this.param);
        }
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder paramOption(String value, String mediaType) {
        if (this.param == null) {
            throw new IllegalStateException();
        }
        this.paramOption = new Option();
        this.paramOption.setValue(value);
        this.paramOption.setMediaType(mediaType);
        this.param.getOption().add(this.paramOption);
        this.paramLink = null;
        return this;
    }

    public WADLBuilder paramLink(String resourceType, String rel, String rev) {
        if (this.param == null) {
            throw new IllegalStateException();
        }
        this.paramLink = new Link();
        this.paramLink.setResourceType(resourceType);
        this.paramLink.setRel(rel);
        this.paramLink.setRev(rev);
        this.param.setLink(this.paramLink);
        this.paramOption = null;
        return this;
    }

    public WADLBuilder methodReference(String href) {
        this.method = new Method();
        this.method.setHref(href);
        if (this.resourceType != null) {
            this.resourceType.getMethodOrResource().add(this.method);
        } else if (this.resource != null) {
            this.resource.getMethodOrResource().add(this.method);
        }
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder method(String name, String id) {
        this.method = new Method();
        this.method.setName(name);
        this.method.setId(id);
        if (this.resourceType != null) {
            this.resourceType.getMethodOrResource().add(this.method);
        } else if (this.resource != null) {
            this.resource.getMethodOrResource().add(this.method);
        }
        this.request = null;
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder request() {
        if (this.method == null) {
            throw new IllegalStateException();
        }
        this.request = new Request();
        this.method.setRequest(this.request);
        this.response = null;
        this.representation = null;
        this.param = null;
        this.paramOption = null;
        this.paramLink = null;
        return this;
    }

    public WADLBuilder representationReference(String href) {
        this.representation = new Representation();
        this.representation.setHref(href);
        if (this.request != null) {
            this.request.getRepresentation().add(this.representation);
        } else if (this.response != null) {
            this.response.getRepresentation().add(this.representation);
        } else if (this.application != null) {
            this.application.getResourceTypeOrMethodOrRepresentation().add(this.representation);
            this.method = null;
        }
        this.param = null;
        this.paramLink = null;
        this.paramOption = null;
        return this;
    }

    public WADLBuilder representation(String id, String mediaType, QName element, List<String> profile) {
        this.representation = new Representation();
        this.representation.setId(id);
        this.representation.setMediaType(mediaType);
        this.representation.setElement(element);
        if (profile != null) {
            this.representation.getProfile().addAll(profile);
        }
        if (this.request != null) {
            this.request.getRepresentation().add(this.representation);
        } else if (this.response != null) {
            this.response.getRepresentation().add(this.representation);
        } else if (this.application != null) {
            this.application.getResourceTypeOrMethodOrRepresentation().add(this.representation);
            this.method = null;
        }
        this.param = null;
        this.paramLink = null;
        this.paramOption = null;
        return this;
    }

    public WADLBuilder response(List<Long> statusCode) {
        this.response = new Response();
        if (statusCode != null) {
            this.response.getStatus().addAll(statusCode);
        }
        this.method.getResponse().add(this.response);
        this.request = null;
        this.representation = null;
        this.param = null;
        this.paramLink = null;
        this.paramOption = null;
        return this;
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE, ElementType.PARAMETER, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Documentation {
        public String lang();

        public String title();

        public String content();
    }

    public class DocConverter
    implements DocumentationConverter {
        public Doc toDoc(Type t) {
            if (t instanceof Class) {
                Class cls = (Class)t;
                Documentation doc = cls.getAnnotation(Documentation.class);
                Doc d = new Doc();
                d.setTitle(doc.title());
                d.setLang(doc.lang());
                d.getContent().add(doc.content());
                return d;
            }
            return null;
        }

        public Doc toDoc(Member m) {
            return null;
        }
    }

    public static interface DocumentationConverter {
        public Doc toDoc(Type var1);

        public Doc toDoc(Member var1);
    }
}

