/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.lang.ref.SoftReference;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.wink.common.internal.utils.SimpleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftConcurrentMap<K, V>
implements SimpleMap<K, V> {
    private volatile Map<K, SoftReference<V>> map = new WeakHashMap<K, SoftReference<V>>();

    @Override
    public V get(K key) {
        SoftReference<V> softReference = this.map.get(key);
        return softReference != null ? (V)softReference.get() : null;
    }

    @Override
    public synchronized V put(K key, V val) {
        WeakHashMap<K, SoftReference<V>> copyOfMap = new WeakHashMap<K, SoftReference<V>>();
        boolean complete = false;
        while (!complete) {
            try {
                copyOfMap = new WeakHashMap<K, SoftReference<V>>(this.map);
                complete = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        copyOfMap.put(key, new SoftReference<V>(val));
        this.map = copyOfMap;
        return val;
    }

    @Override
    public synchronized void clear() {
        this.map = new WeakHashMap<K, SoftReference<V>>();
    }
}

