/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.BoundInjectable;
import org.apache.wink.common.internal.registry.ContextAccessor;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.utils.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectableFactory {
    private static InjectableFactory instance = new InjectableFactory();

    public static InjectableFactory getInstance() {
        return instance;
    }

    public static void setInstance(InjectableFactory instance) {
        InjectableFactory.instance = instance;
    }

    public Object[] instantiate(List<Injectable> formalParameters, RuntimeContext runtimeContext) throws IOException {
        Object[] result = new Object[formalParameters.size()];
        for (int pos = 0; pos < result.length; ++pos) {
            Injectable fp = formalParameters.get(pos);
            result[pos] = fp.getValue(runtimeContext);
        }
        return result;
    }

    public Injectable create(Type genericType, Annotation[] annotations, Member member, boolean encoded, String defaultValue) {
        Class<?> classType = GenericsUtils.getClassType(genericType);
        MatrixParam matrix = null;
        PathParam path = null;
        QueryParam query = null;
        HeaderParam header = null;
        CookieParam cookie = null;
        FormParam form = null;
        Context context = null;
        Injectable injectable = null;
        int annotationsCounter = 0;
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i].annotationType().equals(MatrixParam.class)) {
                matrix = (MatrixParam)annotations[i];
                ++annotationsCounter;
                continue;
            }
            if (annotations[i].annotationType().equals(PathParam.class)) {
                path = (PathParam)annotations[i];
                ++annotationsCounter;
                continue;
            }
            if (annotations[i].annotationType().equals(QueryParam.class)) {
                query = (QueryParam)annotations[i];
                ++annotationsCounter;
                continue;
            }
            if (annotations[i].annotationType().equals(HeaderParam.class)) {
                header = (HeaderParam)annotations[i];
                ++annotationsCounter;
                continue;
            }
            if (annotations[i].annotationType().equals(CookieParam.class)) {
                cookie = (CookieParam)annotations[i];
                ++annotationsCounter;
                continue;
            }
            if (annotations[i].annotationType().equals(FormParam.class)) {
                form = (FormParam)annotations[i];
                ++annotationsCounter;
                continue;
            }
            if (annotations[i].annotationType().equals(Context.class)) {
                context = (Context)annotations[i];
                ++annotationsCounter;
                continue;
            }
            if (annotations[i].annotationType().equals(Encoded.class)) {
                encoded = true;
                continue;
            }
            if (!annotations[i].annotationType().equals(DefaultValue.class)) continue;
            defaultValue = ((DefaultValue)annotations[i]).value();
        }
        if (annotationsCounter > 1) {
            throw new IllegalStateException(Messages.getMessage("conflictingParameterAnnotations", member.getName()));
        }
        injectable = matrix != null ? this.createMatrixParam(matrix.value(), classType, genericType, annotations, member) : (path != null ? this.createPathParam(path.value(), classType, genericType, annotations, member) : (query != null ? this.createQueryParam(query.value(), classType, genericType, annotations, member) : (header != null ? this.createHeaderParam(header.value(), classType, genericType, annotations, member) : (cookie != null ? this.createCookieParam(cookie.value(), classType, genericType, annotations, member) : (form != null ? this.createFormParam(form.value(), classType, genericType, annotations, member) : (context != null ? this.createContextParam(classType, annotations, member) : this.createEntityParam(classType, genericType, annotations, member)))))));
        if (injectable instanceof BoundInjectable) {
            BoundInjectable binding = (BoundInjectable)injectable;
            binding.setEncoded(encoded);
            binding.setDefaultValue(defaultValue);
        }
        return injectable;
    }

    public Injectable createContextParam(Class<?> classType, Annotation[] annotations, Member member) {
        return new ContextParam(classType, annotations, member);
    }

    public Injectable createMatrixParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new NullInjectable(Injectable.ParamType.MATRIX, classType, genericType, annotations, member);
    }

    public Injectable createPathParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new NullInjectable(Injectable.ParamType.PATH, classType, genericType, annotations, member);
    }

    public Injectable createQueryParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new NullInjectable(Injectable.ParamType.QUERY, classType, genericType, annotations, member);
    }

    public Injectable createHeaderParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new NullInjectable(Injectable.ParamType.HEADER, classType, genericType, annotations, member);
    }

    public Injectable createCookieParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new NullInjectable(Injectable.ParamType.COOKIE, classType, genericType, annotations, member);
    }

    public Injectable createFormParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new NullInjectable(Injectable.ParamType.FORM, classType, genericType, annotations, member);
    }

    public Injectable createEntityParam(Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new NullInjectable(Injectable.ParamType.ENTITY, classType, genericType, annotations, member);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextParam
    extends Injectable {
        private ContextAccessor contextAccessor = new ContextAccessor();

        public ContextParam(Class<?> type, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.CONTEXT, type, type, annotations, member);
        }

        @Override
        public Object getValue(RuntimeContext runtimeContext) {
            return this.contextAccessor.getContext(this.getType(), runtimeContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullInjectable
    extends Injectable {
        protected NullInjectable(Injectable.ParamType paramType, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(paramType, type, genericType, annotations, member);
        }

        @Override
        public Object getValue(RuntimeContext runtimeContext) {
            return null;
        }
    }
}

