/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;
import org.apache.wink.common.internal.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartParser {
    public static final String SEP = "\n";
    private static final Logger logger = LoggerFactory.getLogger(MultiPartParser.class);
    private static final String UTF8 = "UTF-8";
    private InputStream is;
    private byte[] boundaryBA;
    private static byte[] boundaryDelimiterBA = "--".getBytes();
    private MultivaluedMap<String, String> partHeaders;
    private PartInputStream partIS;
    private static int BOUNDARY_TYPE_START = 0;
    private static int BOUNDARY_TYPE_END = 1;
    private byte[] buff;
    private int buffIdx = 0;
    private int buffSize = 0;
    private int boundryIdx = -1;
    private int saveIdx = 0;
    private byte[] temp = new byte[1024];

    public MultiPartParser(InputStream is, String boundary) {
        this.is = is;
        try {
            this.boundaryBA = ("--" + boundary).getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Error parsing multi part: " + e.getMessage(), (Throwable)e);
        }
        int buffLength = Math.max(8192, this.boundaryBA.length * 2);
        this.buff = new byte[buffLength];
    }

    private void shiftBuff() {
        System.arraycopy(this.buff, this.buffIdx, this.buff, 0, this.buffSize - this.buffIdx);
        this.buffSize -= this.buffIdx;
        this.saveIdx -= this.buffIdx;
        if (this.saveIdx < 0) {
            this.saveIdx = 0;
        }
        this.boundryIdx = Math.max(-1, this.boundryIdx - this.buffIdx);
        this.buffIdx = 0;
    }

    public boolean nextPart() throws IOException {
        if (this.partIS == null) {
            this.partIS = new PartInputStream();
        }
        this.digestPartStream();
        if (this.digestBoundary() == BOUNDARY_TYPE_END) {
            return false;
        }
        this.partIS.setState(1);
        this.partIS = new PartInputStream();
        this.partHeaders = this.parseHeaders();
        return this.partHeaders != null;
    }

    public InputStream getPartBodyStream() {
        return this.partIS;
    }

    public MultivaluedMap<String, String> getPartHeaders() {
        return this.partHeaders;
    }

    private void digestPartStream() throws IOException {
        while (this.partIS.read(this.temp) != -1) {
        }
    }

    private boolean compareByte(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[aOffset + i] == b[bOffset + i]) continue;
            return false;
        }
        return true;
    }

    private int digestBoundary() throws IOException {
        this.digestNewLine();
        this.buffIdx += this.boundaryBA.length;
        this.saveIdx += this.boundaryBA.length;
        int unredBytes = this.verifyByteReadyForRead(2);
        if (unredBytes >= 2 && this.compareByte(this.buff, this.buffIdx, boundaryDelimiterBA, 0, boundaryDelimiterBA.length)) {
            return BOUNDARY_TYPE_END;
        }
        this.digestNewLine();
        this.boundryIdx = -1;
        this.findBounderyIfNeeded();
        return BOUNDARY_TYPE_START;
    }

    private void findBounderyIfNeeded() {
        if (this.boundryIdx == -1) {
            this.boundryIdx = this.indexOf(this.buff, this.saveIdx, this.buffSize, this.boundaryBA);
            if (this.boundryIdx != -1) {
                int nlSize = 0;
                if (this.boundryIdx > 1) {
                    nlSize = this.buff[this.boundryIdx - 2] == 13 && this.buff[this.boundryIdx - 1] == 10 ? 2 : 1;
                }
                if (this.boundryIdx == 1) {
                    nlSize = 1;
                }
                this.saveIdx = this.boundryIdx - nlSize;
            } else {
                this.saveIdx = Math.max(this.saveIdx, this.buffSize - (this.boundaryBA.length + 2));
            }
        }
    }

    private int verifyByteReadyForRead(int required) throws IOException {
        int unreadBytes = this.buffSize - this.buffIdx - 1;
        if (unreadBytes < required) {
            this.fetch(required - unreadBytes);
            unreadBytes = this.buffSize - this.buffIdx;
        }
        return unreadBytes;
    }

    private int fetch(int minmum) throws IOException {
        int res = 0;
        int max2featch = this.buff.length - this.buffSize;
        if (max2featch < minmum) {
            this.shiftBuff();
            max2featch = this.buff.length - this.buffSize;
        }
        while (res < minmum && max2featch > 0) {
            max2featch = this.buff.length - this.buffSize;
            int read = this.is.read(this.buff, this.buffSize, max2featch);
            if (read == -1) {
                if (res != 0) break;
                return -1;
            }
            res += read;
            this.buffSize += read;
        }
        this.findBounderyIfNeeded();
        return res;
    }

    private void digestNewLine() throws IOException {
        int unreadBytes = this.verifyByteReadyForRead(2);
        int size = 0;
        if (unreadBytes >= 2 && this.buff[this.buffIdx] == 13 && this.buff[this.buffIdx + 1] == 10) {
            size = 2;
        } else if (this.buff[this.buffIdx] == 13) {
            size = 1;
        } else if (this.buff[this.buffIdx] == 10) {
            size = 1;
        }
        this.buffIdx += size;
        if (this.saveIdx < this.buffIdx) {
            this.saveIdx = this.buffIdx;
        }
    }

    private int indexOf(byte[] ba, int start, int end, byte[] what) {
        for (int i = start; i < end - what.length + 1; ++i) {
            if (ba[i] != what[0] || !this.compareByte(ba, i, what, 0, what.length)) continue;
            return i;
        }
        return -1;
    }

    private MultivaluedMap<String, String> parseHeaders() throws IOException {
        String line;
        CaseInsensitiveMultivaluedMap<String> headers = new CaseInsensitiveMultivaluedMap<String>();
        while ((line = this.readLine()) != null && !line.equals("")) {
            int semIdx = line.indexOf(":");
            headers.add(line.substring(0, semIdx).trim(), line.substring(semIdx + 1).trim());
        }
        if (this.saveIdx < this.buffIdx) {
            this.saveIdx = this.buffIdx;
        }
        return headers;
    }

    private String readLine() throws IOException {
        int lineIdx;
        int breakeSize = 0;
        for (lineIdx = 0; lineIdx <= this.verifyByteReadyForRead(lineIdx); ++lineIdx) {
            if (this.buff[this.buffIdx + lineIdx] == 10) {
                breakeSize = 1;
                break;
            }
            if (this.buff[this.buffIdx + lineIdx] != 13) continue;
            if (this.verifyByteReadyForRead(lineIdx + 1) >= lineIdx + 1 && this.buff[this.buffIdx + lineIdx + 1] == 10) {
                breakeSize = 2;
                break;
            }
            breakeSize = 1;
            break;
        }
        if (lineIdx == 0) {
            this.buffIdx += breakeSize;
            return null;
        }
        String hdr = new String(this.buff, this.buffIdx, lineIdx, UTF8);
        this.buffIdx += lineIdx + breakeSize;
        return hdr;
    }

    public class PartInputStream
    extends InputStream {
        private int state = 0;
        public static final int STATE_ACTIVE = 0;
        public static final int STATE_NOT_ACTIVE = 1;

        public void setState(int status) {
            this.state = status;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.state == 1) {
                throw new IOException(Messages.getMessage("multiPartStreamAlreadyClosed"));
            }
            int available = this.verifyNumOfByteToReadB4Boundary(len);
            if (available < 1) {
                return available;
            }
            int size2copy = Math.min(len, available);
            System.arraycopy(MultiPartParser.this.buff, MultiPartParser.this.buffIdx, b, off, size2copy);
            MultiPartParser.this.buffIdx += size2copy;
            return size2copy;
        }

        public int read() throws IOException {
            if (this.state == 1) {
                throw new IOException(Messages.getMessage("multiPartStreamAlreadyClosed"));
            }
            int i = this.verifyNumOfByteToReadB4Boundary(1);
            if (i < 1) {
                return -1;
            }
            int res = MultiPartParser.this.buff[MultiPartParser.this.buffIdx] & 0xFF;
            if (res < 0) {
                int t = 0;
                ++t;
            }
            MultiPartParser.this.buffIdx++;
            return res;
        }

        private int verifyNumOfByteToReadB4Boundary(int minmum) throws IOException {
            int availabe = MultiPartParser.this.saveIdx - MultiPartParser.this.buffIdx;
            if (availabe >= minmum) {
                return availabe;
            }
            if (MultiPartParser.this.saveIdx <= MultiPartParser.this.boundryIdx) {
                if (availabe == 0) {
                    return -1;
                }
                return availabe;
            }
            int fetched = MultiPartParser.this.fetch(minmum - availabe);
            availabe = MultiPartParser.this.saveIdx - MultiPartParser.this.buffIdx;
            if (availabe == 0 && fetched == -1) {
                return -1;
            }
            return availabe;
        }

        public int available() {
            return MultiPartParser.this.saveIdx - MultiPartParser.this.buffIdx;
        }
    }
}

