/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.wink.common.internal.lifecycle.JSR250PrototypeObjectFactory;
import org.apache.wink.common.internal.lifecycle.JSR250SingletonObjectFactory;
import org.apache.wink.common.internal.lifecycle.LifecycleManagerUtils;
import org.apache.wink.common.internal.lifecycle.ObjectCreationException;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR250LifecycleManagerUtils
extends LifecycleManagerUtils {
    private static Logger logger = LoggerFactory.getLogger(JSR250LifecycleManagerUtils.class);
    private static Map<Class, PreDestroyMethod> preDestroyMethodCache = new HashMap<Class, PreDestroyMethod>();
    private static Map<Class, PostConstructMethod> postConstructMethodCache = new HashMap<Class, PostConstructMethod>();

    public static <T> ObjectFactory<T> createSingletonObjectFactory(T object) {
        ObjectFactory<T> factory = LifecycleManagerUtils.createSingletonObjectFactory(object);
        JSR250LifecycleManagerUtils.executePostConstructMethod(factory.getInstance(null));
        return new JSR250SingletonObjectFactory<T>(factory.getInstance(null));
    }

    public static <T> ObjectFactory<T> createSingletonObjectFactory(Class<T> cls) {
        ObjectFactory<T> factory = LifecycleManagerUtils.createSingletonObjectFactory(cls);
        JSR250LifecycleManagerUtils.executePostConstructMethod(factory.getInstance(null));
        return new JSR250SingletonObjectFactory<T>(factory.getInstance(null));
    }

    public static <T> ObjectFactory<T> createPrototypeObjectFactory(Class<T> cls) {
        ClassMetadata classMetadata = JSR250LifecycleManagerUtils.collectClassMetadata(cls, true);
        return new JSR250PrototypeObjectFactory(classMetadata);
    }

    protected static <T> void executePostConstructMethod(T object) throws ObjectCreationException {
        if (object != null) {
            Method m;
            if (postConstructMethodCache.containsKey(object.getClass())) {
                Method m2 = postConstructMethodCache.get(object.getClass()).getMethod();
                if (m2 != null) {
                    JSR250LifecycleManagerUtils.invokeMethod(object, m2, null);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Invoked PostConstruct annotated method {} for class {}", new Object[]{m2, object.getClass()});
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.trace("No PostConstruct annotated method found for class {}", new Object[]{object.getClass()});
                }
                return;
            }
            postConstructMethodCache.put(object.getClass(), new PostConstructMethod(null));
            List<Method> methods = JSR250LifecycleManagerUtils.getMethods(object.getClass());
            for (final Method method : methods) {
                if (!JSR250LifecycleManagerUtils.isPostConstruct(method)) continue;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws InvocationTargetException, IllegalAccessException {
                            if (!method.isAccessible()) {
                                method.setAccessible(true);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new ObjectCreationException(e.getException());
                }
                postConstructMethodCache.put(object.getClass(), new PostConstructMethod(method));
                JSR250LifecycleManagerUtils.invokeMethod(object, method, null);
                break;
            }
            if ((m = postConstructMethodCache.get(object.getClass()).getMethod()) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Invoked and cached PostConstruct annotated method {} for class {}", new Object[]{m, object.getClass()});
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace("No PostConstruct annotated method found for class {}, null value cached", new Object[]{object.getClass()});
            }
        }
    }

    protected static <T> void executePreDestroyMethod(T object) throws ObjectCreationException {
        if (object != null) {
            Method m;
            if (preDestroyMethodCache.containsKey(object.getClass())) {
                Method m2 = preDestroyMethodCache.get(object.getClass()).getMethod();
                if (m2 != null) {
                    JSR250LifecycleManagerUtils.invokeMethod(object, m2, null);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Invoked PreDestroy annotated method {} for class {}", new Object[]{m2, object.getClass()});
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.trace("No PreDestroy annotated method found for class {}", new Object[]{object.getClass()});
                }
                return;
            }
            preDestroyMethodCache.put(object.getClass(), new PreDestroyMethod(null));
            List<Method> methods = JSR250LifecycleManagerUtils.getMethods(object.getClass());
            for (final Method method : methods) {
                if (!JSR250LifecycleManagerUtils.isPreDestroy(method)) continue;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws InvocationTargetException, IllegalAccessException {
                            if (!method.isAccessible()) {
                                method.setAccessible(true);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new ObjectCreationException(e.getException());
                }
                preDestroyMethodCache.put(object.getClass(), new PreDestroyMethod(method));
                JSR250LifecycleManagerUtils.invokeMethod(object, method, null);
                break;
            }
            if ((m = preDestroyMethodCache.get(object.getClass()).getMethod()) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Invoked and cached PreDestroy annotated method {} for class {}", new Object[]{m, object.getClass()});
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace("No PreDestroy annotated method found for class {}, null value cached", new Object[]{object.getClass()});
            }
        }
    }

    protected static boolean hasJSR250AnnotatedMethod(Class clazz) {
        List<Method> methods = JSR250LifecycleManagerUtils.getMethods(clazz);
        for (Method method : methods) {
            if (!JSR250LifecycleManagerUtils.isPreDestroy(method) && !JSR250LifecycleManagerUtils.isPostConstruct(method)) continue;
            return true;
        }
        return false;
    }

    private static void invokeMethod(final Object object, final Method m, final Object[] params) throws ObjectCreationException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InvocationTargetException, IllegalAccessException {
                    return m.invoke(object, params);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ObjectCreationException(e.getException());
        }
    }

    private static List<Method> getMethods(final Class beanClass) {
        List methods = (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<Method> methods = new ArrayList<Method>();
                for (Class cls = beanClass; cls != null; cls = cls.getSuperclass()) {
                    Method[] methodArray;
                    for (Method method : methodArray = cls.getDeclaredMethods()) {
                        methods.add(method);
                    }
                }
                return methods;
            }
        });
        return methods;
    }

    private static boolean isPostConstruct(final Method method) {
        int i$ = 0;
        Annotation[] annotations = (Annotation[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getDeclaredAnnotations();
            }
        });
        Annotation[] arr$ = annotations;
        int len$ = arr$.length;
        if (i$ < len$) {
            Annotation annotation = arr$[i$];
            return PostConstruct.class.isAssignableFrom(annotation.annotationType());
        }
        return false;
    }

    private static boolean isPreDestroy(final Method method) {
        int i$ = 0;
        Annotation[] annotations = (Annotation[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return method.getDeclaredAnnotations();
            }
        });
        Annotation[] arr$ = annotations;
        int len$ = arr$.length;
        if (i$ < len$) {
            Annotation annotation = arr$[i$];
            return PreDestroy.class.isAssignableFrom(annotation.annotationType());
        }
        return false;
    }

    private static class PostConstructMethod {
        private Method m;

        public PostConstructMethod(Method _m) {
            this.m = _m;
        }

        public Method getMethod() {
            return this.m;
        }
    }

    private static class PreDestroyMethod {
        private Method m;

        public PreDestroyMethod(Method _m) {
            this.m = _m;
        }

        public Method getMethod() {
            return this.m;
        }
    }
}

