/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.log;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.handlers.OutputStreamAdapter;
import org.apache.wink.client.internal.log.Responses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Requests
implements ClientHandler {
    private static final Logger logger = LoggerFactory.getLogger(Requests.class);
    private static final int BREAK_POINT = Integer.valueOf(System.getProperty(Responses.class.getName() + ".breakPoint", "4096"));
    private static final boolean IS_LOGGED_AS_BYTES = Boolean.valueOf(System.getProperty(Responses.class.getName() + ".logAsBytes", "false"));
    private static final int BUFFER_SIZE = Integer.valueOf(System.getProperty(Responses.class.getName() + ".bufferSize", "8192"));

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        try {
            MultivaluedMap<String, String> headers = request.getHeaders();
            if (headers != null && headers.size() > 0) {
                Set headerKeys = headers.keySet();
                if (headerKeys.contains(null)) {
                    headerKeys.remove(null);
                }
                ArrayList keys = new ArrayList(headerKeys);
                StringBuilder sb = new StringBuilder();
                if (keys != null) {
                    Collections.sort(keys);
                    Formatter f = new Formatter(sb);
                    for (String k : keys) {
                        List values = (List)headers.get((Object)k);
                        for (String v : values) {
                            f.format("%n%1$-30s%2$s", k, v);
                        }
                    }
                }
                logger.debug("The sent request headers:{}", (Object)sb);
            } else {
                logger.debug("There were no custom headers written on the request.");
            }
        }
        catch (Exception e) {
            logger.trace("Caught exception while trying to log request headers.", (Throwable)e);
        }
        LoggedOutputStreamAdapter adapterOS = new LoggedOutputStreamAdapter();
        context.addOutputStreamAdapter(adapterOS);
        ClientResponse response = context.doChain(request);
        try {
            LoggedOutputStream loggedOutputStream = adapterOS.getLoggedOutputStream();
            if (loggedOutputStream == null || loggedOutputStream.getLoggedByteBufferLength() == 0) {
                logger.debug("A request entity was not written to the server.");
                return response;
            }
            byte[] buffer = loggedOutputStream.getLoggedByteBuffer();
            int bufferLength = loggedOutputStream.getLoggedByteBufferLength();
            if (IS_LOGGED_AS_BYTES) {
                logger.debug("The request entity as bytes:");
                StringBuffer sb = new StringBuffer();
                int outputCount = 0;
                for (int count = 0; count < bufferLength; ++count) {
                    sb.append(String.format("%#04x ", buffer[count]));
                    sb.append(" ");
                    if (++outputCount <= BREAK_POINT) continue;
                    logger.debug("{}", (Object)sb);
                    sb = new StringBuffer();
                    outputCount = 0;
                }
                if (outputCount > 0) {
                    logger.debug("{}", (Object)sb);
                    sb = new StringBuffer();
                }
            } else {
                int length;
                logger.debug("The request entity as a String in the default encoding:");
                for (int offset = 0; offset < bufferLength; offset += length) {
                    length = bufferLength - offset;
                    if (length > BREAK_POINT) {
                        length = BREAK_POINT;
                    }
                    String str = new String(buffer, offset, length);
                    logger.debug("{}", (Object)str);
                }
            }
        }
        catch (Exception e) {
            logger.trace("Caught exception while trying to log request entity.", (Throwable)e);
        }
        return response;
    }

    public static class LoggedOutputStreamAdapter
    implements OutputStreamAdapter {
        private LoggedOutputStream loggedOS;

        public OutputStream adapt(OutputStream os, ClientRequest request) throws IOException {
            this.loggedOS = new LoggedOutputStream(os, BUFFER_SIZE);
            return this.loggedOS;
        }

        public LoggedOutputStream getLoggedOutputStream() {
            return this.loggedOS;
        }
    }

    public static class LoggedOutputStream
    extends OutputStream {
        private final OutputStream originalRequest;
        private final byte[] responseBuffer;
        private int offset = 0;

        public LoggedOutputStream(OutputStream originalRequest, int bufferSize) {
            this.originalRequest = originalRequest;
            this.responseBuffer = new byte[bufferSize];
        }

        public void write(int b) throws IOException {
            if (this.offset < this.responseBuffer.length) {
                this.responseBuffer[this.offset] = (byte)b;
                ++this.offset;
            }
            this.originalRequest.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                int length = len;
                if (len + this.offset >= this.responseBuffer.length) {
                    length = this.responseBuffer.length - this.offset;
                }
                System.arraycopy(b, off, this.responseBuffer, this.offset, length);
                this.offset += length;
            }
            this.originalRequest.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            if (b.length > 0) {
                int length = b.length;
                if (b.length + this.offset >= this.responseBuffer.length) {
                    length = this.responseBuffer.length - this.offset;
                }
                System.arraycopy(b, 0, this.responseBuffer, this.offset, length);
                this.offset += length;
            }
            this.originalRequest.write(b);
        }

        public int getLoggedByteBufferLength() {
            return this.offset;
        }

        public byte[] getLoggedByteBuffer() {
            return this.responseBuffer;
        }

        public void close() throws IOException {
            this.originalRequest.close();
        }

        public void flush() throws IOException {
            this.originalRequest.flush();
        }
    }
}

