/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.EntityType;
import org.apache.wink.client.internal.ClientRuntimeContext;
import org.apache.wink.client.internal.handlers.BaseRequestResponseImpl;
import org.apache.wink.client.internal.log.Responses;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.utils.ProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponseImpl
extends BaseRequestResponseImpl
implements ClientResponse {
    private static final Logger logger = LoggerFactory.getLogger(ClientResponseImpl.class);
    private static final Logger responsesLogger = LoggerFactory.getLogger(Responses.class);
    private Object entity;
    private String message;
    private int status;
    private Runnable contentConsumer;

    @Override
    public <T> T getEntity(Class<T> type) {
        return this.getEntity(type, type);
    }

    @Override
    public <T> T getEntity(EntityType<T> entityType) {
        return this.getEntity(entityType.getRawClass(), entityType.getType());
    }

    private <T> T getEntity(Class<T> type, Type genericType) {
        if (type.isInstance(this.entity)) {
            return (T)this.entity;
        }
        if (this.entity instanceof InputStream) {
            T t = this.readEntity(type, genericType, (InputStream)this.entity);
            this.setEntity(t);
            return t;
        }
        if (this.entity == null) {
            return null;
        }
        throw new ClassCastException(Messages.getMessage("clientCannotConvertEntity", this.entity.getClass().getName(), type.getName()));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getStatusCode() {
        return this.status;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setStatusCode(int code) {
        this.status = code;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readEntity(Class<T> type, Type genericType, InputStream is) {
        Object object;
        if (type == null) {
            return null;
        }
        if (ClientResponse.class.equals(type)) {
            return (T)this;
        }
        ProvidersRegistry providersRegistry = this.getAttribute(ProvidersRegistry.class);
        RuntimeContext saved = RuntimeContextTLS.getRuntimeContext();
        ClientRuntimeContext runtimeContext = new ClientRuntimeContext(providersRegistry);
        RuntimeContextTLS.setRuntimeContext(runtimeContext);
        Responses.LoggedInputStream loggedIS = null;
        try {
            Object entity;
            MediaType contentMediaType;
            MessageBodyReader<T> reader;
            String contentType = (String)this.getHeaders().getFirst((Object)"Content-Type");
            if (contentType == null || contentType.length() == 0) {
                contentType = "application/octet-stream";
            }
            if ((reader = providersRegistry.getMessageBodyReader(type, genericType, null, contentMediaType = MediaType.valueOf((String)contentType), runtimeContext)) == null) {
                throw new RuntimeException(Messages.getMessage("clientNoReaderForTypeAndMediaType", String.valueOf(type), contentType));
            }
            ClientResponseImpl.logUserProviderCall(reader, ProviderUtils.PROVIDER_EXCEPTION_ORIGINATOR.readFrom, new Object[]{type, genericType, null, contentMediaType, this.getHeaders(), is});
            if (responsesLogger.isDebugEnabled()) {
                loggedIS = new Responses.LoggedInputStream(is, Responses.BUFFER_SIZE);
                is = loggedIS;
            }
            object = entity = reader.readFrom(type, genericType, null, contentMediaType, this.getHeaders(), is);
        }
        catch (WebApplicationException e) {
            try {
                throw new ClientRuntimeException(e);
                catch (IOException e2) {
                    throw new ClientRuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                RuntimeContextTLS.setRuntimeContext(saved);
                this.consumeContent();
                try {
                    if (loggedIS == null) throw throwable;
                    Responses.log(loggedIS);
                    throw throwable;
                }
                catch (Exception e3) {
                    logger.trace("Exception while trying to log server response content", (Throwable)e3);
                }
                throw throwable;
            }
        }
        RuntimeContextTLS.setRuntimeContext(saved);
        this.consumeContent();
        try {
            if (loggedIS == null) return (T)object;
            Responses.log(loggedIS);
            return (T)object;
        }
        catch (Exception e) {
            logger.trace("Exception while trying to log server response content", (Throwable)e);
        }
        return (T)object;
    }

    @Override
    public void consumeContent() {
        if (this.contentConsumer != null) {
            this.contentConsumer.run();
        }
    }

    public void setContentConsumer(Runnable contentConsumer) {
        this.contentConsumer = contentConsumer;
    }

    public Runnable getContentConsumer() {
        return this.contentConsumer;
    }

    @Override
    public Response.StatusType getStatusType() {
        Object statusType = Response.Status.fromStatusCode((int)this.status);
        if (statusType == null) {
            statusType = new ClientStatusType(this.status, this.message);
        }
        return statusType;
    }

    public static void logUserProviderCall(Object obj, ProviderUtils.PROVIDER_EXCEPTION_ORIGINATOR originator, Object[] methodParams) {
        try {
            ArrayList<Object> dataToFormattedString = new ArrayList<Object>();
            dataToFormattedString.add(obj.getClass().getName());
            dataToFormattedString.add((Object)originator);
            for (int i = 0; i < methodParams.length; ++i) {
                dataToFormattedString.add(methodParams[i]);
            }
            String debugMsgFormat = "Calling %s.%s( ";
            for (int i = 0; i < methodParams.length; ++i) {
                debugMsgFormat = debugMsgFormat + "%s";
                if (i >= methodParams.length) continue;
                debugMsgFormat = debugMsgFormat + ", ";
            }
            String newLine = System.getProperty("line.separator");
            debugMsgFormat = debugMsgFormat + " )" + newLine;
            String debugMsg = String.format(debugMsgFormat, dataToFormattedString.toArray(new Object[0]));
            logger.debug(debugMsg);
        }
        catch (Throwable t) {
            logger.trace("Could not format log output for exception originating in provider.", t);
        }
    }

    static class ClientStatusType
    implements Response.StatusType {
        final int statusCode;
        final String reasonPhrase;

        public ClientStatusType(int statusCode, String reasonPhrase) {
            this.statusCode = statusCode;
            this.reasonPhrase = reasonPhrase;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public Response.Status.Family getFamily() {
            int family = this.statusCode / 100;
            if (family == 1) {
                return Response.Status.Family.INFORMATIONAL;
            }
            if (family == 2) {
                return Response.Status.Family.SUCCESSFUL;
            }
            if (family == 3) {
                return Response.Status.Family.REDIRECTION;
            }
            if (family == 4) {
                return Response.Status.Family.CLIENT_ERROR;
            }
            if (family == 5) {
                return Response.Status.Family.SERVER_ERROR;
            }
            return Response.Status.Family.OTHER;
        }

        public int hashCode() {
            return this.statusCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Response.StatusType)) {
                return false;
            }
            Response.StatusType other = (Response.StatusType)obj;
            return this.statusCode == other.getStatusCode();
        }

        public String toString() {
            return this.reasonPhrase;
        }
    }
}

