/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.handlers;

import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.AbstractAuthSecurityHandler;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.common.http.HttpStatus;
import org.apache.wink.common.internal.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthSecurityHandler
extends AbstractAuthSecurityHandler
implements ClientHandler {
    private static Logger logger = LoggerFactory.getLogger(BasicAuthSecurityHandler.class);
    private static final int UNAUTHORIZED = HttpStatus.UNAUTHORIZED.getCode();

    public BasicAuthSecurityHandler() {
    }

    public BasicAuthSecurityHandler(String username, String password) {
        super(username, password);
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        logger.trace("Entering BasicAuthSecurityHandler.doChain()");
        if (this.isSSLRequired() && !request.getURI().getScheme().equalsIgnoreCase("https")) {
            logger.debug("Cannot send user credentials over a non-SSL connection");
            throw new ClientAuthenticationException(Messages.getMessage("userCredNotAllowedOverNonSSLConnection"));
        }
        ClientResponse response = context.doChain(request);
        if (response.getStatusCode() == UNAUTHORIZED) {
            this.initUsernameAndPasswordVarsFromProps("user", "password");
            if (this.handlerUsername != null && !this.handlerUsername.equals("") && this.handlerPassword != null && !this.handlerPassword.equals("")) {
                logger.trace("userid and password set so setting Authorization header");
                if (this.handlerEncodedCredentials == null) {
                    this.handlerEncodedCredentials = BasicAuthSecurityHandler.getEncodedString(this.handlerUsername, this.handlerPassword);
                }
                request.getHeaders().putSingle((Object)"Authorization", (Object)this.handlerEncodedCredentials);
                logger.trace("Issuing request again with Authorization header");
                response = context.doChain(request);
                if (response.getStatusCode() == UNAUTHORIZED) {
                    logger.trace("After sending request with Authorization header, still got " + UNAUTHORIZED + " response");
                    throw new ClientAuthenticationException(Messages.getMessage("serviceFailedToAuthenticateUser", this.handlerUsername));
                }
                logger.trace("Got a non-" + UNAUTHORIZED + " response, so returning response");
                return response;
            }
            logger.trace("user and/or password were not set so throwing exception");
            throw new ClientAuthenticationException(Messages.getMessage("missingClientAuthenticationCredentialForUser", this.handlerUsername));
        }
        logger.trace("Status code was not " + UNAUTHORIZED + " so no need to re-issue request.");
        return response;
    }
}

