/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAuthSecurityHandler {
    private static Logger logger = LoggerFactory.getLogger(AbstractAuthSecurityHandler.class);
    private static final String PROPS_FILE_NAME = "wink.client.props";
    private static Properties clientProps = null;
    private static volatile boolean propsLoaded = false;
    protected volatile String handlerUsername = null;
    protected volatile String handlerPassword = null;
    protected volatile boolean sslRequired = true;
    protected volatile String handlerEncodedCredentials = null;

    public AbstractAuthSecurityHandler() {
    }

    public AbstractAuthSecurityHandler(String username, String password) {
        this.setUserName(username);
        this.setPassword(password);
    }

    public void setUserName(String aUserName) {
        logger.trace("Setting the username to {}", (Object)aUserName);
        this.handlerUsername = aUserName;
        this.handlerEncodedCredentials = null;
    }

    public void setPassword(String aPassword) {
        logger.trace("Setting the password");
        this.handlerPassword = aPassword;
        this.handlerEncodedCredentials = null;
    }

    protected static String getEncodedString(String userid, String password) {
        String credential = userid + ":" + password;
        byte[] credBytes = credential.getBytes();
        byte[] encodedCredBytes = Base64.encodeBase64((byte[])credBytes, (boolean)false);
        String credEncodedString = "Basic " + new String(encodedCredBytes);
        return credEncodedString;
    }

    protected void initUsernameAndPasswordVarsFromProps(String useridPropKey, String passwordPropKey) {
        String userid = System.getProperty(useridPropKey);
        String password = System.getProperty(passwordPropKey);
        if (logger.isTraceEnabled()) {
            logger.trace("The '" + useridPropKey + "' system property was set to: {}", (Object)userid);
            logger.trace("The '" + passwordPropKey + "' system property was set: {}", (Object)(password != null ? 1 : 0));
        }
        if (userid != null && !userid.equals("") && password != null && !password.equals("")) {
            this.handlerUsername = userid;
            this.handlerPassword = password;
            return;
        }
        String propsFileDir = System.getProperty("wink.client.props.dir");
        logger.trace("Could NOT get " + useridPropKey + " and " + passwordPropKey + " from system properties so attempting to look at properties file in {}", (Object)propsFileDir);
        if (propsFileDir != null && !propsFileDir.equals("")) {
            if (!propsLoaded) {
                clientProps = AbstractAuthSecurityHandler.loadProps(propsFileDir + File.separator + PROPS_FILE_NAME);
            }
            this.handlerUsername = clientProps.getProperty(useridPropKey);
            this.handlerPassword = clientProps.getProperty(passwordPropKey);
        } else {
            logger.trace("Could NOT find properties file so using variables assigned to handler itself", (Object)propsFileDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Properties loadProps(String propsFileName) {
        Properties props = null;
        FileInputStream fis = null;
        try {
            File propsFile = new File(propsFileName);
            props = new Properties();
            fis = new FileInputStream(propsFile);
            props.load(fis);
            propsLoaded = true;
        }
        catch (IOException e) {
            props = null;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public void setSSLRequired(boolean sslUse) {
        logger.trace("Setting SSL requirement to {}", (Object)sslUse);
        this.sslRequired = sslUse;
    }

    public boolean isSSLRequired() {
        logger.trace("isSSLRequired {}", (Object)this.sslRequired);
        return this.sslRequired;
    }
}

