/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.Resource;
import org.apache.wink.client.internal.ResourceImpl;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.application.ApplicationValidator;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ScopeLifecycleManager;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClient {
    private static final Logger logger;
    private ProvidersRegistry providersRegistry;
    private ClientConfig config;
    protected static SSLConfigStatus sslConfigStatus;

    public RestClient() {
        this(new ClientConfig());
    }

    public RestClient(ClientConfig config) {
        ClientConfig clone = config.clone();
        this.config = clone.build();
        this.initProvidersRegistry();
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public Resource resource(URI uri) {
        return new ResourceImpl(uri, this.config, this.providersRegistry);
    }

    public Resource resource(String uri) {
        return this.resource(URI.create(uri));
    }

    public Resource resource(String uri, boolean httpEncode) throws MalformedURLException, URISyntaxException {
        if (httpEncode) {
            URL url = new URL(uri);
            URI constructedURI = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
            return this.resource(constructedURI);
        }
        return this.resource(URI.create(uri));
    }

    private void initProvidersRegistry() {
        LifecycleManagersRegistry ofFactoryRegistry = new LifecycleManagersRegistry();
        ofFactoryRegistry.addFactoryFactory(new ScopeLifecycleManager());
        this.providersRegistry = new ProvidersRegistry(ofFactoryRegistry, new ApplicationValidator());
        for (Application app : this.config.getApplications()) {
            this.processApplication(app);
        }
    }

    private void processApplication(Application application) {
        Set classes;
        if (application == null) {
            return;
        }
        Set singletons = application.getSingletons();
        if (singletons != null && singletons.size() > 0) {
            this.processSingletons(singletons);
        }
        if ((classes = application.getClasses()) != null && classes.size() > 0) {
            this.processClasses(classes);
        }
        if (application instanceof WinkApplication) {
            this.processWinkApplication((WinkApplication)application);
        }
    }

    private void processClasses(Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            if (ProviderMetadataCollector.isProvider(cls)) {
                try {
                    this.providersRegistry.addProvider(cls);
                }
                catch (Exception e) {
                    if (!cls.getCanonicalName().contains("com.ibm.websphere.jaxrs.providers.json4j")) {
                        logger.error(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls), (Throwable)e);
                        continue;
                    }
                    logger.trace(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getCanonicalName()), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    if (!cls.getCanonicalName().contains("com.ibm.websphere.jaxrs.providers.json4j")) {
                        logger.error(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getCanonicalName()), (Throwable)e);
                        continue;
                    }
                    logger.trace(Messages.getMessage("exceptionOccurredDuringClassProcessing", cls.getCanonicalName()), (Throwable)e);
                }
                continue;
            }
            logger.warn(Messages.getMessage("classNotAProvider", cls));
        }
    }

    private void processSingletons(Set<Object> singletons) {
        for (Object obj : singletons) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                try {
                    this.providersRegistry.addProvider(obj);
                }
                catch (Exception e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringSingletonProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                continue;
            }
            logger.warn(Messages.getMessage("classNotAProvider", obj));
        }
    }

    private void processWinkApplication(WinkApplication sApplication) {
        Set<Object> instances = sApplication.getInstances();
        double priority = sApplication.getPriority();
        if (instances == null) {
            return;
        }
        for (Object obj : instances) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                try {
                    this.providersRegistry.addProvider(obj, priority);
                }
                catch (Exception e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    logger.error(Messages.getMessage("exceptionOccurredDuringInstanceProcessing", obj.getClass().getCanonicalName()), (Throwable)e);
                }
                continue;
            }
            logger.warn(Messages.getMessage("classNotAProvider", cls));
        }
    }

    static {
        block8: {
            block7: {
                logger = LoggerFactory.getLogger(RestClient.class);
                sslConfigStatus = SSLConfigStatus.INCOMPLETE;
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                String serverSocketFactoryProvider;
                                String socketFactoryProvider = Security.getProperty("ssl.SocketFactory.provider");
                                if ("com.ibm.websphere.ssl.protocol.SSLSocketFactory".equals(socketFactoryProvider)) {
                                    try {
                                        Class.forName(socketFactoryProvider);
                                        logger.trace("RestClient static security block {} class exists for ssl.SocketFactory.provider", (Object)socketFactoryProvider);
                                    }
                                    catch (Throwable t) {
                                        try {
                                            Class.forName("com.ibm.jsse2.SSLSocketFactoryImpl");
                                            Security.setProperty("ssl.SocketFactory.provider", "com.ibm.jsse2.SSLSocketFactoryImpl");
                                            logger.trace("RestClient static security block {} class exists for ssl.SocketFactory.provider", (Object)socketFactoryProvider);
                                        }
                                        catch (Throwable t2) {
                                            logger.trace("RestClient static security block com.ibm.jsse2.SSLSocketFactoryImpl class does NOT exist for ssl.SocketFactory.provider");
                                        }
                                    }
                                }
                                if ("com.ibm.websphere.ssl.protocol.SSLServerSocketFactory".equals(serverSocketFactoryProvider = Security.getProperty("ssl.ServerSocketFactory.provider"))) {
                                    try {
                                        Class.forName(serverSocketFactoryProvider);
                                        logger.trace("RestClient static security block {} class exists for ssl.ServerSocketFactory.provider", (Object)serverSocketFactoryProvider);
                                    }
                                    catch (Throwable t) {
                                        try {
                                            Class.forName("com.ibm.jsse2.SSLServerSocketFactoryImpl");
                                            Security.setProperty("ssl.ServerSocketFactory.provider", "com.ibm.jsse2.SSLServerSocketFactoryImpl");
                                            logger.trace("RestClient static security block {} class exists for ssl.ServerSocketFactory.provider", (Object)serverSocketFactoryProvider);
                                        }
                                        catch (Throwable t2) {
                                            logger.trace("RestClient static security block com.ibm.jsse2.SSLServerSocketFactoryImpl class does NOT exist for ssl.ServerSocketFactory.provider");
                                        }
                                    }
                                }
                                return true;
                            }
                            catch (Throwable t) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("RestClient security static block in doPriviledged", t);
                                }
                                return false;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) break block7;
                    logger.trace("RestClient security static block", (Throwable)e);
                }
            }
            Class<?> sslConfigManagerClass = null;
            String managerClass = "com.ibm.ws.jaxrs.wink.client.RestClientSSLConfigManager";
            try {
                sslConfigManagerClass = Class.forName(managerClass);
            }
            catch (ClassNotFoundException e1) {
                sslConfigStatus = SSLConfigStatus.FAILED;
                logger.trace("RestClient static block could not initialize SSL due to ClassNotFoundException for: " + managerClass);
            }
            if (sslConfigManagerClass != null) {
                try {
                    logger.trace("RestClient static block initializer for SSL");
                    Object sslConfigManager = sslConfigManagerClass.newInstance();
                    Method methodInitializeSSL = sslConfigManager.getClass().getMethod("initializeSSL", new Class[0]);
                    methodInitializeSSL.invoke(sslConfigManager, (Object[])null);
                    logger.trace("RestClient done with static block initializer for SSL");
                    sslConfigStatus = SSLConfigStatus.COMPLETE;
                }
                catch (Throwable t) {
                    sslConfigStatus = SSLConfigStatus.FAILED;
                    if (!logger.isTraceEnabled()) break block8;
                    logger.trace("RestClient static block could not intitializeClientSSL due to: ", t);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SSLConfigStatus {
        INCOMPLETE,
        COMPLETE,
        FAILED;

    }
}

