/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.jaxrs.providers.json4j;

import com.ibm.json.java.JSONObject;
import com.ibm.json.xml.XMLToJSONTransformer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.internal.providers.entity.xml.JAXBXmlProvider;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json", "application/javascript"})
@Produces(value={"application/json", "application/javascript"})
public class JSON4JJAXBProvider
implements MessageBodyWriter<Object> {
    @Context
    private Providers providers;
    private volatile MessageBodyWriter<JSONObject> bodyWriter;

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!JAXBXmlProvider.isJAXBObject(type, genericType) && !JAXBXmlProvider.isJAXBElement(type, genericType)) {
            return false;
        }
        if (this.bodyWriter == null) {
            this.bodyWriter = this.providers.getMessageBodyWriter(JSONObject.class, JSONObject.class, annotations, mediaType);
            if (this.bodyWriter == null) {
                return false;
            }
        }
        return true;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyWriter jaxbWriter = this.providers.getMessageBodyWriter(type, genericType, annotations, MediaType.APPLICATION_XML_TYPE);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, mediaType);
        jaxbWriter.writeTo(t, type, genericType, annotations, MediaType.APPLICATION_XML_TYPE, httpHeaders, (OutputStream)os);
        try {
            XMLToJSONTransformer.transform((InputStream)new ByteArrayInputStream(os.toByteArray()), (OutputStream)entityStream);
        }
        catch (SAXException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

