/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.appsecurity.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.appsecurity.component.SSLSupportService;
import com.ibm.ws.jaxrs20.appsecurity.security.JaxRsProxySSLSocketFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxRsSSLManager {
    private static final TraceComponent tc = Tr.register(JaxRsSSLManager.class);
    static final long serialVersionUID = -6831088170268315856L;

    public static SSLSocketFactory getProxySSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props) {
        return new JaxRsProxySSLSocketFactory(sslRef, props);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={PrivilegedActionException.class})
    public static SSLSocketFactory getSSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props, boolean fallbackOnDefault) {
        if (!SSLSupportService.isSSLSupportServiceReady()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The SSL support service is not ready and can't create SSLSocketFactory", (Object[])new Object[0]);
            }
            return null;
        }
        SSLSupport sslSupportService = SSLSupportService.getSSLSupport();
        JSSEHelper jsseHelper = sslSupportService.getJSSEHelper();
        Properties sslConfig = null;
        SSLConfig sslConfigCopy = null;
        try {
            final JSSEHelper f_jsseHelper = jsseHelper;
            final String f_sslRef = sslRef;
            try {
                sslConfig = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                    static final long serialVersionUID = 4561508428952719639L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Properties run() throws SSLException {
                        try {
                            return f_jsseHelper.getProperties(f_sslRef);
                        }
                        catch (com.ibm.websphere.ssl.SSLException sSLException) {
                            void e;
                            FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$1", (String)"72", (Object)this, (Object[])new Object[0]);
                            Throwable cause = e.getCause();
                            throw (SSLException)cause;
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                throw (SSLException)cause;
            }
            if (null != sslConfig) {
                sslConfigCopy = new SSLConfig(sslConfig);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cannot get the ssl configuration by sslRef=" + sslRef), (Object[])new Object[0]);
                }
                if (fallbackOnDefault) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Try to get the default ssl configuration of server", (Object[])new Object[0]);
                    }
                    try {
                        sslConfig = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                            static final long serialVersionUID = -3126746084723580346L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public Properties run() throws SSLException {
                                try {
                                    return f_jsseHelper.getProperties(null, null, null);
                                }
                                catch (com.ibm.websphere.ssl.SSLException sSLException) {
                                    void e;
                                    FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$2", (String)"103", (Object)this, (Object[])new Object[0]);
                                    Throwable cause = e.getCause();
                                    throw (SSLException)cause;
                                }
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(2.class);
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        throw (SSLException)cause;
                    }
                    if (null != sslConfig) {
                        sslConfigCopy = new SSLConfig(sslConfig);
                    }
                }
            }
            if (null == sslConfigCopy) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The SSL socket factory cannot be created because the SSL reference id " + sslRef + " does not exist in the server.xml file"), (Object[])new Object[0]);
                }
                return null;
            }
            if (null != props && !props.isEmpty()) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(entry.getKey() + "=" + entry.getValue() + " is overriden in SSLConfig=" + sslRef), (Object[])new Object[0]);
                    }
                    sslConfigCopy.put((Object)entry.getKey(), entry.getValue());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Get the SSLSocketFactory by sslRef=" + sslRef), (Object[])new Object[0]);
            }
            return sslSupportService.getJSSEProvider().getSSLSocketFactory(null, sslConfigCopy);
        }
        catch (SSLException f_jsseHelper) {
            void e;
            FFDCFilter.processException((Throwable)f_jsseHelper, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"143", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SSL Exception with ssl ref id " + sslRef + ": " + e.toString()), (Object[])new Object[0]);
            }
            throw new IllegalArgumentException((Throwable)e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"148", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception with ssl ref id " + sslRef + ": " + e.toString()), (Object[])new Object[0]);
            }
            throw new IllegalStateException(e);
        }
    }
}

