/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;

public class Variant {
    private final MediaType mediaType;
    private final Locale language;
    private final String encoding;

    public Variant(MediaType mediaType, Locale language, String encoding) {
        if (mediaType == null && language == null && encoding == null) {
            throw new IllegalArgumentException();
        }
        this.mediaType = mediaType;
        this.language = language;
        this.encoding = encoding;
    }

    public static VariantListBuilder encodings(String ... encodings) {
        return VariantListBuilder.newInstance().encodings(encodings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Variant)) {
            return false;
        }
        Variant other = (Variant)obj;
        String encoding = this.getEncoding();
        if (encoding == null ? other.getEncoding() != null : !encoding.equals(other.getEncoding())) {
            return false;
        }
        Locale locale = this.getLanguage();
        if (locale == null ? other.getLanguage() != null : !locale.equals(other.getLanguage())) {
            return false;
        }
        MediaType mt = this.getMediaType();
        if (mt == null) {
            return other.getMediaType() == null;
        }
        return mt.equals(other.getMediaType());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        return result;
    }

    public static VariantListBuilder languages(Locale ... languages) {
        return VariantListBuilder.newInstance().languages(languages);
    }

    public static VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        return VariantListBuilder.newInstance().mediaTypes(mediaTypes);
    }

    public String toString() {
        return String.format("Variant[mediaType=%s, language=%s, encoding=%s]", this.mediaType == null ? "null" : this.mediaType.toString(), this.language == null ? "null" : this.language.toString(), this.encoding == null ? "null" : this.encoding.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class VariantListBuilder {
        private static final RuntimeDelegate delegate = RuntimeDelegate.getInstance();

        protected VariantListBuilder() {
        }

        public abstract VariantListBuilder add();

        public abstract List<Variant> build();

        public abstract VariantListBuilder encodings(String ... var1);

        public abstract VariantListBuilder languages(Locale ... var1);

        public abstract VariantListBuilder mediaTypes(MediaType ... var1);

        public static VariantListBuilder newInstance() {
            return delegate.createVariantListBuilder();
        }
    }
}

