/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Response {
    private static final RuntimeDelegate delegate = RuntimeDelegate.getInstance();

    protected Response() {
    }

    public static ResponseBuilder created(URI location) {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        return Response.status(Status.CREATED).location(location);
    }

    public static ResponseBuilder fromResponse(Response response) {
        ResponseBuilder builder = delegate.createResponseBuilder();
        builder.status(response.getStatus());
        builder.entity(response.getEntity());
        MultivaluedMap<String, Object> metadata = response.getMetadata();
        for (String key : metadata.keySet()) {
            List values = (List)metadata.get(key);
            for (Object value : values) {
                builder.header(key, value);
            }
        }
        return builder;
    }

    public abstract Object getEntity();

    public abstract MultivaluedMap<String, Object> getMetadata();

    public abstract int getStatus();

    public static ResponseBuilder noContent() {
        return Response.status(Status.NO_CONTENT);
    }

    public static ResponseBuilder notAcceptable(List<Variant> variants) {
        ResponseBuilder builder = Response.status(Status.NOT_ACCEPTABLE);
        if (variants == null) {
            return builder.variants(Collections.EMPTY_LIST);
        }
        return builder.variants(variants);
    }

    public static ResponseBuilder notModified() {
        return Response.status(Status.NOT_MODIFIED);
    }

    public static ResponseBuilder notModified(EntityTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException();
        }
        return Response.status(Status.NOT_MODIFIED).tag(tag);
    }

    public static ResponseBuilder notModified(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException();
        }
        return Response.status(Status.NOT_MODIFIED).tag(tag);
    }

    public static ResponseBuilder ok() {
        return Response.status(Status.OK);
    }

    public static ResponseBuilder ok(Object entity) {
        return Response.status(Status.OK).entity(entity);
    }

    public static ResponseBuilder ok(Object entity, MediaType type) {
        return Response.status(Status.OK).entity(entity).type(type);
    }

    public static ResponseBuilder ok(Object entity, String type) {
        return Response.status(Status.OK).entity(entity).type(type);
    }

    public static ResponseBuilder ok(Object entity, Variant variant) {
        return Response.status(Status.OK).entity(entity).variant(variant);
    }

    public static ResponseBuilder seeOther(URI location) {
        if (location == null) {
            throw new IllegalArgumentException();
        }
        return Response.status(Status.SEE_OTHER).location(location);
    }

    public static ResponseBuilder serverError() {
        return Response.status(Status.INTERNAL_SERVER_ERROR);
    }

    public static ResponseBuilder status(int status) {
        if (status < 100 || status > 599) {
            throw new IllegalArgumentException();
        }
        return ResponseBuilder.newInstance().status(status);
    }

    public static ResponseBuilder status(Status status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        return ResponseBuilder.newInstance().status(status);
    }

    public static ResponseBuilder status(StatusType status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        return ResponseBuilder.newInstance().status(status);
    }

    public static ResponseBuilder temporaryRedirect(URI location) {
        return Response.status(Status.TEMPORARY_REDIRECT).location(location);
    }

    public static interface StatusType {
        public Status.Family getFamily();

        public String getReasonPhrase();

        public int getStatusCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status implements Serializable,
    Comparable<Status>,
    StatusType
    {
        OK(Family.SUCCESSFUL, 200, "OK"),
        CREATED(Family.SUCCESSFUL, 201, "Created"),
        ACCEPTED(Family.SUCCESSFUL, 202, "Accepted"),
        NO_CONTENT(Family.SUCCESSFUL, 204, "No Content"),
        MOVED_PERMANENTLY(Family.REDIRECTION, 301, "Moved Permanently"),
        SEE_OTHER(Family.REDIRECTION, 303, "See Other"),
        NOT_MODIFIED(Family.REDIRECTION, 304, "Not Modified"),
        TEMPORARY_REDIRECT(Family.REDIRECTION, 307, "Temporary Redirect"),
        BAD_REQUEST(Family.CLIENT_ERROR, 400, "Bad Request"),
        UNAUTHORIZED(Family.CLIENT_ERROR, 401, "Unauthorized"),
        FORBIDDEN(Family.CLIENT_ERROR, 403, "Forbidden"),
        NOT_FOUND(Family.CLIENT_ERROR, 404, "Not Found"),
        NOT_ACCEPTABLE(Family.CLIENT_ERROR, 406, "Not Acceptable"),
        CONFLICT(Family.CLIENT_ERROR, 409, "Conflict"),
        GONE(Family.CLIENT_ERROR, 410, "Gone"),
        PRECONDITION_FAILED(Family.CLIENT_ERROR, 412, "Precondition Failed"),
        UNSUPPORTED_MEDIA_TYPE(Family.CLIENT_ERROR, 415, "Unsupported Media Type"),
        INTERNAL_SERVER_ERROR(Family.SERVER_ERROR, 500, "Internal Server Error"),
        SERVICE_UNAVAILABLE(Family.SERVER_ERROR, 503, "Service Unavailable");

        private final Family family;
        private final int statusCode;
        private final String reasonPhrase;

        private Status(Family family, int statusCode, String reasonPhrase) {
            this.family = family;
            this.statusCode = statusCode;
            this.reasonPhrase = reasonPhrase;
        }

        public static Status fromStatusCode(int statusCode) {
            for (Status s : Status.values()) {
                if (s.getStatusCode() != statusCode) continue;
                return s;
            }
            return null;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public Family getFamily() {
            return this.family;
        }

        @Override
        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public String toString() {
            return this.reasonPhrase;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Family {
            CLIENT_ERROR,
            INFORMATIONAL,
            OTHER,
            REDIRECTION,
            SERVER_ERROR,
            SUCCESSFUL;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ResponseBuilder {
        protected ResponseBuilder() {
        }

        public abstract Response build();

        public abstract ResponseBuilder cacheControl(CacheControl var1);

        public abstract ResponseBuilder clone();

        public abstract ResponseBuilder contentLocation(URI var1);

        public abstract ResponseBuilder cookie(NewCookie ... var1);

        public abstract ResponseBuilder entity(Object var1);

        public abstract ResponseBuilder expires(Date var1);

        public abstract ResponseBuilder header(String var1, Object var2);

        public abstract ResponseBuilder language(Locale var1);

        public abstract ResponseBuilder language(String var1);

        public abstract ResponseBuilder lastModified(Date var1);

        public abstract ResponseBuilder location(URI var1);

        protected static ResponseBuilder newInstance() {
            return delegate.createResponseBuilder();
        }

        public abstract ResponseBuilder status(int var1);

        public ResponseBuilder status(Status status) {
            return delegate.createResponseBuilder().status(status.getStatusCode());
        }

        public ResponseBuilder status(StatusType status) {
            return delegate.createResponseBuilder().status(status.getStatusCode());
        }

        public abstract ResponseBuilder tag(EntityTag var1);

        public abstract ResponseBuilder tag(String var1);

        public abstract ResponseBuilder type(MediaType var1);

        public abstract ResponseBuilder type(String var1);

        public abstract ResponseBuilder variant(Variant var1);

        public abstract ResponseBuilder variants(List<Variant> var1);
    }
}

